#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "около 5 часов на devtest",
      comment => "миграцию можно перезапускать"
    }
  ],
  approved_by => 'gukserg'
}

=cut

=head1 DESCRIPTION

    ищем неподписанных пользователей и подписываем

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use ShardingTools;
use Settings;
use Primitives;
use Yandex::Passport;

use List::Util qw/min/;
use POSIX qw/floor/;

$log->out('START');

my $time_interval = 3600 * 24 * 30; # 30 дней

my $lower_bound_prop_prefix = "subscribe_lost_sid_shard";

foreach_shard_parallel_verbose($log, sub {
    my $shard = shift;

    my $lower_bound_prop = Property->new("$lower_bound_prop_prefix\_$shard");
    my $lower_bound = $lower_bound_prop->get();
    if (!defined($lower_bound)) {
        $lower_bound = get_one_field_sql(PPC(shard=>$shard), "SELECT min(createtime) FROM users");
        $lower_bound_prop->set($lower_bound);
    }

    my $val = new Property("ppcPassportAdmsubscribeSlova_shard_$shard")->get();
    my ($upper_bound) = split /;/, $val || '0;';

    my $chunks_num = floor(($upper_bound - $lower_bound) / $time_interval) + 1;

    foreach my $chunk ((1..$chunks_num)) {

        my $start_time = $lower_bound + $chunk * $time_interval;
        my $end_time = min($lower_bound + ($chunk + 1) * $time_interval, $upper_bound);

        $log->msg_prefix("[shard=$shard, chunk $chunk / $chunks_num, $start_time <= createtime < $end_time]");

        my $users_chunk = get_all_sql(PPC(shard => $shard), "
            SELECT login, uid
            FROM users
            WHERE createtime BETWEEN $start_time and $end_time
            AND statusBlocked = 'No'"
        );

        for my $row (@$users_chunk) {
            my $login = $row->{login};

            if ($login =~ /\@/) {
                $log->out("$row->{login} ($row->{uid}) skipped");
                next;
            }

            my $uid;
            eval {
                $uid = get_uid_by_login($login);
            };
            if ($uid){
                if (!check_direct_sid($login)) {
                    my $res = Yandex::Passport::subscribe_service($uid);
                    $log->out("$login ($uid) subscribe " . ($res ? 'error' : 'ok'));
                } else {
                    $log->out("$login ($uid) already subscribed, skipped");
                }
            } else {
                $log->out("user $login not found, skipped");
            }
        }

        $lower_bound_prop->set($end_time);
        $log->out("chunk finished");
    }

    $log->out("shard finished");
});

foreach my $shard (ppc_shards()) {
    my $prop_name = "$lower_bound_prop_prefix\_$shard";
    my $lower_bound_prop = Property->new($prop_name);

    $log->out("property $prop_name value:", $lower_bound_prop->get());
    $lower_bound_prop->delete();
    $log->out("property $prop_name deleted");
}

$log->out('FINISH');
