#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "несколько секунд",
      comment => "можно перезапускать"
    }
  ],
  approved_by => 'sco76'
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

my $tables = [qw/
    shard_inc_bid
    shard_inc_cid
    shard_inc_mediaplan_bid
    shard_inc_pid
    shard_inc_vcard_id
    shard_order_id
/];

my $bad_clientids = [
    34589289,
    34330484,
    48489258,
    46037683,
    37170986,
    47874933,
    44866837,
    42458842,
    38994199,
    38503196,
    44013459,
];


$log->out('START');

for my $table (@$tables) {
    $log->out("process table $table");
    my $data = get_all_sql(PPCDICT, ["select * from $table", where => { ClientID => $bad_clientids }]);
    $log->out({table => $table, old_data => $data});
    my $rows = do_sql(PPCDICT, ["
        UPDATE $table
        SET ClientID = (CASE ClientID
          WHEN 34589289 THEN 34589290
          WHEN 34330484 THEN 34330486
          WHEN 48489258 THEN 48489251
          WHEN 46037683 THEN 46037685
          WHEN 37170986 THEN 37170985
          WHEN 47874933 THEN 47874942
          WHEN 44866837 THEN 44866831
          WHEN 42458842 THEN 42458839
          WHEN 38994199 THEN 38994198
          WHEN 38503196 THEN 38503195
          WHEN 44013459 THEN 44013464 END)",
        where => { ClientID => $bad_clientids }]) + 0;
    $log->out("rows affected $rows");
}

$log->out('FINISH');

