#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "несколько секунд",
      comment => "Можно перезапускать"
    }
  ],
  approved_by => 'gukserg'
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;

use my_inc '..';

use ScriptHelper;
use Settings;

my $DELETE_CHUNK = 500;

my $shard2id = {
    6 => [
      1044445,1044448,1044451,1044452,1044453,1044454,1044455,1044457,1044459,1044460,1044461,1044462,1044463,1044464,1044465,
      1044467,1044468,1044470,1044472,1044474,1044475,1044476,1044478,1044480,1044482,1044483,1044484,1044488,1044489,1044493,
      1044494,1044495,1044498,1044499,1044500,1044501,1044504,1044505,1044506,1044509,1044510,1044512,1044514,1044515,1044517,
      1044518,1044519,1044521,1044522,1044523,1044526,1044528,1044529,1044530,1044531,1044532,1044535,1044537,1044540,1044541,
      1044543,1044545,1044546,1044548,1044550,1044552,1044553,1044554,1044555,1044613,1044682,1044683,1044685,1044686,1044687,
      1044689,1044691,1044693,1044695,1044696,1044697,1044699,1044701,1044703,1044705,1044706,1044707,1044709,1044710,1044711,
      1044713,1044714,1044716,1044717,1044718,1044720,1044845,1044846,1044849,1044850,1044851,1044853,1044855,1044858,1044859,
      1044862,1044863,1044864,1044865,1044867,1044869,1044872,1044873,1044876,1043659,1043666,1043670,1043673,1043682,1043689,
      1043696,1043698,1043700,1043701,1043704,1043705,1043706,1043707,1043708,1043709,1043710,1043711,1043713,1043715,1043719,
      1043721,1043724,1043725,1043726,1043727,1043730,1043731,1043733,1043738,1043739,1043743,1043744,1043745,1043746,1043749,
      1043750,1043751,1043754,1043756,1043757,1043760,1043761,1043762,1043764,1043765,1043767,1043769,1043773,1043778,1043780,
      1043781,1043782,1043783,1043785,1043788,1043790,1043791,1043792,1043794,1043796,1043798,1043799,1043800,1043801,1043802,
      1043804,1043805,1043806,1043811,1043812,1043814,1043816,1043818,1043819,1043822,1043823,1043824,1043828,1043829,1043830,
      1043833,1043834,1043835,1043840,1043842,1043843,1043846,1043848,1043850,1043852,1043853,1043854,1043855,1043857,1043858,
      1043859,1043860,1043864,1043868,1043870,1043871,1043872,1043873,1043874,1043875,1043876,1043877,1043878,1043879,1043880,
      1043882,1043883,1043885,1043887,1043888,1043890,1043892,1043893,1043894,1043895,1043897,1043898,1043899,1043900,1043902,
      1043903,1043904,1043906,1043907,1043908,1043909,1043910,1043911,1043913,1043916,1043917,1043918,1043921,1043922,1043923,
      1043924,1043925,1043926,1043927,1043930,1043933,1043934,1043935,1043936,1043937,1043938,1043939,1043940,1043941,1043942,
      1043943,1043946,1043947,1043948,1043949,1043950,1043951,1043952,1043953,1043955,1043957,1043958,1043959,1043960,1043961,
      1043963,1043964,1043965,1043967,1043969,1043970,1043971,1043972,1043973,1043974,1043975,1043976,1043977,1043978,1043979,
      1043981,1043982,1043984,1043985,1043986,1043988,1043989,1043990,1043991,1043992,1043994,1043996,1043997,1043998,1043999,
      1044000,1044003,1044004,1044007,1044008,1044011,1044012,1044015,1044018,1044019,1044020,1044022,1044024,1044026,1044032,
      1044034,1044039,1044042,1044044,1044045,1044048,1044049,1044050,1044051,1044052,1044055,1044056,1044057,1044059,1044060,
      1044066,1044067,1044068,1044070,1044071,1044072,1044073,1044075,1044076,1044077,1044079,1044080,1044082,1044083,1044084,
      1044085,1044086,1044087,1044088,1044089,1044091,1044092,1044095,1044096,1044097,1044099,1044100,1044102,1044104,1044105,
      1044106,1044107,1044108,1044109,1044110,1044113,1044114,1044115,1044116,1044117,1044118,1044119,1044120,1044124,1044125,
      1044126,1044127,1044128,1044129,1044130,1044132,1044133,1044134,1044135,1044137,1044143,1044144,1044146,1044147,1044148,
      1044149,1044150,1044151,1044153,1044155,1044156,1044157,1044158,1044160,1044161,1044162,1044163,1044164,1044165,1044166,
      1044167,1044168,1044170,1044171,1044172,1044173,1044174,1044175,1044176,1044177,1044178,1044180,1044181,1044182,1044184,
      1044185,1044186,1044187,1044188,1044189,1044191,1044192,1044194,1044196,1044197,1044198,1044199,1044201,1044203,1044204,
      1044205,1044206,1044214,1044215,1044218,1044219,1044220,1044221,1044222,1044223,1044225,1044227,1044228,1044229,1044232,
      1044233,1044234,1044235,1044236,1044238,1044239,1044240,1044243,1044245,1044246,1044248,1044250,1044252,1044253,1044255,
      1044256,1044259,1044260,1044261,1044262,1044263,1044265,1044266,1044267,1044268,1044269,1044272,1044273,1044274,1044275,
      1044277,1044279,1044281,1044282,1044284,1044286,1044287,1044290,1044292,1044293,1044296,1044302,1044304,1044307,1044310,
      1044311,1044316,1044318,1044319,1044320,1044322,1044323,1044324,1044325,1044326,1044328,1044330,1044331,1044332,1044333,
      1044334,1044335,1044337,1044339,1044340,1044342,1044344,1044348,1044349,1044350,1044352,1044353,1044354,1044356,1044357,
      1044358,1044360,1044361,1044362,1044363,1044364,1044365,1044368,1044369,1044371,1044372,1044373,1044376,1044377,1044378,
      1044379,1044380,1044383,1044384,1044386,1044387,1044389,1044390,1044391,1044392,1044395,1044398,1044400,1044401,1044404,
      1044406,1044407,1044408,1044410,1044411,1044413,1044414,1044416,1044419,1044420,1044422,1044423,1044425,1044427,1044430,
      1044431,1044433,1044435,1044436,1044437,1044441,1044447,1044449,1044458,1044479,1044485,1044492,1044502,1044508,1044511,
      1044516,1044525,1044533,1044539,1044542,1044549,1044551,1044556,1044684,1044690,1044692,1044698,1044700,1044708,1044715,
      1044719,1044848,1044854,1044856,1044860,1044866,1044870,1044874,1044878,1044880,1044882,1044884,1044887,1044888,1044891,
      1044894,1044898,1044899,1045023,1045024,1045025,1045029,1045032,1045033,1045159,1045160,1045172,1045176,1045180,1045184,
      1045186,1045188,1045191,1045193,1045194,1045195,1045196,1045197,1045200,1045201,1045202,1045203,1045205,1045208,1045209,
      1045210,1045211,1045212,1045213,1045215,1045217,1045218,1045222,1045224,1045225,1045226,1045227,1045228,1045230,1045232,
      1045233,1045273,1045279,1045283,1042960,1042962,1042966,1042969,1042972,1042975,1042979,1042981,1043004,1043006,1043079,
      1043081,1043264,1043279,1043285,1043290,1043295,1043300,1043309,1043313,1043319,1043323,1043325,1043328,1043332,1043353,
      1043356,1043360,1043364,1043372,1043377,1043380,1043417,1043431,1043451,1043478,1043574,1043609,1043624,1043714,1043729,
      1043734,1043752,1043770,1043795,1043803,1043820,1043847,1043861,1043884,1043915,1043956,1043987,1044006,1044025,1044065,
      1044069,1044094,1044122,1044154,1044179,1044200,1044230,1044257,1044276,1044306,1044336,1044341,1044345,1044359,1044375,
      1044394,1044415,1044434,1044507,1044688,1044889,1045198,1045238,1045239,1045250,1045260,1045282,1042961,1042963,1042964,
      1042965,1042967,1042968,1042970,1042971,1042973,1042974,1042976,1042978,1042980,1042982,1042983,1043005,1043007,1043008,
      1043009,1043010,1043011,1043012,1043013,1043014,1043015,1043016,1043017,1043018,1043019,1043020,1043021,1043022,1043073,
      1043074,1043075,1043076,1043077,1043078,1043080,1043082,1043142,1043143,1043144,1043145,1043146,1043147,1043148,1043150,
      1043151,1043152,1043153,1043154,1043155,1043251,1043253,1043254,1043255,1043256,1043258,1043259,1043260,1043261,1043262,
      1043263,1043265,1043266,1043267,1043268,1043269,1043277,1043278,1043280,1043281,1043282,1043283,1043284,1043286,1043287,
      1043288,1043289,1043291,1043292,1043293,1043294,1043297,1043298,1043301,1043305,1043308,1043311,1043312,1043314,1043315,
      1043317,1043320,1043322,1043324,1043327,1043329,1043330,1043331,1043333,1043335,1043349,1043350,1043351,1043354,1043355,
      1043357,1043358,1043359,1043361,1043362,1043363,1043365,1043366,1043371,1043373,1043374,1043375,1043376,1043379,1043381,
      1043399,1043400,1043402,1043403,1043404,1043405,1043411,1043412,1043413,1043415,1043422,1043424,1043425,1043426,1043427,
      1043428,1043429,1043430,1043432,1043433,1043434,1043435,1043436,1043437,1043438,1043439,1043441,1043442,1043443,1043444,
      1043445,1043447,1043448,1043452,1043453,1043454,1043455,1043463,1043464,1043465,1043466,1043467,1043468,1043469,1043470,
      1043471,1043472,1043473,1043474,1043475,1043476,1043477,1043479,1043480,1043481,1043482,1043483,1043484,1043485,1043486,
      1043487,1043488,1043489,1043490,1043491,1043492,1043563,1043570,1043573,1043575,1043576,1043577,1043578,1043579,1043580,
      1043597,1043598,1043599,1043600,1043602,1043603,1043604,1043605,1043606,1043607,1043608,1043612,1043614,1043621,1043623,
      1043631,1043647,1043648,1043649,1043650,1043652,1043653,1043656,1043657,1043658,1043660,1043661,1043662,1043663,1043664,
      1043665,1043667,1043669,1043671,1043672,1043674,1043675,1043676,1043677,1043678,1043679,1043680,1043681,1043683,1043684,
      1043685,1043686,1043687,1043690,1043692,1043693,1043694,1043695,1043697,1043703,1043712,1043716,1043717,1043718,1043720,
      1043728,1043740,1043741,1043753,1043755,1043763,1043766,1043768,1043771,1043772,1043774,1043775,1043776,1043777,1043779,
      1043784,1043789,1043797,1043810,1043813,1043831,1043832,1043838,1043856,1043865,1043867,1043889,1043896,1043901,1043905,
      1043928,1043945,1043962,1043980,1043993,1044002,1044010,1044021,1044043,1044062,1044081,1044090,1044093,1044111,1044123,
      1044136,1044142,1044145,1044159,1044169,1044183,1044190,1044195,1044216,1044224,1044226,1044231,1044241,1044244,1044247,
      1044254,1044264,1044278,1044280,1044283,1044285,1044291,1044314,1044329,1044343,1044355,1044367,1044370,1044381,1044396,
      1044399,1044403,1044424,1044429,1044444,1044446,1044456,1044466,1044473,1044477,1044481,1044490,1044496,1044503,1044513,
      1044520,1044527,1044534,1044536,1044538,1044544,1044547,1044681,1044694,1044704,1044712,1044721,1044847,1044852,1044857,
      1044861,1044868,1044871,1044879,1044881,1044885,1044886,1044890,1044893,1044897,1045027,1045030,1045158,1045161,1045162,
      1045163,1045166,1045170,1045171,1045173,1045174,1045175,1045177,1045178,1045179,1045181,1045182,1045183,1045185,1045187,
      1045190,1045192,1045204,1045206,1045214,1045216,1045219,1045223,1045229,1045231,1045234,1045237,1045240,1045242,1045245,
      1045246,1045248,1045249,1045251,1045255,1045257,1045258,1045261,1045262,1045266,1045270,1045272,1045276,1045281,1045285,
      1045286,1045287,1045288,1043866,1043881,1043920,1043954,1043968,1043983,1043995,1044001,1044005,1044009,1044017,1044033,
      1044058,1044078,1044098,1044101,1044112,1044152,1044193,1044202,1044217,1044242,1044270,1044312,1044338,1044351,1044366,
      1044374,1044385,1044388,1044393,1044402,1044409,1044412,1044417,1044426,1044428,1044432,1044440,1044443,1044450,1044469,
      1044487,1044702,1044875,1044883,1044892,1045026,1045028,1045157,1045199,1045235,1045236,1045241,1045243,1045244,1045247,
      1045252,1045253,1045254,1045256,1045259,1045263,1045269,1045271,1045274,1045277,1045278,1045280,1045284,1045289
    ],
};

$log->out('START');

for my $shard (keys %$shard2id) {
    my $msg_guard = $log->msg_prefix_guard("[shard_$shard]");
    for my $ids_chunk (chunks($shard2id->{$shard}, $DELETE_CHUNK)) {
        $log->out("delete chunk of ids:", $ids_chunk);
        my $deleted_cnt = do_delete_from_table(PPC(shard => $shard), 'moderation_cmd_queue', where => {cmd => 'copyCampModerateInfo', id => $ids_chunk}) + 0;
        $log->out("deleted $deleted_cnt copyCampModerateInfo cmds");
    }
}

$log->out('FINISH');
