#!/usr/bin/env perl

=head1 DEPLOY

# .migr
{
  approved_by => 'gukserg',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "20s",
      comment => "можно перезапускать"
    }
  ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;

use my_inc '..';

use HashingTools;
use ScriptHelper;
use Settings;
use ShardingTools;

$log->out('START');

foreach_shard_parallel_verbose($log, sub {
    my $shard = shift;
    my $subscription_data = get_all_sql(PPC(shard => $shard), 'SELECT notification_id, resource FROM users_notifications WHERE resource is NOT NULL AND type = "APNS"');
    for my $chunk (chunks $subscription_data, 200) {
        my $update_dict;
        for my $record (@$chunk) {
            $update_dict->{$record->{notification_id}} = {
                resource => undef,
                tag => HashingTools::generate_push_uuid($record->{resource})
            };
        }
        $log->out({"Going to update these notification ids:" => [keys %$update_dict]});
        my $cnt = do_mass_update_sql(PPC(shard => $shard), 'users_notifications', 'notification_id', $update_dict, where => {tag__is_null => 1, device_id__is_null => 1});
        $log->out("Updated $cnt records");
    }
});

$log->out('FINISH');
