#!/usr/bin/env perl

=head1 DEPLOY

# .migr
{
  approved_by => 'gukserg',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "30s",
      comment => "можно перезапускать"
    }
  ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use List::MoreUtils qw/uniq/;

use ScriptHelper;
use Settings;
use ShardingTools;

$log->out('START');

foreach_shard_parallel_verbose($log, sub {
    my $shard = shift;
    my $data = get_all_sql(PPC(shard => $shard), q/SELECT aic.*, c.role FROM additions_item_callouts aic JOIN clients c ON aic.ClientID = c.ClientID WHERE c.role NOT IN ('client', 'empty')/);
    return unless @$data;
    $log->out({"additions_item_callouts data" => $data});
    my $delete_ids_aic = [map {$_->{additions_item_id}} @$data];

    my $client_ids = [uniq map {$_->{ClientID}} @$data];
    $data = get_all_sql(PPC(shard => $shard), [q/SELECT * FROM mod_mail_candidates/, where => {ClientID => $client_ids, cid => 0}]);
    $log->out({"mod_mail_candidates data" => $data});
    my $cnt = do_delete_from_table(PPC(shard => $shard), 'mod_mail_candidates', where => {ClientID => $client_ids, cid => 0});
    $log->out("Deleted $cnt records from mod_mail_candidates");

    $data = get_all_sql(PPC(shard => $shard), [q/SELECT * FROM mod_reasons/, where => {ClientID => $client_ids, cid => 0}]);
    $log->out({"mod_reasons data" => $data});
    my $delete_ids_mr = [map {$_->{rid}} @$data];
    $cnt = do_delete_from_table(PPC(shard => $shard), 'mod_reasons', where => {rid => $delete_ids_mr});
    $log->out("Deleted $cnt records from mod_reasons");

    $cnt = do_delete_from_table(PPC(shard => $shard), 'additions_item_callouts', where => {additions_item_id => $delete_ids_aic});
    $log->out("Deleted $cnt records from additions_item_callouts");
});

$log->out('FINISH');
