#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "несколько секунд",
      comment => "можно перезапускать"
    }
  ],
  approved_by => 'gukserg'
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;
use RBAC2::Extended;
use Campaign;
use PrimitivesIds;

# список кампаний для удаления
my @cids = (
    34812212,
    34813690,
    34813647,
);
my $login = 'alexeewschura';
my $rbac = eval { RBAC2::Extended->get_singleton(1) } or $log->die("error getting RBAC instance: $@");


$log->out('START');

my $uid = get_uid(login => $login);
my $clientid = get_clientid(login => $login);
# по списку ищем кампании, которые ещё не удалены
my $cids_for_delete = get_one_column_sql(PPC(ClientID => $clientid), ["select cid from campaigns",
                                                                    where => {cid => \@cids, statusEmpty => 'No'}]);
$log->out("fix ppcdict for cids:", $cids_for_delete);
# чиним данные в метабазе, чтобы кампании можно было удалить
my $inserted_count = do_mass_insert_sql(PPCDICT,
    'insert ignore into shard_inc_cid (cid, ClientID) values %s', [ map { [ $_, $clientid ] } @$cids_for_delete ]) + 0;
$log->out("$inserted_count rows inserted");

for my $cid (@$cids_for_delete) {
    $log->out("Deleting campaign $cid");
    del_camp($rbac, $cid, $uid, force => 1);
}

$log->out('FINISH');
