#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => '~1 секунда',
    }
  ],
  approved_by => 'gukserg'
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Yandex::DBShards;
use Settings;

$log->out('START');

my $cids = [5493524, 33521548, 31891132, 32045586, 27765191, 32106134, 18475938, 18581125, 28382486, 25945679, 36322353, 7923425, 33735969, 32033841, 33302319, 39967875];


foreach_shard cid => $cids, sub {
    my ($shard, $cids_chunk) = @_;

    $log->out("shard $shard");
    $log->out(["cids", $cids_chunk]);

    my $updated_rows = do_sql(PPC(shard => $shard),
      ['UPDATE campaigns SET geo = NULL',
      where => { cid => $cids_chunk, geo => ''}]) + 0;

    $log->out("updated $updated_rows");
};

$log->out('FINISH');

