#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "1 секунда",
      comment => "можно перезапускать"
    }
  ],
  approved_by => 'gukserg'
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;

use my_inc '..';

use ScriptHelper;
use Settings;

my @bids = (qw/
	6679613957 6679614358 6679628128 6679634863 6679634864 6679634865 6679634866 6679634869 6679634870 6679634873 6679634874 6679634875 6679675545 6681242458 6681242465
	6681242477 6681242479 6681242480 6681259014 6679607670 6679614032 6679614035 6679614036 6679614037 6679614038 6679614039 6679614040 6679614198 6679614204 6679614210
	6679614216 6679614222 6679614229 6679614235 6679614241 6679614247 6679614253 6679614259 6679614265 6679614271 6679614276 6679614282 6679614288 6679614294 6679614300
	6679614306 6679614312 6679614318 6679614324 6679614330 6679614336 6679614342 6679614348 6679614354 6679616528 6679616529 6679616531 6679616532 6679616533 6679616534
	6679616535 6679616536 6679616540 6679616541 6679616542 6679616544 6679616547 6679616548 6679616900 6679616906 6679616912 6679616918 6679616924 6679616930 6679616936
	6679616942 6679616948 6679616954 6679616960 6679616966 6679616972 6679616978 6679616984 6679616990 6679616996 6679617002 6679617008 6679617014 6679617020 6679617026
	6679617032 6679617038 6679617045 6679617051 6679617057 6679617063 6679617068 6679617073 6679617078 6679617083 6679617088 6679617093 6679617098 6679617103 6679617108
	6679617113 6679617118 6679617123 6679617128 6679617133 6679617138 6679617143 6679617148 6679617153 6679617158 6679617163 6679617168 6679617173 6679617178 6679617183
	6679617188 6679617193 6679617199 6679620718 6679620729 6679620739 6679620748 6679620758 6679620768 6679620778 6679620788 6679620798 6679620833 6679620843 6679620853
	6679620863 6679620873 6679620883 6679620893 6679620903 6679620913 6679628183 6679628215 6679628227 6679628239 6679628251 6679628263 6679628275 6679628287 6679628299
	6679628311 6679628324 6679628336 6679628348 6679628360 6679628372 6679628384 6679628396 6679628408 6679628420 6679628432 6679628444 6679628456 6679628468 6679628480
	6679628492 6679628504 6679628516 6679628528 6679628540 6679628552 6679628564 6679628576 6679628588 6679628600 6679628613 6679628625 6679634912 6679634921 6679634932
	6679634941 6679634952 6679634961 6679634972 6679634981 6679634994 6679635071 6679635076 6679635081 6679635086 6679635091 6679635096 6679635101 6679635106 6679635111
	6679640829 6679640830 6679640832 6679640833 6679640835 6679640836 6679640837 6679640839 6679640840 6679640841 6679640848 6679640851 6679640852 6679641261 6679641264
	6679641267 6679641271 6679641279 6679641284 6679641289 6679641292 6679641295 6679641298 6679641300 6679641319 6679641321 6679641324 6679641328 6679641333 6679641339
	6679641344 6679641349 6679641395 6679641503 6679641586 6679641669 6679641745 6679641956 6679642060 6679642134 6679642136 6679642147 6679642152 6679642155 6679642160
	6679642164 6679642167 6679642172 6679652497 6679652498 6679652499 6679652500 6679652501 6679652502 6679652503 6679652504 6679652505 6679652506 6679652507 6679652508
	6679652509 6679652655 6679652657 6679652659 6679652661 6679652663 6679652665 6679652667 6679652670 6679652672 6679652674 6679652676 6679652678 6679652680 6679652682
	6679652684 6679652686 6679652688 6679652690 6679652692 6679652694 6679652696 6679652698 6679652700 6679652702 6679652704 6679652706 6679652708 6679652710 6679652712
	6679652714 6679652716 6679652730 6679652732 6679652734 6679660185 6679660187 6679660189 6679660191 6679660193 6679660195 6679660197 6679660199 6679660201 6679660203
	6679660205 6679668641 6679668643 6679673528 6679675572 6679675769 6679675785 6679675791 6679675797 6679675803 6679675809 6679675815 6679675821 6679675827 6679675833
	6679675840 6679675846 6679675852 6679675858 6679675864 6679675870 6679675876 6679675882 6679675888 6679675894 6679675900 6679675906 6679675912 6679675918 6679675924
	6679675930 6679675936 6679675942 6679675948 6679675954 6679675960 6679675966 6679675972 6679675978 6679675984 6679675992 6679677767 6679677788 6679677799 6679677805
	6679677811 6679677817 6679677823 6679677829 6679677835 6679677841 6679677847 6679677853 6679677859 6679677865 6679677871 6679677877 6679677883 6679677889 6679677895
	6679677901 6679677907 6679677913 6679677919 6679677925 6679677931 6679677937 6679677943 6679677949 6679677955 6679677961 6679677967 6679677973 6679677979 6679677985
	6679677991 6679677997 6679678003 6679678009 6679678015 6679678021 6679678027 6679678033 6679678039 6679678045 6679678051 6679678057 6679678063 6679678069 6679678075
	6679678082 6679678088 6679678094 6679678100 6679678106 6679678112 6679678118 6679678124 6679678130 6679678136 6679678142 6679678148 6679678154 6679678160 6679678166
	6679678172 6679678178 6679678184 6679678190 6679678196 6679678202 6679678207 6679678213 6679693341 6679693342 6679699797 6679699798 6681230161 6681230162 6681230164
	6681230167 6681230169 6681230171 6681230172 6681230175 6681230177 6681230179 6681230181 6681230183 6681230185 6681230556 6681230561 6681230565 6681230570 6681230575
	6681230580 6681230584 6681230589 6681230594 6681230598 6681230603 6681230606 6681230611 6681230615 6681230619 6681230622 6681230624 6681230627 6681230630 6681230635
	6681230639 6681230644 6681230648 6681230653 6681230657 6681230662 6681230664 6681230667 6681230670 6681230672 6681230675 6681230678 6681230683 6681230688 6681243526
	6681243528 6681243530 6681243532 6681243533 6681243534 6681243536 6681243538 6681243540 6681243542 6681243543 6681252450 6681252452 6681258762 6681261137 6681262722
	6681267321 6681267343 6679614194 6679614199 6679614205 6679614211 6679614217 6679614223 6679614230 6679614236 6679614242 6679614248 6679614254 6679614260 6679614266
	6679614272 6679614277 6679614283 6679614289 6679614295 6679614301 6679614307 6679614313 6679614319 6679614325 6679614331 6679614337 6679614343 6679614349 6679614355
	6679616897 6679616901 6679616907 6679616913 6679616919 6679616925 6679616931 6679616937 6679616943 6679616949 6679616955 6679616961 6679616967 6679616973 6679616979
	6679616985 6679616991 6679616997 6679617003 6679617009 6679617015 6679617021 6679617027 6679617033 6679617039 6679617046 6679617052 6679617058 6679617064 6679617069
	6679617074 6679617079 6679617084 6679617089 6679617094 6679617099 6679617104 6679617109 6679617114 6679617119 6679617124 6679617129 6679617134 6679617139 6679617144
	6679617149 6679617154 6679617159 6679617164 6679617169 6679617174 6679617179 6679617184 6679617189 6679617194 6679617200 6679620721 6679620731 6679620741 6679620750
	6679620760 6679620770 6679620780 6679620790 6679620800 6679620835 6679620845 6679620855 6679620865 6679620875 6679620885 6679620895 6679620905 6679620915 6679628209
	6679628217 6679628229 6679628241 6679628253 6679628265 6679628277 6679628289 6679628301 6679628313 6679628326 6679628338 6679628350 6679628362 6679628374 6679628386
	6679628398 6679628410 6679628422 6679628446 6679628458 6679628470 6679628482 6679628494 6679628506 6679628518 6679628530 6679628542 6679628554 6679628566 6679628578
	6679628590 6679628602 6679628615 6679628627 6679634913 6679634922 6679634933 6679634942 6679634953 6679634962 6679634973 6679634984 6679634995 6679635072 6679635077
	6679635082 6679635087 6679635092 6679635097 6679635102 6679635107 6679635112 6679641205 6679641208 6679641213 6679641217 6679641222 6679641225 6679641229 6679641240
	6679641246 6679641250 6679641253 6679641256 6679641259 6679652629 6679652631 6679652633 6679652635 6679652637 6679652639 6679652641 6679652643 6679652645 6679652647
	6679652649 6679652651 6679652653 6679675585 6679675782 6679675786 6679675792 6679675798 6679675804 6679675810 6679675816 6679675822 6679675828 6679675835 6679675841
	6679675847 6679675853 6679675859 6679675865 6679675871 6679675877 6679675883 6679675889 6679675901 6679675907 6679675913 6679675919 6679675925 6679675931 6679675937
	6679675943 6679675949 6679675955 6679675961 6679675967 6679675973 6679675979 6679675985 6679675993 6679677780 6679677796 6679677800 6679677806 6679677812 6679677818
	6679677824 6679677830 6679677836 6679677842 6679677848 6679677854 6679677860 6679677866 6679677872 6679677878 6679677884 6679677890 6679677896 6679677902 6679677908
	6679677914 6679677920 6679677926 6679677932 6679677938 6679677944 6679677950 6679677956 6679677962 6679677968 6679677974 6679677980 6679677986 6679677992 6679677998
	6679678004 6679678010 6679678016 6679678022 6679678028 6679678034 6679678040 6679678046 6679678052 6679678058 6679678064 6679678070 6679678076 6679678083 6679678089
	6679678095 6679678101 6679678107 6679678113 6679678119 6679678125 6679678131 6679678137 6679678143 6679678149 6679678155 6679678161 6679678167 6679678173 6679678179
	6679678185 6679678191 6679678197 6679678203 6679678208 6679678214 6681230498 6681230503 6681230507 6681230512 6681230517 6681230521 6681230525 6681230529 6681230534
	6681230538 6681230543 6681230547 6681230552 6681261163 6681262748 6681267335 6681267351 6679607700 6679607705 6679607710 6679614360 6679620945 6679620955 6679620965
	6679620975 6679620985 6679628637 6679635118 6679635123 6679635128 6679635133 6679635138 6679642110 6679642135 6679642138 6679642149 6679642153 6679642158 6679642197
	6679642209 6679642220 6679642229 6679642234 6679642240 6679642265 6679642280 6679642291 6679642302 6679642312 6679642331 6679642343 6679642353 6679642359 6679642369
	6679642386 6679642392 6679652697 6679652699 6679652701 6679652703 6679652705 6679652707 6679652739 6679652744 6679652749 6679652754 6679652759 6679652764 6679652769
	6679652774 6679652779 6679652784 6679652789 6679652794 6679652799 6679652804 6679652809 6679652814 6679652819 6679652824 6679660261 6679675573 6679675998 6679678309
	6679694059 6679694066 6679694071 6679694079 6679694086 6679700172 6679700173 6679700176 6679700181 6679700185 6679700189 6681230646 6681230651 6681230655 6681230660
	6681230663 6681230666 6681230708 6681230716 6681230757 6681230768 6681230780 6681230791 6681230802 6681230812 6681230824 6681230835 6681230846 6681230865 6681230877
	6681230888 6681230900 6681230911 6681243575 6681243582 6681243587 6681259019 6681261129 6679641318 6679641320 6679641332 6679641335 6679641343 6679641359 6679642162
	6679642165 6679642168 6679652656 6679652658 6679652685 6679652687 6679652689 6679652711 6679652713 6679652731 6679652733 6679678232 6679678234 6679678235 6679678236
	6679678237 6679678238 6679678239 6679678240 6679678241 6679678242 6679678243 6679678244 6679678245 6679678246 6679678248 6679678249 6679678251 6679678252 6679678253
	6679678254 6679678255 6679678256 6679678257 6679678258 6679678259 6679678260 6679678261 6679678262 6679678263 6679678264 6679678265 6679678266 6679678267 6679678268
	6679678269 6679678270 6679678271 6679678272 6679678273 6679678274 6679678278 6679678279 6679678280 6679678281 6679678282 6679678283 6679678284 6679678285 6679678286
	6679678287 6679678288 6679678289 6679678290 6679678291 6679678292 6679678293 6679678294 6679678295 6679678296 6679678297 6679678298 6679678299 6679678300 6679678301
	6679678302 6679678303 6679678304 6679678305 6679678306 6679678307 6679678308 6681230668 6681230671 6681230674 6681230685 6681268090 6681268091 6679641318 6679641320
	6679641332 6679641335 6679641343 6679641359 6679642162 6679642165 6679642168 6679652656 6679652658 6679652685 6679652687 6679652689 6679652711 6679652713 6679652731
	6679652733 6679678232 6679678234 6679678235 6679678236 6679678237 6679678238 6679678239 6679678240 6679678241 6679678242 6679678243 6679678244 6679678245 6679678246
	6679678248 6679678249 6679678251 6679678252 6679678253 6679678254 6679678255 6679678256 6679678257 6679678258 6679678259 6679678260 6679678261 6679678262 6679678263
	6679678264 6679678265 6679678266 6679678267 6679678268 6679678269 6679678270 6679678271 6679678272 6679678273 6679678274 6679678278 6679678279 6679678280 6679678281
	6679678282 6679678283 6679678284 6679678285 6679678286 6679678287 6679678288 6679678289 6679678290 6679678291 6679678292 6679678293 6679678294 6679678295 6679678296
	6679678297 6679678298 6679678299 6679678300 6679678301 6679678302 6679678303 6679678304 6679678305 6679678306 6679678307 6679678308 6681230668 6681230671 6681230674
	6681230685 6681268090 6681268091 6679641266 6679641269 6679641706 6679641821 6679652662 6679652664 6679652695 6681230554 6681230558 6681230605 6681230609 6681230613
	6681230618 6681230626 6681230637 6679640856 6679640858 6679640860 6679640861 6679652511 6679652512 6679652513 6679652514 6681230190 6681230192 6681230194 6681230197
	6679640867 6679640869 6679640871 6679652517 6679652518 6679652519 6681230200 6681230202 6681230203 6679640872 6679640875 6679640878 6679640880 6679652520 6679652521
	6679652522 6679652523 6681230204 6681230206 6681230207 6681230209 6679614174 6679614180 6679614182 6679614184 6679614186 6679614188 6679614190 6679614197 6679614203
	6679614209 6679614215 6679614221 6679614228 6679614234 6679614240 6679614246 6679614252 6679614258 6679614264 6679614270 6679614275 6679614281 6679614287 6679614293
	6679614299 6679614305 6679614311 6679614317 6679614323 6679614329 6679614335 6679614341 6679614347 6679614353 6679616857 6679616859 6679616861 6679616863 6679616865
	6679616867 6679616869 6679616875 6679616877 6679616879 6679616881 6679616887 6679616889 6679616899 6679616905 6679616911 6679616917 6679616923 6679616929 6679616935
	6679616941 6679616947 6679616953 6679616959 6679616965 6679616971 6679616977 6679616983 6679616989 6679616995 6679617001 6679617007 6679617013 6679617019 6679617025
	6679617031 6679617037 6679617044 6679617050 6679617056 6679617062 6679617067 6679617072 6679617077 6679617082 6679617087 6679617092 6679617097 6679617102 6679617107
	6679617112 6679617117 6679617122 6679617127 6679617132 6679617137 6679617142 6679617147 6679617152 6679617157 6679617162 6679617167 6679617172 6679617177 6679617182
	6679617187 6679617192 6679617198 6679620649 6679620653 6679620661 6679620665 6679620669 6679620673 6679620681 6679620685 6679620693 6679620696 6679620700 6679620704
	6679620709 6679620712 6679620716 6679620746 6679620796 6679620851 6679628205 6679628213 6679628225 6679628237 6679628249 6679628261 6679628273 6679628285 6679628297
	6679628309 6679628322 6679628334 6679628346 6679628358 6679628370 6679628382 6679628394 6679628406 6679628418 6679628430 6679628442 6679628454 6679628466 6679628478
	6679628490 6679628502 6679628514 6679628526 6679628538 6679628550 6679628562 6679628574 6679628586 6679628598 6679628611 6679628623 6679634890 6679634892 6679634894
	6679634896 6679634898 6679634900 6679634902 6679634904 6679634911 6679634920 6679634931 6679634940 6679634951 6679634960 6679634971 6679634980 6679634993 6679635070
	6679641144 6679641147 6679641150 6679641154 6679641158 6679641162 6679641165 6679641167 6679641170 6679641176 6679641179 6679641193 6679641201 6679652603 6679652605
	6679652607 6679652609 6679652611 6679652613 6679652615 6679652617 6679652619 6679652621 6679652623 6679652625 6679652627 6679669265 6679669270 6679673671 6679675583
	6679675780 6679675784 6679675790 6679675796 6679675802 6679675808 6679675814 6679675820 6679675826 6679675832 6679675839 6679675845 6679675851 6679675857 6679675863
	6679675869 6679675875 6679675881 6679675887 6679675893 6679675899 6679675905 6679675911 6679675917 6679675923 6679675929 6679675935 6679675941 6679675947 6679675953
	6679675959 6679675965 6679675971 6679675977 6679675983 6679675991 6679677778 6679677794 6679677798 6679677804 6679677810 6679677816 6679677822 6679677828 6679677834
	6679677840 6679677846 6679677852 6679677858 6679677864 6679677870 6679677876 6679677882 6679677888 6679677894 6679677900 6679677906 6679677912 6679677918 6679677924
	6679677930 6679677936 6679677942 6679677948 6679677954 6679677960 6679677966 6679677972 6679677978 6679677984 6679677990 6679677996 6679678002 6679678008 6679678014
	6679678020 6679678026 6679678032 6679678038 6679678044 6679678050 6679678056 6679678062 6679678068 6679678074 6679678081 6679678087 6679678093 6679678099 6679678105
	6679678111 6679678117 6679678123 6679678129 6679678135 6679678141 6679678147 6679678153 6679678159 6679678165 6679678171 6679678177 6679678183 6679678189 6679678195
	6679678201 6679678206 6679678212 6679693925 6679693929 6679700089 6679700091 6681230421 6681230427 6681230438 6681230443 6681230448 6681230452 6681230458 6681230462
	6681230467 6681230471 6681230485 6681230489 6681230494 6681253078 6681253082 6681258994 6681261159 6681262744 6681267333 6681267349 6679606355 6679606419 6679606433
	6679606455 6679606457 6679606459 6679606461 6679606463 6679616338 6679616370 6679616378 6679616387 6679616395 6679616420 6679616428 6679616453 6679616461 6679616469
	6679616478 6679616502 6679616511 6679658769 6679658783 6679658805 6679658807 6679658811 6679658813 6679677740 6679677785 6781670727 6790341708 6790432011 6790468901
	6790480608 6790491495 6790499194 6790504787 6790523895 6790817411 6790824162 6790831276 6790844740 6790852133 6790861452 6790877787 6790889516 6790896661 6790905832
	6790919431 6790954681 6790942104 6790967465 6790978142 6790984851 6790997601 6791001851 6791011898 6791020895 6791029405 6791039741 6791048626 6791061669 6791096145
	6791109135 6791121244 6791133995 6791146843 6791165035 6791192092 6791197455 6791204726 6791244302 6791274047 6791315410 6791321512 6791322651 6791326936 6791329688
	6791331594 6791336679 6791347380 6791355627 6791357788 6791362591 6791369707 6791375054 6791382486 6791388747 6791391501 6791401565 6791413120 6791420262 6791439264
	6791447283 6791450281 6791455727 6791462248 6791464913 6791469339 6791476601 6791482710 6791492332 6791503778 6791510274 6791514780 6791519084 6791527558 6791532880
	6791541110 6679678233 6679607699 6679607704 6679607709 6679614359 6679616296 6679620943 6679620953 6679620963 6679620973 6679620983 6679628635 6679635117 6679635122
	6679635127 6679635132 6679635137 6679642178 6679642182 6679642188 6679642194 6679642206 6679642218 6679642227 6679642233 6679642238 6679642250 6679642263 6679642276
	6679642289 6679642299 6679642309 6679642330 6679642341 6679642351 6679642357 6679642367 6679642384 6679642390 6679652738 6679652743 6679652748 6679652753 6679652758
	6679652763 6679652768 6679652773 6679652778 6679652783 6679652788 6679652793 6679652798 6679652803 6679652808 6679652813 6679652818 6679652823 6679660259 6679675579
	6679675997 6679678230 6679678231 6679694058 6679694064 6679694070 6679694076 6679694084 6679700168 6679700171 6679700177 6679700180 6679700184 6679700188 6681230697
	6681230706 6681230715 6681230721 6681230728 6681230737 6681230746 6681230755 6681230766 6681230777 6681230789 6681230800 6681230810 6681230821 6681230833 6681230845
	6681230854 6681230863 6681230874 6681230886 6681230897 6681230908 6681243573 6681243581 6681243586 6681259018 6681261171 6679606411 6679606577 6679606651 6679606726
	6679606806 6679606880 6679606954 6679607028 6679607087 6679607124 6679607301 6679658761 6679658929 6679659002 6679659076 6679659151 6679659225 6679659301 6679659375
	6679659449 6679659523 6679659877 6681242454 6681242537 6681242574 6681242612 6681242722 6681242777 6681242814 6681242851 6681242888 6681242925 6681243203 6679606557
	6679606591 6679606665 6679606739 6679606820 6679606894 6679606968 6679607042 6679607094 6679607131 6679658909 6679658943 6679659016 6679659091 6679659166 6679659241
	6679659315 6679659389 6679659463 6679659537 6681242527 6681242544 6681242581 6681242619 6681242729 6681242784 6681242821 6681242858 6681242895 6681242932 6679606413
	6679606599 6679606673 6679606747 6679606828 6679606902 6679606976 6679607050 6679607098 6679607135 6679607311 6679658763 6679658951 6679659025 6679659099 6679659174
	6679659249 6679659323 6679659397 6679659471 6679659546 6679659897 6681242455 6681242548 6681242585 6681242623 6681242733 6681242788 6681242825 6681242862 6681242899
	6681242936 6681243222 6679606427 6679606609 6679606683 6679606757 6679606838 6679606912 6679606986 6679607060 6679607103 6679607140 6679607316 6679658777 6679658961
	6679659034 6679659108 6679659183 6679659259 6679659333 6679659407 6679659481 6679659556 6679659907 6681242462 6681242553 6681242590 6681242628 6681242738 6681242793
	6681242830 6681242867 6681242904 6681242941 6681243233 6679607351 6679607352 6679607355 6679607358 6679607360 6679607361 6679607362 6679607364 6679607365 6679607367
	6679607368 6679607369 6679607370 6679607372 6679607373 6679607374 6679607375 6679607377 6679607379 6679607381 6679607383 6679659977 6679659979 6679659985 6679659991
	6679659995 6679659997 6679659999 6679660003 6679660005 6679660009 6679660011 6679660013 6679660015 6679660019 6679660021 6679660023 6679660025 6679660029 6679660033
	6679660037 6679660041 6681243326 6681243328 6681243334 6681243338 6681243341 6681243343 6681243344 6681243347 6681243349 6681243352 6681243353 6681243354 6681243355
	6681243357 6681243359 6681243362 6681243364 6681243368 6681243371 6681243374 6681243378 6679617202 6679617203 6679617204 6679620566 6679620568 6679620570 6679620572
	6679620578 6679620580 6679620582 6679620584 6679620586 6679620588 6679620590 6679620592 6679620594 6679620596 6679620598 6679620600 6679620602 6679620604 6679628633
	6679634876 6679634877 6679634878 6679634879 6679634882 6679634883 6679634884 6679634885 6679634886 6679675996
/);

$log->out('START');

foreach_shard bid => \@bids, with_undef_shard => 1, sub {
    my ($shard, $bids_chunk) = @_;
    if ($shard) {
        $log->msg_prefix("[shard_$shard]");
        $log->out({bids_chunk => $bids_chunk});
        my $res = do_sql(PPC(shard => $shard), ["
                                  UPDATE banners b
                                    SET
                                        b.statusShow = 'Yes'
                                       , b.statusBsSynced = 'No'
                                       , b.LastChange = NOW()
                                       , b.statusMetricaStop = 'No'",
                                    WHERE => {
                                        'b.bid' => $bids_chunk,
                                        'b.statusArch' => 'No',
                                        _OR => {
                                            'b.statusShow' => 'No',
                                            'b.statusMetricaStop' => 'Yes',
                                        },
                                    }]) + 0;
        $log->out("banners updated, affected $res rows");
    } else {
        $log->msg_prefix(undef);
        $log->out({ERROR_bids_without_shard => $bids_chunk});
    }
};

$log->out('FINISH');

