#!/usr/bin/env perl

=head1 DEPLOY

# .migr
{
    approved_by => 'gerdler',
    tasks => [
        {
            type => 'script',
            when => 'after',
            time_estimate => "пара минут",
            comment => "можно перезапускать"
        }
    ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use Currencies qw(get_currency_constant get_frontpage_min_price);
use ScriptHelper;
use Settings;
use ShardingTools qw/foreach_shard_parallel_verbose/;

$log->out('START');

my ($DRY_RUN, $DEBUG);
extract_script_params(
    'dry-run' => \$DRY_RUN,
    'debug' => \$DEBUG,
);

foreach_shard_parallel_verbose($log, sub {
    my $shard = shift;

    my $db_data = get_all_sql(PPC(shard => $shard), q/SELECT br.pid, br.ret_id, br.price_context, IF(c.type IN ("cpm_banner", "cpm_deals"), "cpm_banner", "regular") as type, c.currency FROM campaigns c
        JOIN bids_retargeting br ON br.cid = c.cid
        WHERE c.statusEmpty = "No" AND price_context != 0
            AND (((c.type NOT IN ("cpm_banner", "cpm_deals", "cpm_yndx_frontpage")) AND price_context < CASE c.currency WHEN "RUB" THEN 0.3 WHEN "UAH" THEN 0.08 WHEN "USD" THEN 0.01
                    WHEN "EUR" THEN 0.01 WHEN "KZT" THEN 1 WHEN "CHF" THEN 0.01 WHEN "TRY" THEN 0.01 WHEN "BYN" THEN 0.01 ELSE NULL END)
                OR ((c.type IN ("cpm_banner", "cpm_deals")) AND price_context < CASE c.currency WHEN "RUB" THEN 5 WHEN "UAH" THEN 2.25 WHEN "USD" THEN 0.08 WHEN "YND_FIXED" THEN 0.17
                    WHEN "EUR" THEN 0.07 WHEN "KZT" THEN 29 WHEN "CHF" THEN 0.08 WHEN "TRY" THEN 0.3 WHEN "BYN" THEN 0.15 ELSE NULL END))/);

    $log->out("Count: " . (scalar @$db_data)) if ($DEBUG);
    my $parsed_data;
    foreach my $db_record (@$db_data) {
        push @{$parsed_data->{$db_record->{type}}->{$db_record->{currency}}}, {pid => $db_record->{pid}, ret_id => $db_record->{ret_id}, price_context => $db_record->{price_context}};
    }
    for my $type (keys %$parsed_data) {
        my $data = $parsed_data->{$type};

        for my $currency (keys %$data) {
            my $min_price = get_currency_constant($currency, ($type eq 'cpm_banner' ? 'MIN_CPM_PRICE' : 'MIN_PRICE'));
            my $value_string_context = "IF(price_context = 0, price_context, GREATEST(price_context, $min_price))";
            $log->out("Going to update $type values for $currency with a minimum of $min_price");
            my $ret_data = $data->{$currency};
            while (my @ret_chunk = splice @$ret_data, 0, 40) {
                $log->out({data => \@ret_chunk});
                my $max_rows = scalar @ret_chunk;
                my $ret_ids = [map {$_->{ret_id}} @ret_chunk];
                if (!$DRY_RUN) {
                    my $bids_count = do_update_table(PPC(shard => $shard), 'bids_retargeting', {price_context__dont_quote => $value_string_context, statusBsSynced => 'No'},
                        where => {ret_id => $ret_ids});
                    $log->out("updated " . (0 + $bids_count) . " rows out of $max_rows");
                }
            }
        }
    }

    $log->out('START PART 2') if ($DEBUG);
    $db_data = get_all_sql(PPC(shard => $shard), q/SELECT br.pid, c.currency, br.price_context, br.ret_id, p.geo, fc.allowed_frontpage_types FROM campaigns c
        JOIN bids_retargeting br ON br.cid = c.cid
        JOIN phrases p ON br.pid = p.pid
        JOIN campaigns_cpm_yndx_frontpage fc on p.cid = fc.cid
        WHERE c.statusEmpty = "No" AND price_context != 0 AND c.type = 'cpm_yndx_frontpage'/);

    my (@bad_rows);
    foreach my $db_record (@$db_data) {
        my @allowed_frontpage_types = split ',' => $db_record->{allowed_frontpage_types};
        my $min_price = get_frontpage_min_price($db_record->{currency}, $db_record->{geo}, \@allowed_frontpage_types);
        if ($min_price && $min_price > $db_record->{price_context}) {
            $db_record->{min_price} = $min_price;
            push @bad_rows, $db_record;
        }
    }

    if (@bad_rows) {
        $log->out({data => \@bad_rows});
        my $max_rows = scalar @bad_rows;
        my $count = 0;
        for my $row (@bad_rows) {
            my $min_price = $row->{min_price};
            my $value_string_context = "IF(price_context = 0, price_context, GREATEST(price_context, $min_price))";
            if (!$DRY_RUN) {
                # поломано не более четырёх записей, можем себе позволить построчную запись
                $count += do_update_table(PPC(shard => $shard), 'bids_retargeting', {price_context__dont_quote => $value_string_context, statusBsSynced => 'No'},
                    where => {ret_id => $row->{ret_id}});
            }
        }
        $log->out("updated $count rows out of $max_rows");
    }

    $log->out('END PART 2') if ($DEBUG);
});

$log->out('FINISH');

