#!/usr/bin/env perl

=head1 DEPLOY

# .migr
{
    approved_by => 'sco76',
    tasks => [
        {
            type => 'sql',
            db => "ppc:all",
            when => 'any',
            time_estimate => "до минуты",
            sql => "ALTER TABLE `clients` MODIFY COLUMN `deleted_reps` mediumtext",
            comment => "запускать с dbs-guard и dbs-pt-osc"
        },
        {
            type => 'script',
            when => 'after',
            time_estimate => "3s"
        },
    ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

use utf8;
use JSON;

$log->out('START');

my $CLIENT_ID = 1845;

my $old_deleted_reps = get_one_field_sql(PPC(ClientID => $CLIENT_ID), ["select deleted_reps from clients", where => {ClientID => $CLIENT_ID}]);
$log->die('no reps!') unless $old_deleted_reps;

my $length = rindex($old_deleted_reps, '}');
$log->die(['unusual string length', $length]) unless $length > 40_000;
$log->out(["old value", $old_deleted_reps]);

my $deleted_reps = substr($old_deleted_reps, 0, $length + 1) . ']';
$log->die("Got the same string after a fix") if ($old_deleted_reps eq $deleted_reps);

eval {
    from_json($deleted_reps);
};
$log->die(['wrong result', $deleted_reps, $@]) if $@;

my $num_rows = do_update_table(PPC(ClientID => $CLIENT_ID), 'clients', {'deleted_reps' => $deleted_reps}, where => {ClientID => $CLIENT_ID, deleted_reps => $old_deleted_reps});

$log->out("updated $num_rows row(s)");

$log->out('FINISH');

