#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'ppalex',
  tasks => [
    {
      type => 'script',
      when => 'instructions',
      instructions => "запустить по отмашке pashkus",
      time_estimate => "10 минут на шард",
      comment => "можно перезапускать"
    }
  ]
}

=cut
use my_inc '..';

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;
use ShardingTools qw/ppc_shards/;

use ScriptHelper;
use Settings;

my $ONLY_SHARDS = undef;
my $CHUNK_SIZE = 50000;


extract_script_params(
    'only-shards:s' => \$ONLY_SHARDS,
    'chunk-size:i'  => \$CHUNK_SIZE,
);

die "No valid chunk-size specified" if $CHUNK_SIZE < 1;

$log->out('START');

my @shards = defined $ONLY_SHARDS ? grep { /^\d+$/ } (split /,/, $ONLY_SHARDS) : ppc_shards();
die "No valid shards specified" unless @shards;
$log->out("Running on shards: ". join ',', @shards);

foreach_shard(shard => \@shards, sub {
    my ($shard) = @_;
    $log->msg_prefix("[shard:$shard]");
    my ($creative_id, $max_creative_id) = get_one_line_array_sql(PPC(shard => $shard), "select min(creative_id), max(creative_id) from perf_creatives");
    $creative_id //= 0;
    $max_creative_id //= 0;
    $log->out("got min & max creative_id: $creative_id, $max_creative_id");

    while ($creative_id < $max_creative_id) {
        my $creative_ids = get_one_column_sql(PPC(shard => $shard), [
            "SELECT creative_id FROM perf_creatives",
            WHERE => {
                "creative_id__between" => [ $creative_id, $creative_id + $CHUNK_SIZE ],
                "layout_id" => 7
            }
        ]);
        if (@$creative_ids) {
            $log->out("updating creative_ids: " . join(",", @$creative_ids));

            do_update_table(PPC(shard => $shard), 'perf_creatives', { layout_id => 5 }, where => {creative_id => $creative_ids});
        }

        $creative_id += $CHUNK_SIZE + 1;
    }
});

$log->out('FINISH');
