#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'gukserg',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "несколько секунд",
      comment => "Можно перезапускать"
    }
  ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;
use ShardingTools qw/ppc_shards/;

$log->out('START');

for my $shard (ppc_shards()) {
    $log->msg_prefix("[shard $shard]");
    my $bad_wallets = get_one_column_sql(PPC(shard => $shard), ["SELECT cid FROM campaigns", where => { type => 'wallet', statusModerate => 'Ready'}]);
    if (@$bad_wallets) {
    	$log->out("Update statusModerate on wallets:", $bad_wallets);
    	my $cnt = do_update_table(PPC(shard => $shard), 'campaigns', {statusModerate => 'Yes'}, where => {cid => $bad_wallets, type => 'wallet', statusModerate => 'Ready'}) + 0;
    	$log->out("wallets fixed: $cnt");
    } else {
    	$log->out("No wallets with wrong statusModerate");
    }

}

$log->out('FINISH');

