#!/usr/bin/env perl

=head1 DEPLOY

# .migr
{
    approved_by => 'ppalex',
    tasks => [
        {
            type => 'script',
            when => 'after',
            time_estimate => "10 секунд",
            comment => "можно перезапускать"
        }
    ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use Primitives;
use ScriptHelper;
use Settings;
use ShardingTools qw/foreach_shard_parallel_verbose/;

$log->out('START');

my $DRY_RUN;
extract_script_params(
    'dry-run' => \$DRY_RUN,
);

my %clientids_set = map {+($_ => undef)} (9536, 15985, 303015, 369191, 397870, 404322, 414590, 421929, 423639, 432078, 441088, 450482, 481010, 543505, 551619, 923099, 941106,
    949194, 961821, 963285, 969459, 986436, 1021209, 1036582, 1063109, 1075148, 1076282, 1076402, 1093414, 1117517, 1132564, 1136311, 1177527, 1203751, 1217274, 1249455, 1285573,
    1290419, 1308305, 1364573, 1393245, 1480472, 1653119, 1705188, 1734560, 1883558, 2019316, 2214696, 4146982, 4293640, 896628, 1597619);

foreach_shard_parallel_verbose($log, sub {
    my $shard = shift;

    my $db_data = get_all_sql(PPC(shard => $shard), q/SELECT clientid, deleted_reps FROM clients WHERE deleted_reps <> '' AND deleted_reps NOT LIKE '[%'/);

    return unless @$db_data;
    my (@log_data, @clientids);
    for my $row (@$db_data) {
        if (!can_delete_reps($row->{deleted_reps})) {
            my $g = $log->msg_prefix_guard("[ERROR]");
            $log->out({"Client has live old representatives" => {DATA => $row}});
            next;
        }
        if (!exists $clientids_set{$row->{clientid}}) {
            my $g = $log->msg_prefix_guard("[ERROR]");
            $log->out({"Client is not on the whitelist" => {DATA => $row}});
            next;
        }
        push @log_data, $row;
        push @clientids, $row->{clientid};
    }
    $log->out({DATA => \@log_data});

    if (!$DRY_RUN) {
        my $cnt_rows = do_update_table(PPC(shard => $shard), 'clients', {deleted_reps => ''}, where => {clientid => \@clientids, deleted_reps__not_like => '[%'});
        $log->out("Updated $cnt_rows clients out of " . (scalar @clientids));
    }
});

$log->out('FINISH');

sub can_delete_reps {
    my $reps = shift;
    return 0 unless $reps =~ /^[\d\,]+$/;
    for my $uid (split /,/, $reps) {
        return 0 if defined get_login_by_uid_passport($uid);
    }

    return 1;
}
