#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'gerdler',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "4 минуты на каждый шард на девтесте",
      comment => "можно перезапускать"
    },
    {
      type => 'sql',
      db => 'ppc:all',
      when => 'after',
      time_estimate => "секунда на шард",
      sql => 'ALTER TABLE additions_item_callouts DROP KEY ClientID, ADD UNIQUE KEY ClientID (ClientID, hash), ALGORITHM=INPLACE, LOCK=NONE',
      comment => "запускать после скрипта, если не выполняется - перезапустить скрипт и попробовать еще раз"
    }
  ]
}

=cut

use Direct::Modern;
use my_inc '..';

use Yandex::DBTools;

use ShardingTools;
use ScriptHelper;
use Settings;

$log->out('START');

my ($DEBUG);
extract_script_params(
    'debug' => \$DEBUG
);

foreach_shard_parallel_verbose($log, sub {
    my $shard = shift;   
    $log->msg_prefix("[shard=$shard]");

    # находим баннеры, к которым привязаны 2 и более одинаковых коллаутов
    my $duplicates_linked_to_same_banner = get_all_sql(PPC(shard => $shard), 
    	"SELECT ba.bid, aic.hash
         FROM banners_additions ba
         JOIN additions_item_callouts aic ON ba.additions_item_id = aic.additions_item_id
         WHERE (aic.clientid, aic.hash) IN (SELECT clientid, hash
					    FROM additions_item_callouts
	   				    GROUP BY clientid, hash
					    HAVING count(*) > 1)
         GROUP BY ba.bid, aic.hash
         HAVING count(*) > 1");

    for my $duplicate_info (@$duplicates_linked_to_same_banner) {
        my $bid = $duplicate_info->{bid};
        my $hash = $duplicate_info->{hash};

        $log->out(sprintf("\tОбрабатываем привязки к баннеру с bid: %s коллаутов с hash: %s", $bid, $hash));

        # находим все коллауты, привязанные к баннеру с bid = $bid и имеющие хеш = $hash
        my $duplicate_ids = get_one_column_sql(PPC(shard => $shard), 
            "SELECT aic.additions_item_id
	     FROM banners_additions ba
	     JOIN additions_item_callouts aic ON ba.additions_item_id = aic.additions_item_id
	     WHERE ba.bid = ? AND aic.hash = ?", $bid, $hash);

        $log->out(sprintf("\tId коллаутов, привязанных к баннеру с bid = %s и имеющих hash = %s : %s", $bid, $hash, join(", ", @$duplicate_ids)));

        # получаем все id для отвязки (отвяжем от баннера все коллауты кроме имеющего наименьшее значение id)
        my @duplicate_ids_to_unlink = sort @$duplicate_ids;
        shift @duplicate_ids_to_unlink;

        $log->out(sprintf("\tId коллаутов, которые отвязываем от баннера с bid = %s : %s", $bid, join(", ", @duplicate_ids_to_unlink)));

        do_sql(PPC(shard => $shard), ["DELETE FROM banners_additions",
                                      where => {bid => $bid, additions_item_id => \@duplicate_ids_to_unlink}]);
    }

    # перепривязка (если к баннеру привязан коллаут, у которого есть дубликат с меньшим id, то оставим только этот дубликат, а остальные привязки удалим)
    do_sql(PPC(shard => $shard), "UPDATE banners_additions ba 
                                  JOIN additions_item_callouts aic1 ON ba.additions_item_id = aic1.additions_item_id 
                                  SET ba.additions_item_id = (SELECT min(aic2.additions_item_id) 
                                                              FROM additions_item_callouts aic2 
                                                              WHERE aic1.clientid = aic2.clientid and aic1.hash = aic2.hash) 
                                  WHERE ba.additions_item_id IN (SELECT additions_item_id 
                                                                 FROM additions_item_callouts 
                                                                 WHERE (clientid, hash) IN (SELECT clientid, hash 
                                                                                            FROM additions_item_callouts 
                                                                                            GROUP BY clientid, hash 
                                                                                            HAVING count(*) > 1))");

    # поиск дубликатов для удаления
    my $callout_ids_to_delete = get_one_column_sql(PPC(shard => $shard), 
    	"SELECT additions_item_id
	 FROM additions_item_callouts 
	 WHERE additions_item_id NOT IN (SELECT min(additions_item_id) 
					 FROM additions_item_callouts 
					 GROUP BY clientid, hash)");

    $log->out(sprintf("\tУдаляем коллауты с id : %s", join(", ", @$callout_ids_to_delete)));

    # удаление дубликатов
    do_sql(PPC(shard => $shard), ["DELETE FROM additions_item_callouts", 
                                  where => {additions_item_id => $callout_ids_to_delete}]);
});

$log->out('FINISH');

