#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'lena-san',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "предположительно несколько часов (сложно оценить, так как не в продакшене таблиц мало и удаление происходит намного быстрее)",
      comment => "скрипт можно перезапускать. применить в том числе в песочнице"
    },
    {
      type => 'sql',
      db => "ppclog",
      when => 'any',
      time_estimate => "предположительно несколько часов, оценить сложно так как на дев/тест таблица пустая",
      comment => "данные за 4 года устарели и точно никому не нужны (в тикете есть подтверждение), поэтому сразу удаляем",
      sql => "DROP TABLE IF EXISTS api_reports_log"
    }
  ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::Retry;

use my_inc '..';

use ScriptHelper;
use Settings;

$log->out('START');

$log->out("start dropping api_reports_log_YYYYMMDD tables"); 

for my $table (sort @{get_one_column_sql(PPCLOG, "show tables like 'api_reports_log_%'")}) {
    my $relaxed_guard = relaxed_guard(times => 0.2);
    $log->out("let's drop $table");
    do_sql(PPCLOG, "drop table $table");
}

$log->out('FINISH');

