#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "1 минута на devtest",
      comment => "можно перезапускать"
    },
    {
      type => 'sql',
      db => 'ppc:all',
      when => 'after',
      time_estimate => '1s',
      comment => 'dbs-guard
      Перед выполнением проверить отсутствие дублирующихся relation_id.
      dbs-sql -B pr:ppc:all "select relation_id from clients_relations group by relation_id having count(*) > 1"
      Если запрос что-то вернул -- не выполнять ALTER',
      sql => '
      ALTER TABLE clients_relations 
        ADD UNIQUE INDEX i_client_id_from_client_id_to (client_id_from, client_id_to), 
        DROP PRIMARY KEY, 
        ADD PRIMARY KEY (relation_id), 
      ALGORITHM=INPLACE, LOCK=NONE;'
    }
  ],
  approved_by => 'ppalex'
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use ShardingTools qw/ppc_shards/;
use Settings;
use Yandex::DBShards;
use Yandex::Retry qw/relaxed/;

my $SELECT_CHUNK_SIZE = 100;

$log->out('START');

for my $shard (ppc_shards()) {
    while(1) {
        my $pref_guard = $log->msg_prefix_guard( "[shard $shard]" );
        my $chunk = get_all_sql(PPC(shard => $shard), "
                    SELECT client_id_from, client_id_to
                      FROM clients_relations
                     WHERE relation_id = 0
                     LIMIT ?", $SELECT_CHUNK_SIZE);
        my $ids = get_new_id_multi('relation_id', scalar(@$chunk));
        for my $row (@$chunk) {
            $row->{relation_id} = shift @$ids;
            # Обновляем по одной записи (не нашёл, как сгенерировать case-условие для составного ключа)
            relaxed times => 1, sub {
                my $updated = do_sql(PPC(shard => $shard), [
                    'UPDATE clients_relations',
                    'SET relation_id = ', $row->{relation_id},
                    WHERE => {
                        client_id_from => $row->{client_id_from},
                        client_id_to   => $row->{client_id_to},
                        relation_id    => 0
                    },
                ]);
                if ($updated == 0) {
                    $log->out({ message => 'skipped', row => $row });
                } else {
                    $log->out({ message => 'updated', row => $row });
                }
            };
        }
        last if @$chunk != $SELECT_CHUNK_SIZE;
    }
}

$log->out('FINISH');

