#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "20 мин",
  comment => "выставляем пэкшот в false"
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use ShardingTools qw/ppc_shards/;
use Settings;

my $SELECT_CHUNK_SIZE = 1000;

$log->out('START');


for my $shard (ppc_shards()) {
    my $min_creative_id = -1;
    while (1) {
        my $pref_guard = $log->msg_prefix_guard("[shard $shard]");
        my $chunk = get_one_column_sql(PPC(shard => $shard), "
                    SELECT creative_id
                      FROM perf_creatives
                     WHERE creative_id > ?
                       AND has_packshot IS NULL
                  ORDER BY creative_id
                     LIMIT ?", $min_creative_id, $SELECT_CHUNK_SIZE);
        last unless scalar(@$chunk) > 0;
        $min_creative_id = $chunk->[-1];
        do_update_table(PPC(shard => $shard), 'perf_creatives', { has_packshot => 0 }, where => { creative_id => $chunk });
    }
}

$log->out('FINISH');
