#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "около секунды",
    }
  ],
  approved_by => 'ppalex'
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;

use my_inc '..';

use ScriptHelper;
use Settings;

my $CLIENT = 8769722;
my @CIDS = qw/
    30320056 30320069 30320090 30320105 30320119 30320125 30320127 30321527 31865321 31865323 31865325 31865331
    31865338 31865346 31865351 31865359 32254663 32308534 32526666 32526675 32526686 32526692 32526701 32526705
    32526713 32526717 32591104 32591111 32591128 32591159 32591171 32591190 32591205 32591231 32591240 32594530
    32594835 32594841 32793726 32793734 32793738 32893430 33057018 33110959 33159935 33159937 33199687 33199709
    33199721 33199729 33199739 33199755 33199766 33199777 33199790 33199798 33199817 33199829 33199841 33199855
    33199872 33199878 33199892 33199898 34129449 35083577 35083583 35842325 36087627 36087661 36087675 36087682
    36087694 36087699 36087711 36087716 36087744 36087751 36087783 36087795 36087815 36087838 36087844 36087855
    36087862 36087887 36087891 36087913 36087921 36087934 36087964 36087975 36087995 36088000 36088025 36086941
    36086945 36086962 36086991 36087002 36087016 36087027 36087052 36087065 36087070 36087071 36087085 36087104
    36087114 36087127 36087139 36087163 36087170 36087175 36087180 36087197 36087232 36087247 36087262 36087276
    36087304 36087315 36158261 36592626 36592647 36592660 36592677 36592688 36592703 36592753 36592785 36592792
    36592809 36592842 36592845 36592861 36592874 36592879 36592886 36592889 36592898 36592902 36592911 36592917
    36592931 36592950 36592953 36592972 36592986 36593011 36593015 36593022 36593032 36593040 36593048 36593061
    36593078 36593084 36593099 36593111 36593127 36593142 36593148 36593162 36593172 36768539 36768544 36768549
    36768552 36768553 36768554 36768555 36768562 37335825 37753527 37753531 37753536 37753546 37753550 37753560
    37753574 37753578 37753582 37753585 37753590 37753594 37753596 37753604 37753620 37753625 37753631 37753637
    37753641 37753657 37753660 37753663 37753674 37753679 37753683 37753690 37753696 37753705 37753709 37753720
    37753732 37753739 41233868 41233877 41233882 41233896 41233906 41233912 41233921 41233929 41233939 41233947
    41233961 41233971 41233978 41244724 41244732 41244743 41244744 42455960 42455965 42455967 43203465 43782084
    43782091 43782096 43782099 43782104 43782110 43782168 43782176 43782116 43782119 43782179 43782186 44207313
    44465034 44465473 44465477
/;
my $LSC = "last_significant_click";

$log->out('START');

my $old_values = get_all_sql(PPC(cid => \@CIDS), ['SELECT cid, type, attribution_model FROM campaigns', WHERE => {cid => SHARD_IDS}]);
my %by_model;
for my $camp (@$old_values) {
    my $model = $camp->{attribution_model} // '';
    $log->out("campaign $camp->{cid} ($camp->{type}) has $model attribution_model");
    if ($model eq $LSC) {
        $log->out("SKIP $camp->{cid} - already has $LSC model");
        next;
    }
    if ($camp->{type} eq "wallet" || $camp->{type} eq "billing_aggregate") {
        $log->out("SKIP $camp->{cid} - campaign typу does not imply attribution_model changing");
        next;
    }
    push @{ $by_model{$model} }, $camp->{cid};
}

for my $model (keys %by_model) {
    my $cids = $by_model{$model};
    $log->out({msg => "update campaigns", old_model => $model, new_model => $LSC, cid => $cids});
    my %where = ( cid => $cids );
    if ($model) {
        $where{attribution_model} = $model;
    } else {
        $where{attribution_model__is_null} = 1;
    }
    my $r = do_update_table(PPC(cid => $cids), 'campaigns', {attribution_model => $LSC, statusBsSynced => "No"}, where => \%where);
    $log->out("updated $r rows");
}

$log->out('FINISH');

