#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "меньше секунды",
    }
  ],
  approved_by => 'ppalex'
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

my @props = qw/
    active_orders_3_req_id
    active_orders_4_req_id
    active_orders_invalid_data_last
    active_orders_invalid_data_reviewed
    active_oreders_req_id
    active_oreders_req_id_media
    fraud_clicks_last_reqid
    fraud_stat_info
    last_orderstat_info
    last_orderstat_info_with_metrika
    last_orderstat_reqid
    last_priorities_reqid
    media_banner_stat_info
    media_update_mcb_phrases_shows_last_mgid
    media_update_mcb_phrases_shows_last_mgid_1
    media_update_mcb_phrases_shows_last_mgid_2
    media_update_mcb_phrases_shows_last_mgid_3
    media_update_mcb_phrases_shows_last_mgid_4
    media_update_mcb_phrases_shows_last_mgid_5
    media_update_mcb_phrases_shows_last_mgid_6
    media_update_mcb_phrases_shows_last_mgid_7
    media_update_mcb_phrases_shows_last_mgid_8
    media_update_mcb_phrases_shows_last_mgid_9
    media_update_mcb_phrases_shows_last_mgid_10
    media_update_mcb_phrases_shows_last_mgid_11
    media_update_mcb_phrases_shows_last_mgid_12
    media_update_mcb_phrases_shows_last_mgid_13
    media_update_mcb_phrases_shows_last_mgid_14
    media_update_mcb_phrases_shows_last_mgid_15
    order_stat_day_invalid_data_last
    order_stat_day_invalid_data_reviewed
    use_yt_stat_for_order_sessions_num
/;

$log->out('START');

$log->out("fetch old values");
my $old = get_all_sql(PPCDICT, ["SELECT name, value, last_change FROM ppc_properties", WHERE => {name => \@props}]);

for my $prop (@$old) {
    $log->out({backup => $prop});
}

$log->out("going to delete properties");
my $res = do_delete_from_table(PPCDICT, "ppc_properties", where => {name => \@props});
$log->out("deleted $res rows");

$log->out('FINISH');

