#!/usr/bin/env perl

=head1 DEPLOY

# .migr
{
    approved_by => 'ppalex',
    tasks => [
        {
            type => 'script',
            when => 'after',
            time_estimate => "1m"
        }
    ]
}

=cut

use Direct::Modern;
use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;
use ShardingTools qw/foreach_shard_parallel_verbose/;

use List::MoreUtils qw/part/;

$log->out('START');

foreach_shard_parallel_verbose($log, sub {
    my $shard = shift;
    my $cid2dontshow = get_hash_sql(PPC(shard => $shard), q/SELECT cid, DontShow FROM campaigns WHERE DontShow REGEXP '(^|,)id[0-9]+(,|$)'/);
    my %update_hash;
    for my $cid (keys %$cid2dontshow) {
        my $dont_show_string = $cid2dontshow->{$cid};
        my @dont_show_array = split /,/, $dont_show_string;
        my @split_arrays = part {m/^id[0-9]+$/ ? 1 : 0} @dont_show_array;
        my $new_dont_show_string = join ',', @{$split_arrays[0] || []};
        my $removed_part_string = join ',', @{$split_arrays[1] || []};
        if (length $dont_show_string != length $new_dont_show_string) {
            $log->out({"Original value for cid $cid" => $dont_show_string});
            $log->out({"Removed part for cid $cid" => $removed_part_string});
            $update_hash{$cid} = {DontShow => $new_dont_show_string};
        }
    }
    do_mass_update_sql(PPC(shard => $shard), 'campaigns', 'cid', \%update_hash);
});

$log->out('FINISH');
