#!/usr/bin/env perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "3s"
    }
  ],
  approved_by => 'ppalex'
}

=cut

use Direct::Modern;

use Yandex::Balance;
use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

use BalanceQueue;

$log->out('START');

do_sql(PPC(ClientID => 1724432), "UPDATE campaigns SET uid = 129344231 WHERE uid = 256067232 AND ClientID = 1724432");
do_sql(PPC(ClientID => 1724432), "UPDATE vcards SET uid = 129344231 WHERE uid = 256067232");
do_sql(PPC(ClientID => 1724432), "UPDATE users SET rep_type = 'chief' WHERE uid = 129344231");
do_sql(PPC(ClientID => 1724432), "UPDATE clients SET chief_uid = 129344231 WHERE ClientID = 1724432");

$log->out('Notifying Balance');
my $rep_uid = 129344231;
eval {
    balance_set_main_rep_of_client(0, $rep_uid);
};
BalanceQueue::add_to_balance_info_queue(0, uid => $rep_uid, BalanceQueue::PRIORITY_USER_ON_SWITCHED_CLIENT_CHIEF);

$log->out('FINISH');

