#!/usr/bin/env perl

=head1 DEPLOY

# .migr
{
    approved_by => 'ppalex',
    tasks => [
        {
            type => 'script',
            when => 'instructions',
            time_estimate => "пара секунд",
            instructions => 'перед запуском спросить у sco76, что с dry-run на ропроде в логах нет аномалий'
        }
    ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;

use my_inc '..';

use ScriptHelper;
use Settings;

my $DRY_RUN;
extract_script_params(
    'dry-run' => \$DRY_RUN,
);

$log->out('START');

# меняем только availability, т. к. остальных в проде нет (кроме одного с wheel и is_deleted = 1)
# актуальный список получается из запроса https://yql.yandex-team.ru/Operations/XcQFbglcTqZ0aZ9qQTeGj_Ex32ylw_TEdCFaqe9p_7g=
my $pids_performance = [qw/3741024569 3763099007 1959683469 1752724003/];
my $bids_performance_records = get_all_sql(PPC(pid => $pids_performance), ["select perf_filter_id, pid, condition_json from bids_performance", where => {pid => SHARD_IDS, is_deleted => 0}]);
for my $record (@$bids_performance_records) {
    my $condition = $record->{condition_json};
    if ($condition =~ /"availability(?: ==)?"/) {
        $condition =~ s/"availability(?: ==)?"/"availability ilike"/;
        if ($condition =~ /:"в наличии"/) {
            $condition =~ s/:"в наличии"/:["в наличии"]/;
        }
        $log->out({"Old bids_performance record" => $record,
            "Updated bids_performance condition" => $condition});
        if (!$DRY_RUN) {
            do_update_table(PPC(pid => $record->{pid}), "bids_performance", {condition_json => $condition},
                where => {pid => $record->{pid}, perf_filter_id => $record->{perf_filter_id}, condition_json => $record->{condition_json}});
        }
    }
}

my $dc_pids = [qw/3337154699 3381550682 2991852781/];
my $dynamic_conditions_records = get_all_sql(PPC(pid => $dc_pids), ["select dyn_cond_id, pid, condition_json from dynamic_conditions", where => {pid => SHARD_IDS}]);
$log->out({"Old dynamic_conditions data" => $dynamic_conditions_records});
for my $record (@$dynamic_conditions_records) {
    my $condition = $record->{condition_json};
    if ($condition =~ /"availability(?: ==)?"/) {
        $condition =~ s/"availability(?: ==)?"/"availability ilike"/;
        $log->out({"Old dynamic_conditions record" => $record,
            "Updated dynamic_conditions condition" => $condition});
        if (!$DRY_RUN) {
            do_update_table(PPC(pid => $record->{pid}), "dynamic_conditions", {condition_json => $condition},
                where => {pid => $record->{pid}, dyn_cond_id => $record->{dyn_cond_id}, condition_json => $record->{condition_json}});
        }
    }
}

$log->out('FINISH');
