#!/usr/bin/env perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "4 минуты на devtest"
    }
  ],
  approved_by => 'yukaba'
}

=cut

use Direct::Modern;

use Path::Tiny qw(path);

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

# Удаляем таблицы
#   Штучно
#       logwelcomeletters
#       moderate_history
#   Массово
#       phrases_bs_log_% 
#       banners_bs_log_% 
#       logcmd_%
#

my $all_tables = path(my_inc::path('../data/unused_ppclog_tables.list'))->slurp;
$log->out('START');

foreach my $table (split /\n/, $all_tables) {
    next unless $table =~/\w+/;
    my $drop = "DROP TABLE IF EXISTS $table";
    $log->out($drop);
    do_sql(PPCLOG, $drop);
}

$log->out('FINISH');

