#!/usr/bin/env perl

=head1 DEPLOY

# .migr
{
  approved_by => 'ppalex',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "2s"
    }
  ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;

use my_inc '..';

use ScriptHelper;
use Settings;

$log->out('START');

# https://yql.yandex-team.ru/Operations/XdLm0Z9LngUjrczzBboNhtyGxV4egU7wAu5ora-ZWNs=
my @wallet_cids = (8911417, 9144840, 14678429, 16526659, 16812323, 16991194, 17030315, 17444186, 18451921, 18456265, 18621936, 18663998, 20405848,
    20556764, 20806131, 21548744, 22227087, 23093636, 25179690, 28108494, 30222892, 30325130, 35194382, 35731375, 35833970, 39213344);

my $rows_cnt = do_update_table(PPC(cid => \@wallet_cids), 'wallet_campaigns', {autopay_mode => 'none'}, where => {wallet_cid => SHARD_IDS});
$log->out("updated $rows_cnt rows");

$log->out('FINISH');
