#!/usr/bin/env perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "работает 3,5 минуты на dev7 c ppcdev5 без sleep'а, общее ожидаемое время работы ~15 минут",
      comment => "можно перезапускать, сбрасывает статус синхронизации кампаниям(~750), данные надо привезти с ppcdev5
            scp ppcdev5:/opt/ppc-data/deploy-data/20191123_restore_lost_geo_bidmodifiers.data .
            путь к этому файлу нужно будет указать в параметрах запуска,
            ./20191123_restore_lost_geo_bidmodifiers.pl --data-file=20191123_restore_lost_geo_bidmodifiers.data"
    }
  ],
  approved_by => 'xy6er'
}

=cut

use my_inc '..';

use BS::ResyncQueue;
use HierarchicalMultipliers qw/get_hierarchical_multipliers save_hierarchical_multipliers/;
use Direct::Modern;
use ScriptHelper 'Yandex::Log' => [ date_suf => '%Y%m%d', auto_rotate => 1, tee => $ENV{LOG_TEE}, lock => 1 ];
use Settings;
use Data::Dumper;

my $DRY_RUN;
my $data_path;

extract_script_params(
    'dry-run' => \$DRY_RUN,
    'data-file=s' => \$data_path,
);

$log->out( "START for file: $data_path" );
$log->out( "load data for refresh from file $data_path" );

open (my $fh, '<', $data_path) or $log->die( "Error opening file: $!" );
my $cnt = 0;
my %values_by_cid = ();
while (my $line = <$fh>) {
    chomp( $line );
    my ( $cid, $values ) = split(/;/, $line);
    my @result = map{ my($geo, $pct) = split(/:/, $_);  {region_id => $geo, multiplier_pct => $pct}} split(/,/, $values);
    $values_by_cid{ $cid } = \@result;
    $cnt++;
}
close ($fh) or $log->die( "Error closing file: $!" );

$log->out( "Got $cnt orders to refresh" );

my @cids_success;
my @cids_with_multipliers;
my @cids_failed;

while ( my ( $cid, @regions_list ) = each( %values_by_cid ) ) {
    $log->out( "START for cid: $cid" );
    my $old_multipliers = get_hierarchical_multipliers( $cid );
    if ( exists $old_multipliers->{geo_multiplier} ) {
        $log->out( "$cid already has geo_multiplier" );
        $log->out( "FINISH for cid: $cid. Nothing changed" );

        push @cids_with_multipliers, $cid;
    } else {
        $old_multipliers->{geo_multiplier} =  {
            is_enabled => 1,
            regions => @regions_list
        };
        $log->out( "Gonna add regions coef for cid: $cid. coefs:".Dumper \@regions_list );
        $log->out( "Gonna save for cid: $cid coefs:".Dumper $old_multipliers );
        if ( !$DRY_RUN ) {
            my $res = save_hierarchical_multipliers($cid, undef, $old_multipliers);
            if ( $res ) {
                $log->out("adding campaign $cid to resync_queue");
                my @resync_campaigns = {
                    cid      => $cid,
                    pid      => 0,
                    bid      => 0,
                    priority => 100 };
                $log->out({ resync_data_campaigns => \@resync_campaigns });
                bs_resync(\@resync_campaigns);
                $log->out( "FINISH for cid: $cid with res: $res" );
                push @cids_success, $cid;
            } else {
                $log->out( "FINISH for cid: $cid with ERROR: something went wrong with saving multipliers" ) ;
                push @cids_failed, $cid;
            }
        } else {
            $log->out( "FINISH for cid: $cid dry" );
        }
    }
    $log->out( "Seconds slept: ".sleep(1) );
}

if ( !$DRY_RUN ) {
    $log->out( "Successfully updated cids: @cids_success" );
    $log->out( "Cids failed to update: @cids_failed" );
}

$log->out( "Cids already with region multipliers: @cids_with_multipliers" );
$log->out( "FINISH migration" );
