#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'ppalex',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "около двух часов",
      comment => "время рассчитано по времени на одном шарде devtest. можно перезапускать"
    }
  ]
}

=cut

use Direct::Modern;
use Yandex::DBTools;
use my_inc '..';
use ScriptHelper;
use Settings;
use ShardingTools qw/ppc_shards/;
use Yandex::Balance qw/balance_get_client_persons/;
use Yandex::Retry;
use Yandex::ListUtils qw/chunks/;


extract_script_params(
	'shard=i' => \my $only_shard
);

$log->out('START');

foreach my $shard (ppc_shards()) {

	if ($only_shard && $only_shard ne $shard) {
		next;
	}

	$log->out("process shard $shard");

	my %to_update;
	my $client_ids = get_all_sql(PPC(shard => $shard), 'SELECT DISTINCT a.wallet_cid, ClientID FROM autopay_settings a join campaigns c on a.wallet_cid = c.cid where person_id is null');

	foreach my $chunk (chunks($client_ids, 500)) {

		my $relax_guard = relaxed_guard(times => 0.5);

		foreach my $row (@$client_ids) {

			my $wallet_cid = $row->{wallet_cid};
			my $client_id = $row->{ClientID};
			my $persons = balance_get_client_persons($client_id);
			my $found_ph_person_id = -1;

			foreach my $person (@$persons) {
				if (($person->{type} eq 'ph') && !$person->{hidden}) {
					$found_ph_person_id = $person->{id};
					last;
				}
			}
			if ($found_ph_person_id == -1) {
				$log->out("Error! Found client $client_id with no ph persons");
			} else {
				$to_update{$wallet_cid} = { person_id => $found_ph_person_id };
			}
		}
	}

	$log->out("To update values:", \%to_update);
	my $updated = do_mass_update_sql(PPC(shard => $shard), 'autopay_settings', 'wallet_cid', \%to_update,
		where => { person_id__is_null => 1 });
	$log->out("Updated $updated values");
}

$log->out('FINISH');
