#!/usr/bin/env perl

=head1 DEPLOY

# .migr
{
  approved_by => 'gerdler',
  tasks => [
    {
      type => 'script',
      when => 'instructions',
      instructions => "Запустить, когда скажет sco76 (когда мобильное приложение будет готово раскатываться)",
      time_estimate => "10s"
    }
  ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;
use ShardingTools qw/foreach_shard_parallel_verbose/;

$log->out('START');

foreach_shard_parallel_verbose($log, sub {
    my $shard = shift;
    my $notification_ids = get_one_column_sql(PPC(shard => $shard), "SELECT un.notification_id FROM users_notifications un
        JOIN users_notifications_details und
        ON un.notification_id = und.notification_id
        WHERE un.type = 'APNS'
        GROUP BY un.notification_id
        HAVING GROUP_CONCAT(und.event_type) NOT LIKE '%custom_message_with_link%'"
    );
    if (@$notification_ids) {
        # push @$notification_ids, (1, 4, 7); # для проверки корректности удаления
        $log->out({"Will add the new event_type to these notification_ids" => $notification_ids});
        my @to_insert = map {[$_, 'custom_message_with_link']} @$notification_ids;
        my $cnt = do_mass_insert_sql(PPC(shard => $shard), "INSERT IGNORE INTO users_notifications_details (notification_id, event_type) VALUES %s", \@to_insert);
        $log->out("Added $cnt rows");
        my $bad_notification_ids = get_one_column_sql(PPC(shard => $shard), ["SELECT und.notification_id FROM users_notifications un
            RIGHT JOIN users_notifications_details und
            ON un.notification_id = und.notification_id",
            where => {
                'un.notification_id__is_null' => 1,
                'und.notification_id' => $notification_ids,
                'und.event_type' => 'custom_message_with_link'
            }
        ]);
        if (@$bad_notification_ids) {
            $log->out({"Will delete these notification_ids from users_notifications_details" => $bad_notification_ids});
            $cnt = do_delete_from_table(PPC(shard => $shard), 'users_notifications_details',
                where => {notification_id => $bad_notification_ids, 'event_type' => 'custom_message_with_link'});
            $log->out("Deleted $cnt rows");
        }
    }
});

$log->out('FINISH');
