#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'yukaba',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "секунды"
    }
  ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';
use Settings;
use ScriptHelper;

$log->out('START');

my %missing_clientids = (
    29466342 => 31080319,
    29466343 => 31080319,
    29466428 => 65087162,
    29466429 => 65087162,
    29470776 => 70024751,
    29474028 => 69973096,
);
for my $order_id (sort keys %missing_clientids) {
    my $client_id = $missing_clientids{$order_id};
    $log->out("inserting OrderID = $order_id, ClientID = $client_id");
    do_insert_into_table(PPCDICT, 'shard_order_id', {OrderID => $order_id, ClientID => $client_id});
}

my %fix_clientids = (
924854 => 2522161,
925731 => 2528176,
1119109 => 1997819,
1930683 => 1849538,
2011064 => 3285008,
2414149 => 2435462,
3161076 => 4244630,
3223801 => 4343222,
16161794 => 7453858,
29466419 => 69962532,
3039532 => 2915449,
3039966 => 2407780,
3244859 => 3374268,
3286434 => 5314164,
3415245 => 3346403,
3463208 => 2275297,
3703876 => 5132692,
3785926 => 2237391,
29466349 => 70024746,
1028347 => 476562,
1712742 => 2170650,
3057879 => 1243424,
3299064 => 1296731,
3343600 => 3444401,
3396106 => 952287,
3430716 => 4521345,
3692720 => 3670992,
);
for my $order_id (sort keys %fix_clientids) {
    my $client_id = $fix_clientids{$order_id};
    $log->out("updating ClientID for OrderID = $order_id; new ClientID = $client_id");
    do_update_table(PPCDICT, 'shard_order_id', {ClientID => $client_id}, where => {OrderID => $order_id});
}
$log->out('FINISH');
