#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'hrustyashko',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "1 секунда",
      comment => "если упадёт с ошибкой, скажите andreymak@, пожалуйста"
    }
  ]
}

=cut

use Direct::Modern;

use JSON;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

my $KEYWORD = 'brand-safety-categories';

# perl-made
# perl -E 'for (0..17) { say "    { goal_id => ".(4294967296 + $_).", bb_keyword => \$KEYWORD, bb_keyword_value => ".2**$_." }," }'
my @NEW_VALUES = (
    { goal_id => 4294967296, bb_keyword => $KEYWORD, bb_keyword_value => 1 },
    { goal_id => 4294967297, bb_keyword => $KEYWORD, bb_keyword_value => 2 },
    { goal_id => 4294967298, bb_keyword => $KEYWORD, bb_keyword_value => 4 },
    { goal_id => 4294967299, bb_keyword => $KEYWORD, bb_keyword_value => 8 },
    { goal_id => 4294967300, bb_keyword => $KEYWORD, bb_keyword_value => 16 },
    { goal_id => 4294967301, bb_keyword => $KEYWORD, bb_keyword_value => 32 },
    { goal_id => 4294967302, bb_keyword => $KEYWORD, bb_keyword_value => 64 },
    { goal_id => 4294967303, bb_keyword => $KEYWORD, bb_keyword_value => 128 },
    { goal_id => 4294967304, bb_keyword => $KEYWORD, bb_keyword_value => 256 },
    { goal_id => 4294967305, bb_keyword => $KEYWORD, bb_keyword_value => 512 },
    { goal_id => 4294967306, bb_keyword => $KEYWORD, bb_keyword_value => 1024 },
    { goal_id => 4294967307, bb_keyword => $KEYWORD, bb_keyword_value => 2048 },
    { goal_id => 4294967308, bb_keyword => $KEYWORD, bb_keyword_value => 4096 },
    { goal_id => 4294967309, bb_keyword => $KEYWORD, bb_keyword_value => 8192 },
    { goal_id => 4294967310, bb_keyword => $KEYWORD, bb_keyword_value => 16384 },
    { goal_id => 4294967311, bb_keyword => $KEYWORD, bb_keyword_value => 32768 },
    { goal_id => 4294967312, bb_keyword => $KEYWORD, bb_keyword_value => 65536 },
    { goal_id => 4294967313, bb_keyword => $KEYWORD, bb_keyword_value => 131072 },
);

$log->out('START');

my @goal_ids = map { $_->{goal_id} } @NEW_VALUES;
my $old_rows = get_all_sql(PPCDICT, ["
    SELECT goal_id, bb_keyword, bb_keyword_value
    FROM crypta_goals",
    WHERE => [goal_id => \@goal_ids]
]);
if (@$old_rows != @NEW_VALUES) {
    $log->die("not all crypta goals were found in crypta_goals!");
}
my @goals_with_old_data = grep { defined($_->{bb_keyword}) || defined($_->{bb_keyword_value}) } @$old_rows;
if (@goals_with_old_data) {
    $log->die("some crypta goals already have bb_keyword or bb_keyword_value set!", to_json(\@goals_with_old_data));
}
$log->out("checked that all crypta goals are present in table and have no values in bb_keyword or bb_keyword_value");

for my $row (@NEW_VALUES) {
    my $new_data = $row;
    my $goal_id = delete $new_data->{goal_id};

    $log->out("updating $goal_id", $new_data);
    do_update_table(PPCDICT, "crypta_goals", $new_data, where => {goal_id => $goal_id});
}

$log->out('FINISH');

