#!/bin/bash
set -ex

CLICKHOUSES=$(echo ppchouse{01i,01f,01k,02e,02i,02k,03f,03k,03e,04f,04k,04e}.yandex.ru)
#CLICKHOUSES=$(echo ppchouse01i.yandex.ru)

for ch in $CLICKHOUSES; do
echo 1 $ch
clickhouse-client -h "$ch" <<'END_OF_QUERY'
CREATE DATABASE IF NOT EXISTS `user_action_log`
END_OF_QUERY
done

for ch in $CLICKHOUSES; do
echo 2 $ch
clickhouse-client -h "$ch" <<'END_OF_QUERY'
CREATE TABLE IF NOT EXISTS `user_action_log`.`user_action_log` (
    date Date,
    datetime DateTime,
    path String,
    gtid String,
    query_serial UInt32,
    row_serial UInt32,
    reqid Int64,
    method String,
    service String,
    db String,
    type String,
    operation Enum8('INSERT'=1, 'UPDATE'=2, 'DELETE'=3),
    old_fields Nested(name String, value String, is_null Enum8('true'=1, 'false'=0)),
    new_fields Nested(name String, value String, is_null Enum8('true'=1, 'false'=0)),
    collapsing_sign Int8 DEFAULT 1
) ENGINE = Distributed(
    `logs`,
    `user_action_log`,
    `user_action_log_mergetree`,
    rand()
)
END_OF_QUERY
done

for ch in $CLICKHOUSES; do
echo 3 $ch
clickhouse-client -h "$ch" <<'END_OF_QUERY'
CREATE TABLE IF NOT EXISTS `user_action_log`.`user_action_log_mergetree` (
    date Date,
    datetime DateTime,
    path String,
    gtid String,
    query_serial UInt32,
    row_serial UInt32,
    reqid Int64,
    method String,
    service String,
    db String,
    type String,
    operation Enum8('INSERT'=1, 'UPDATE'=2, 'DELETE'=3),
    old_fields Nested(name String, value String, is_null Enum8('true'=1, 'false'=0)),
    new_fields Nested(name String, value String, is_null Enum8('true'=1, 'false'=0)),
    collapsing_sign Int8 DEFAULT 1
) ENGINE = ReplicatedCollapsingMergeTree(
    '/clickhouse/tables/{shard}/user_action_log__user_action_log_mergetree',
    '{replica}',
    date,
    (date, path, gtid, query_serial, row_serial),
    1024,
    collapsing_sign
)
END_OF_QUERY
done

for ch in $CLICKHOUSES; do
echo 4 $ch
clickhouse-client -h "$ch" <<'END_OF_QUERY'
CREATE TABLE IF NOT EXISTS `user_action_log`.`user_action_log_state` (
    source String,
    date Date,
    datetime DateTime,
    state String,
    collapsing_sign Int8 DEFAULT 1
) ENGINE = ReplicatedCollapsingMergeTree(
    '/clickhouse/tables/{shard}/user_action_log__user_action_log_state',
    '{replica}',
    date,
    (source, date),
    1024,
    collapsing_sign
)
END_OF_QUERY
done

for ch in $CLICKHOUSES; do
echo 5 $ch
clickhouse-client -h "$ch" <<'END_OF_QUERY'
CREATE TABLE IF NOT EXISTS `user_action_log`.`dict` (
    type Int32,
    shard String,
    id Int64,
    value String,
    last_updated DateTime,
    date Date
) ENGINE = Distributed(
    `logs`,
    `user_action_log`,
    `dict_mergetree`,
    rand()
)
END_OF_QUERY
done

for ch in $CLICKHOUSES; do
echo 6 $ch
clickhouse-client -h "$ch" <<'END_OF_QUERY'
CREATE TABLE IF NOT EXISTS `user_action_log`.`dict_mergetree` (
    type Int32,
    shard String,
    id Int64,
    value String,
    last_updated DateTime,
    date Date
) ENGINE = ReplicatedReplacingMergeTree(
    '/clickhouse/tables/{shard}/user_action_log__dict_mergetree',
    '{replica}',
    `date`,
    (`type`, `shard`, `id`),
    8192,
    `last_updated`
)
END_OF_QUERY
done

for ch in $CLICKHOUSES; do
echo _01 $ch
clickhouse-client -h "$ch" <<'END_OF_QUERY'
CREATE TABLE IF NOT EXISTS `user_action_log`.`journal_dict_mergetree_01` (
    date Date,
    shard String,
    type Int32,
    id Int64,
    value String,
    last_updated DateTime,
    server_uuid String,
    server_event_id Int64
) ENGINE = ReplicatedMergeTree(
    '/clickhouse/tables/{shard}/user_action_log__journal_dict_mergetree_01',
    '{replica}',
    `date`,
    (`type`, `shard`, `id`),
    8192
)
END_OF_QUERY
done

for ch in $CLICKHOUSES; do
echo _02 $ch
clickhouse-client -h "$ch" <<'END_OF_QUERY'
CREATE TABLE IF NOT EXISTS `user_action_log`.`journal_dict_mergetree_02` (
    date Date,
    shard String,
    type Int32,
    id Int64,
    value String,
    last_updated DateTime,
    server_uuid String,
    server_event_id Int64
) ENGINE = ReplicatedMergeTree(
    '/clickhouse/tables/{shard}/user_action_log__journal_dict_mergetree_02',
    '{replica}',
    `date`,
    (`type`, `shard`, `id`),
    8192
)
END_OF_QUERY
done

for ch in $CLICKHOUSES; do
echo _03 $ch
clickhouse-client -h "$ch" <<'END_OF_QUERY'
CREATE TABLE IF NOT EXISTS `user_action_log`.`journal_dict_mergetree_03` (
    date Date,
    shard String,
    type Int32,
    id Int64,
    value String,
    last_updated DateTime,
    server_uuid String,
    server_event_id Int64
) ENGINE = ReplicatedMergeTree(
    '/clickhouse/tables/{shard}/user_action_log__journal_dict_mergetree_03',
    '{replica}',
    `date`,
    (`type`, `shard`, `id`),
    8192
)
END_OF_QUERY
done

for ch in $CLICKHOUSES; do
echo _04 $ch
clickhouse-client -h "$ch" <<'END_OF_QUERY'
CREATE TABLE IF NOT EXISTS `user_action_log`.`journal_dict_mergetree_04` (
    date Date,
    shard String,
    type Int32,
    id Int64,
    value String,
    last_updated DateTime,
    server_uuid String,
    server_event_id Int64
) ENGINE = ReplicatedMergeTree(
    '/clickhouse/tables/{shard}/user_action_log__journal_dict_mergetree_04',
    '{replica}',
    `date`,
    (`type`, `shard`, `id`),
    8192
)
END_OF_QUERY
done

for ch in $CLICKHOUSES; do
echo _05 $ch
clickhouse-client -h "$ch" <<'END_OF_QUERY'
CREATE TABLE IF NOT EXISTS `user_action_log`.`journal_dict_mergetree_05` (
    date Date,
    shard String,
    type Int32,
    id Int64,
    value String,
    last_updated DateTime,
    server_uuid String,
    server_event_id Int64
) ENGINE = ReplicatedMergeTree(
    '/clickhouse/tables/{shard}/user_action_log__journal_dict_mergetree_05',
    '{replica}',
    `date`,
    (`type`, `shard`, `id`),
    8192
)
END_OF_QUERY
done

for ch in $CLICKHOUSES; do
echo _06 $ch
clickhouse-client -h "$ch" <<'END_OF_QUERY'
CREATE TABLE IF NOT EXISTS `user_action_log`.`journal_dict_mergetree_06` (
    date Date,
    shard String,
    type Int32,
    id Int64,
    value String,
    last_updated DateTime,
    server_uuid String,
    server_event_id Int64
) ENGINE = ReplicatedMergeTree(
    '/clickhouse/tables/{shard}/user_action_log__journal_dict_mergetree_06',
    '{replica}',
    `date`,
    (`type`, `shard`, `id`),
    8192
)
END_OF_QUERY
done

for ch in $CLICKHOUSES; do
echo _07 $ch
clickhouse-client -h "$ch" <<'END_OF_QUERY'
CREATE TABLE IF NOT EXISTS `user_action_log`.`journal_dict_mergetree_07` (
    date Date,
    shard String,
    type Int32,
    id Int64,
    value String,
    last_updated DateTime,
    server_uuid String,
    server_event_id Int64
) ENGINE = ReplicatedMergeTree(
    '/clickhouse/tables/{shard}/user_action_log__journal_dict_mergetree_07',
    '{replica}',
    `date`,
    (`type`, `shard`, `id`),
    8192
)
END_OF_QUERY
done

for ch in $CLICKHOUSES; do
echo _08 $ch
clickhouse-client -h "$ch" <<'END_OF_QUERY'
CREATE TABLE IF NOT EXISTS `user_action_log`.`journal_dict_mergetree_08` (
    date Date,
    shard String,
    type Int32,
    id Int64,
    value String,
    last_updated DateTime,
    server_uuid String,
    server_event_id Int64
) ENGINE = ReplicatedMergeTree(
    '/clickhouse/tables/{shard}/user_action_log__journal_dict_mergetree_08',
    '{replica}',
    `date`,
    (`type`, `shard`, `id`),
    8192
)
END_OF_QUERY
done

for ch in $CLICKHOUSES; do
echo _09 $ch
clickhouse-client -h "$ch" <<'END_OF_QUERY'
CREATE TABLE IF NOT EXISTS `user_action_log`.`journal_dict_mergetree_09` (
    date Date,
    shard String,
    type Int32,
    id Int64,
    value String,
    last_updated DateTime,
    server_uuid String,
    server_event_id Int64
) ENGINE = ReplicatedMergeTree(
    '/clickhouse/tables/{shard}/user_action_log__journal_dict_mergetree_09',
    '{replica}',
    `date`,
    (`type`, `shard`, `id`),
    8192
)
END_OF_QUERY
done

for ch in $CLICKHOUSES; do
echo _10 $ch
clickhouse-client -h "$ch" <<'END_OF_QUERY'
CREATE TABLE IF NOT EXISTS `user_action_log`.`journal_dict_mergetree_10` (
    date Date,
    shard String,
    type Int32,
    id Int64,
    value String,
    last_updated DateTime,
    server_uuid String,
    server_event_id Int64
) ENGINE = ReplicatedMergeTree(
    '/clickhouse/tables/{shard}/user_action_log__journal_dict_mergetree_10',
    '{replica}',
    `date`,
    (`type`, `shard`, `id`),
    8192
)
END_OF_QUERY
done

for ch in $CLICKHOUSES; do
echo _11 $ch
clickhouse-client -h "$ch" <<'END_OF_QUERY'
CREATE TABLE IF NOT EXISTS `user_action_log`.`journal_dict_mergetree_11` (
    date Date,
    shard String,
    type Int32,
    id Int64,
    value String,
    last_updated DateTime,
    server_uuid String,
    server_event_id Int64
) ENGINE = ReplicatedMergeTree(
    '/clickhouse/tables/{shard}/user_action_log__journal_dict_mergetree_11',
    '{replica}',
    `date`,
    (`type`, `shard`, `id`),
    8192
)
END_OF_QUERY
done

for ch in $CLICKHOUSES; do
echo _12 $ch
clickhouse-client -h "$ch" <<'END_OF_QUERY'
CREATE TABLE IF NOT EXISTS `user_action_log`.`journal_dict_mergetree_12` (
    date Date,
    shard String,
    type Int32,
    id Int64,
    value String,
    last_updated DateTime,
    server_uuid String,
    server_event_id Int64
) ENGINE = ReplicatedMergeTree(
    '/clickhouse/tables/{shard}/user_action_log__journal_dict_mergetree_12',
    '{replica}',
    `date`,
    (`type`, `shard`, `id`),
    8192
)
END_OF_QUERY
done

for ch in $CLICKHOUSES; do
echo _13 $ch
clickhouse-client -h "$ch" <<'END_OF_QUERY'
CREATE TABLE IF NOT EXISTS `user_action_log`.`journal_dict_mergetree_13` (
    date Date,
    shard String,
    type Int32,
    id Int64,
    value String,
    last_updated DateTime,
    server_uuid String,
    server_event_id Int64
) ENGINE = ReplicatedMergeTree(
    '/clickhouse/tables/{shard}/user_action_log__journal_dict_mergetree_13',
    '{replica}',
    `date`,
    (`type`, `shard`, `id`),
    8192
)
END_OF_QUERY
done

for ch in $CLICKHOUSES; do
echo _14 $ch
clickhouse-client -h "$ch" <<'END_OF_QUERY'
CREATE TABLE IF NOT EXISTS `user_action_log`.`journal_dict_mergetree_14` (
    date Date,
    shard String,
    type Int32,
    id Int64,
    value String,
    last_updated DateTime,
    server_uuid String,
    server_event_id Int64
) ENGINE = ReplicatedMergeTree(
    '/clickhouse/tables/{shard}/user_action_log__journal_dict_mergetree_14',
    '{replica}',
    `date`,
    (`type`, `shard`, `id`),
    8192
)
END_OF_QUERY
done

for ch in $CLICKHOUSES; do
echo 7 $ch
clickhouse-client -h "$ch" <<'END_OF_QUERY'
CREATE TABLE IF NOT EXISTS `user_action_log`.`journal_dict` (
    type Int32,
    shard String,
    id Int64,
    value String,
    last_updated DateTime,
    server_uuid String,
    server_event_id Int64
) ENGINE = Merge(
    `user_action_log`,
    '^journal_dict_mergetree_'
)
END_OF_QUERY
done

