#! /bin/bash
#
# apache	Start the apache HTTP server.
#

NAME=fake-services.direct.yandex.ru
PATH=/bin:/usr/bin:/sbin:/usr/sbin
DAEMON=/usr/sbin/apache2
PIDFILE=/var/run/$NAME.pid
CONF=/etc/apache2/$NAME.conf
APACHECTL=/usr/sbin/apache2ctl

trap "" 1
export LANG=C
export PATH
unset PERL5LIB

test -f $DAEMON || exit 0
test -f $APACHECTL || exit 0

# ensure we don't leak environment vars into apachectl
APACHECTL="env -i LANG=${LANG} PATH=${PATH} $APACHECTL"

ulimit -u 1024
ulimit -n 4096
ulimit -v 4000000

case "$1" in
  start)
    echo -n "Starting web server: $NAME"
    start-stop-daemon --start --pidfile $PIDFILE --exec $DAEMON -- -f $CONF
    ;;

  stop)
    echo -n "Stopping web server: $NAME"
    start-stop-daemon --stop --pidfile $PIDFILE --oknodo --exec $DAEMON
    ;;

  reload)
    echo -n "Reloading $NAME configuration"
    start-stop-daemon --stop --pidfile $PIDFILE --signal USR1 --exec $DAEMON
    ;;

  reload-modules)
    echo -n "Reloading $NAME modules"
    start-stop-daemon --stop --pidfile $PIDFILE --oknodo --retry 30
    start-stop-daemon --start --pidfile $PIDFILE --exec $DAEMON -- -f $CONF
    ;;

  restart)
    $0 reload-modules
    exit $?
    ;;

  force-reload)
    $0 reload-modules
    exit $?
    ;;

  *)
    echo "Usage: /etc/init.d/$NAME {start|stop|reload|reload-modules|force-reload|restart}"
    exit 1
    ;;
esac

if [ $? == 0 ]; then
	echo .
	exit 0
else
	echo failed
	exit 1
fi
