#! /bin/bash
#
# apache	Start the apache HTTP server.
#

NAME=ppc.yandex.ru
PATH=/bin:/usr/bin:/sbin:/usr/sbin
DAEMON=/usr/sbin/apache2
PIDFILE=[% IF dev %][% root %]/apache/run[% ELSE %]/var/run[% END %]/$NAME.pid
CONF=[% IF dev %][% root %]/apache/conf/httpd.conf[% ELSE %]/etc/apache2/$NAME.conf[% END %]
[% IF dev %]PERL5LIB=[% perl5lib %][% END -%]

[% IF !dev %]ulimit -v 8000000[% END %]

trap "" 1
export LANG=C
export LANGUAGE=
export PATH
[% IF dev %]
export PERL5LIB
[% END %]

test -f $DAEMON || exit 0

[% IF !dev %]ulimit -u 1024
ulimit -n 4096[% END %]

case "$1" in
  start)
    echo -n "Starting web server: $NAME"
    start-stop-daemon --start --pidfile $PIDFILE --exec $DAEMON -- -f $CONF
    echo .
    ;;

  stop)
    echo -n "Stopping web server: $NAME"
    start-stop-daemon --stop --pidfile $PIDFILE --oknodo --exec $DAEMON
    echo .
    ;;

  reload)
    echo -n "Reloading $NAME configuration"
    start-stop-daemon --stop --pidfile $PIDFILE --signal USR1 --exec $DAEMON
    echo .
    ;;

  reload-modules)
    echo -n "Reloading $NAME modules"
    start-stop-daemon --stop --pidfile $PIDFILE --oknodo --retry 30 -- -f $CONF
    start-stop-daemon --start --pidfile $PIDFILE --exec $DAEMON
    echo .
    ;;

  restart)
    echo -n "Restarting $NAME"
    start-stop-daemon --stop --pidfile $PIDFILE --oknodo --retry 30 -- -f $CONF
    start-stop-daemon --start --pidfile $PIDFILE --exec $DAEMON -- -f $CONF
    echo .
    exit $?
    ;;

  force-reload)
    $0 reload-modules
    exit $?
    ;;

  configtest)
    echo "Testing config file validity"
    $DAEMON -t $CONF
    exit $?
    ;;


  *)
    echo "Usage: /etc/init.d/$NAME {start|stop|reload|reload-modules|force-reload|restart}"
    exit 1
    ;;
esac

if [ $? == 0 ]; then
	echo .
	exit 0
else
	echo failed
	exit 1
fi
