use strict;
use warnings;

=head1 NAME

=head1 DESCRIPTION

правила, не специфичные для разработческих рабочих копий

=head1 COMMENTS

=cut

package General;

use Yandex::Shell;

use utf8;


our %ACTIONS = (
    translations_tanker => {
        timeout => 2400,
        todo => [
            'action:translations_checkout_bricks_tanker',
            'update_translations.pl --config etc/translation.conf',
            'action:translations_update_data3',
            #'./protected/getBannerStorageDicts.pl --translate',
            'action:translations_tests'
        ]
    },
    translations_tests => [
        './unit_tests/runtests.pl unit_tests/templates/compile_emails.t || true',
        './unit_tests/runtests.pl unit_tests/translations/translations.t || true',
    ],
    translations_checkout_bricks_tanker => [
        sub {
            require JSON;
            my $cwd = `pwd`;
            chomp $cwd;
            open my $fh, '<:encoding(UTF-8)', './data3/package.json';
            my $package_json = do { local $/ = undef; <$fh> };
            close $fh;

            chdir './data3';

            yash_system('npm', 'ci');

            chdir $cwd;
        },
    ],
    translations_compile => 'compile_mo.pl -locale_path locale/ -project_id direct',
    translations_emails => '/usr/local/bin/update_emails.pl',
    translations_collect_phrases => [
        sub {
            require Config::General;
            my %conf = Config::General->new( -ConfigFile => './etc/translation.conf', -ForceArray => 1)->getall;
            system($conf{preprocess});
        },
        './protected/maintenance/xiget.pl | msgcat - --sort-output > locale/direct.pot',
        'svn revert ./data/block/i-translation/i-translation.tt2',
    ],
    translations_update_data3 => 'cd data3 && make tanker || true',
    internal_networks => './protected/prebuild/update_networks_file.pl data/t/prebuild/networks protected/data/networks',
    success_story_update => 'node ./data3/utils/success-stories/success-stories.js',
);


sub actions
{
    return \%ACTIONS;
}


