#! /bin/bash
#
# apache	Start the apache HTTP server.
#

NAME=soap.direct.yandex.ru
PATH=/bin:/usr/bin:/sbin:/usr/sbin
DAEMON=/usr/sbin/apache2
PIDFILE=[% IF dev %][% root %]/apache/run[% ELSE %]/var/run[% END %]/$NAME.pid
CONF=[% IF dev %][% root %]/apache/conf/$NAME.conf[% ELSE %]/etc/apache2/$NAME.conf[% END %]
APACHECTL=/usr/sbin/apache2ctl


trap "" 1
export LANG=C
export PATH
[% IF dev %]PERL5LIB=[% perl5lib %][% ELSE %]unset PERL5LIB[% END -%]

test -f $DAEMON || exit 0
test -f $APACHECTL || exit 0

# ensure we don't leak environment vars into apachectl
APACHECTL="env -i LANG=${LANG} PATH=${PATH} $APACHECTL"

[% IF !dev %]
#ulimit -u 1024
ulimit -u 4096  # https://st.yandex-team.ru/DIRECTADMIN-8661
ulimit -n 4096
ulimit -v 4000000
[% END %]

case "$1" in
  start)
    echo -n "Starting web server: $NAME"
    start-stop-daemon --start --pidfile $PIDFILE --exec $DAEMON -- -f $CONF
    ;;

  stop)
    echo -n "Stopping web server: $NAME"
    start-stop-daemon --stop --pidfile $PIDFILE --oknodo --exec $DAEMON
    ;;

  reload)
    echo -n "Reloading $NAME configuration"
    start-stop-daemon --stop --pidfile $PIDFILE --signal USR1 --exec $DAEMON
    ;;

  reload-modules)
    echo -n "Reloading $NAME modules"
    start-stop-daemon --stop --pidfile $PIDFILE --oknodo --retry 30
    start-stop-daemon --start --pidfile $PIDFILE --exec $DAEMON -- -f $CONF
    ;;

  restart)
    $0 reload-modules
    exit $?
    ;;

  force-reload)
    $0 reload-modules
    exit $?
    ;;

  *)
    echo "Usage: /etc/init.d/$NAME {start|stop|reload|reload-modules|force-reload|restart}"
    exit 1
    ;;
esac

if [ $? == 0 ]; then
	echo .
	exit 0
else
	echo failed
	exit 1
fi
