'use strict';

module.exports = function meta(data) {
    var cookies = data.COOKIES,
        scriptObject = data.SCRIPT_OBJECT;

    return {
        reqid: String(data.reqid || ('empty-' + Date.now())), // reqid должен быть строкой!
        cookie: cookies ?
            Object.keys(cookies)
                .map(function(key) { return key + '=' + cookies[key] })
                .join('; ') :
            '',
        host: scriptObject ? scriptObject.host : '',
        uri: data.current_url,
        httpMethod: data.HTTP_METHOD || 'GET',
        userId: data.UID,
        userTime: data.time ? parseInt(data.time, 10) * 1000 : 0,
        isInternalRequest: !!data.is_internal_ip
        // Те параметры, которые не смог получить из наших данных
        // userInterface,
        // userIp: reqdata.ruip,
        // httpXRealIp: reqdata.http_x_real_ip,
        // httpXForwardedFor: reqdata.http_x_forwarded_for,
        // userAgent: reqdata.ua,
        // referer: reqdata.http_referer,
        // isSuspectedRobot,
        // staticVersion
    };
};
