var fs = require('fs'),
    vm = require('vm'),
    path = require('path'),
    directBundleDir = path.join(__dirname, '../data3/desktop.bundles/direct/'),
    schemaPath = path.join(directBundleDir, 'direct.schema.js'),
    directTpl = vm.runInThisContext(fs.readFileSync(path.join(directBundleDir, '_direct.bemtree.xjst.js'))),
    headTpl = vm.runInThisContext(fs.readFileSync(path.join(__dirname, '../data3/desktop.bundles/head/_head.bemtree.xjst.js'))),
    touchTpl = vm.runInThisContext(fs.readFileSync(path.join(__dirname, '../data3/touch.bundles/direct/_direct.bemtree.xjst.js'))),
    schema;

try {
    schema = JSON.parse(fs.readFileSync(schemaPath));
} catch(e) {
    console.error(e);
    schema = {};
}

module.exports = {
    getMain: function() {
        return function(data) {
            var tplData = {
                data: data,
                funcs: {}
            };

            delete data.highlighter;

            data.json_schema = schema;

            switch (data.template_bundle) {
                case 'direct' : return directTpl(tplData);
                case 'direct_touch' : return touchTpl(tplData);
                case 'head' : return headTpl(tplData);
            }
        };
    }
};
