package RbacSimpleCache;

=head1 NAME

    RbacSimpleCache

=head1 DESCRIPTION

    Простой кеш для Rbac.pm
    Cache::SizeAwareMemoryCache - тормозит как не в себя ж-(

=cut

use Direct::Modern;

use Time::HiRes;

use Params::Validate qw/:all/;
use Storable qw/freeze thaw/;

=head2 my $cache = new RbacSimpleCache(ttl => $seconds, size => $elements)

    Параметры:
    ttl - время жизни ключа в секундах
    size - максимально число элементов в кеше (при превышении кеш обнуляется, во имя простоты и скорости)

=cut
sub new {
    my (undef, %O) = @_;
    %O = validate_with(params => [%O], spec => {
        ttl => {type => SCALAR, regex => qr/^\d+$/, optional => 1, default => 300,},
        size => {type => SCALAR, regex => qr/^\d+$/, optional => 1, default => 10_000,},
        });
    bless {
        %O,
        _data => {},
    };
}

=head2 $cache->set($key, $val)

    Записать в кеш значение.
    Значение записывается и возвращается как есть, о иммутабельности значения должен заботиться пользователь

=cut
sub set {
    my ($self, $key, $val) = @_;
    my $data = $self->{_data};
    if (scalar(keys %$data) >= $self->{size} && !exists $data->{$key}) {
        $self->clear();
    }
    $self->{_data}->{$key} = [Time::HiRes::time, $val];
}

=head2 $cache->get($key)

    Прочитать значение из кеша

=cut
sub get {
    my ($self, $key) = @_;
    my $data = $self->{_data};
    if (exists $data->{$key}) {
        my ($time, $val) = @{$data->{$key}};
        if ($time >= Time::HiRes::time - $self->{ttl}) {
            return $val;
        } else {
            delete $data->{$key};
        }
    }
    return undef;
}

=head2 $cache->clear()

    Очистить кеш

=cut
sub clear {
    my ($self) = @_;
    $self->{_data} = {};
}


1;
