#######################################################################
#
#  Direct.Yandex.ru
#
#  Settings
#
#  authors:
#    Maxim Kuzmin <kuzmin@yandex-team.ru>
#    Sergey Mudrik <msa@yandex-team.ru>
#    Sergey Zhuravlev <zhur@yandex-team.ru>
#
#  (c) 2004, 2005 Yandex
#
#######################################################################

=head1 NAME

    Settings - настройки проекта

=head1 DESCRIPTION

    Настроечный пакет определяет расположение проекта, сервера mysql и многое другое

    Если указана переменная окружения SETTINGS_LOCAL_SUFFIX, то после загрузки Settings
    из той же директории подргужается файл "Settings${SETTINGS_LOCAL_SUFFIX}.pm",
    который может переопределить настройки.
    Если переменная окружения не указана и существует файл SettingsLocal.pm - подгружается он.

=cut

package Settings;

use warnings;
use strict;

use constant;

use Carp qw();
use Cwd ();
use File::Basename ();

use Yandex::DBShards ();
use Yandex::Hostname;

# учим LWP ходить по IPv6, где бы он ни использовался (наш/чужой код, скрпиты/интерфейс, ...)
use Net::INET6Glue::INET_is_INET6;

use base 'Exporter';

our @EXPORT = qw(
        $ALLOW_LETTERS
        $ALLOW_BANNER_LETTER_RE
        $DISALLOW_BANNER_LETTER_RE
        $MAX_TITLE_LENGTH
        $NEW_MAX_TITLE_LENGTH
        $MAX_TITLE_LENGTH_CONTENT_PROMOTION
        $MAX_TITLE_EXTENSION_LENGTH
        $MAX_BODY_LENGTH
        $MAX_BODY_LENGTH_MOBILE
        $MAX_BODY_LENGTH_CONTENT_PROMOTION
        $MAX_URL_LENGTH
        $MAX_TITLE_UNINTERRUPTED_LENGTH
        $MAX_BODY_UNINTERRUPTED_LENGTH
        $MAX_NUMBER_OF_NARROW_CHARACTERS
        $NARROW_SYMBOLS_RE
);

use utf8;

our $CONFIGURATION = 'production';

# названия баз данных (для превращения в константы)
our @DB_NAMES = (
    # шардированная основная база с рекламными материалами
    "ppc:N",

    # база со словарными данными
    'ppcdict',
    # база Я.Каталога
    'ppcdict:catalog',

    # база для логов
    'ppclog', 'ppclog:heavy',

    # база для логов изменения цен
    'ppcpricelog', 'ppcpricelog:heavy',

    # база для внутренних мониторингов
    'monitor',

    # база фэйкового блэкбокса для песочницы
    'fakeblackbox',

    # база фэйкового баланса для песочницы
    'fakebalance',
);

# создание констант из DB_NAMES
{
no warnings 'redefine';
no strict 'refs';
sub register_db_names {
    for my $k (@DB_NAMES) {
        ### TODO dbname
        my $const_name = uc $k;
        $const_name =~ s/\W/_/g;
        next if $constant::declared{__PACKAGE__."::".$const_name};
        if ($k =~ /^(\w+:|)(\w+):(?:N|\d+)(:.*|$)/) {
            # ppc:N ppc:N:heavy production:ppc:2:heavy
            # шардированные базы рассматриваем отдельно
            my ($conf, $db, $mode) = ($1, $2, $3);
            $db = "$conf$db" if $conf;
            (my $group_const_name = uc "$db$mode") =~ s/\W/_/g;
            next if grep {$_ eq $group_const_name} @EXPORT;
            (my $suffix = $mode) =~ s/^://;
            push @EXPORT, $group_const_name;
            *{__PACKAGE__."::".$group_const_name} = sub {
                if ($db =~ /ppc$/ && !$Yandex::DBShards::STRICT_SHARD_DBNAMES && !@_) {
                    # если база указана как PPC (без параметров) и не включен режим строгости - считаем, что у нас есть только одни шард
                    return Yandex::DBShards::get_first_shard_dbname($db, $suffix);
                } else {
                    local $Carp::Verbose = 1;
                    return Yandex::DBShards::get_shard_dbnames($db, $suffix, @_);
                }
            };
        } else {
            push @EXPORT, $const_name;
            main::constant->import( $const_name => $k );
        }
    }
}
}
our $NO_REGISTER_DB_NAMES;
if (!$NO_REGISTER_DB_NAMES) {
    register_db_names();
}

# Базовая директория проекта
our $ROOT = Cwd::realpath(File::Basename::dirname($INC{'Settings.pm'})."/../../");
# Дирректория для мониторингов
our $MONITOR_ROOT = "$ROOT/protected/monitor";
our $LOCK_ROOT = "$ROOT/protected/run";
our $DATA_ROOT = '/opt/ppc-data';
our $TEMPDIR = '/tmpfs';
our $DICTIONARY_DIR = $ROOT . '/protected/data/wordlists';
our $JS_DIR = $ROOT . '/data/js';
our $JS_PERL_DIR = $JS_DIR . '/js-perl';
our $TT_INCLUDE_PATH = [map {"$ROOT/data/$_"} qw/t js block adv-blocks lego docs pages/];
# Директория фронтенда Гридов и пользовательских логов
our $DNA_ROOT = "/var/www/dna";

# Место, где лежит mirrors.res
our $MIRRORS_FILE = $ROOT . '/protected/logs/mirrors-data/mirrors.res.gz';
# временный файл для BDB-хеша для переработки зеркал (в tmpfs-разделе)
our $MIRRORS_FILE_BDB = '/run/shm/mirrors.res.btree';

# Домен, на котором нет cookies
our $NO_COOKIES_DOMAIN = "direct.yandex.net";

our $DIRECT_TRACE_HTTP_BASE_URL = 'https://direct-trace.common.yandex.net/';

# TODO перевести запросы на актуальную версию балансера DIRECT-122581
our $METRIKA_INT_API_READONLY_HOST = 'http://internalapi.metrika.yandex.ru:8096';
# Актуальная версия
our $METRIKA_INT_API_NEW_HOST = 'https://internalapi.metrika.yandex.ru';

our $METRIKA_TVM2_ID = "2000270";
our $METRIKA_AUDIENCE_TVM2_ID = "2000306";
# Сервера с переделанными ручками, что требуются для Я.Аудиторий (DIRECT-52766)
our $METRIKA_SUPPORT_AUDIENCE_HOST = 'http://audience-intapid.metrika.yandex.ru:8099';

# получение изменения количества счётчиков у пользователей
our $METRIKA_UPDATED_USER_COUNTERS_NUM_URL = "$METRIKA_INT_API_READONLY_HOST/direct/updated_user_counters_num";
# получение количества счётчиков у пользователей
# адрес ручки также захардкожен в MetrikaIntapi::get_users_counters_num, если меняется тут, то там нужно поменять тоже
our $METRIKA_USERS_COUNTERS_NUM_URL = "$METRIKA_INT_API_READONLY_HOST/direct/user_counters_num";

# запрос доступа к счетчикам метрики
our $METRIKA_GRANT_REQUESTS_URL = "$METRIKA_INT_API_NEW_HOST/internal/grant_requests";

# запрос доступа к счетчикам метрики в Коннекте
our $CONNECT_METRIKA_GRANT_REQUESTS_URL = 'https://api-internal.directory.ws.yandex.net/v1/subscription/services/metrika/licenses/request/';

our $PASSPORT_TVM2_ID = 2000078;

# TVM-тикет Коннекта
our $CONNECT_TVM2_ID = 2000205;

# Номер сервиса Zora в TVM
our $ZORA_TVM2_ID = 2000193;
our $GOZORA_TVM2_ID = 2023123;
{
    no warnings 'once';
    $LWP::UserAgent::Zora::ZORA_TVM2_ID = $ZORA_TVM2_ID;
}

# получение информации о целях
our $METRIKA_CHANGED_GOALS_NAMES_URL = "$METRIKA_INT_API_READONLY_HOST/direct/changed_goals";

our $METRIKA_API_URL = 'https://beta.api-metrika.yandex.ru';
our $METRIKA_API_TVM2_ID = "2000268";
# API отчётов v1 - получение табличных данных (http://api.yandex.ru/metrika/doc/beta/api_v1/data.xml)
our $METRIKA_STAT_API_TABLE_URL = "$METRIKA_API_URL/stat/v1/data";

# Ссылка на оплату Я.Деньгами.
our $MONEY_DIRECT_URL='https://money.yandex.ru/eshop.xml';

our $DIRECT_INTAPI_URL = 'http://ipv6.intapi.direct.yandex.ru/';
our $DIRECT_JAVA_INTAPI_URL = 'http://java-intapi.direct.yandex.net/';

our $DIRECT_INTAPI_TVM2_ID = '2000390';
our $TVMTOOL_TOKEN_FILE = '/etc/direct-tokens/tvmtool';

our $PASKILLS_TVM2_ID = '2000252';
our $PASKILLS_URL = 'https://paskills.voicetech.yandex.net/api/external/v2/skills/bulk/get';

our $GEOSEARCH_JAVA_INTAPI_URL = $DIRECT_INTAPI_URL . 'geosearch';

# переопредляются в RO-prod конфигруации, без этого используются обычные значения
our $DIRECT_READONLY_JAVA_INTAPI_URL;
our $TVM_READONLY_INTAPI_APP_ID;

our %TVM2_APP_ID = (
    scripts => '2000389',
    intapi => '2000390',
    web => '2000769',
    api => '2000773',
    canvas => '2012206',
);
our %TVM2_SECRET_PATH = (
    scripts => '/etc/direct-tokens/tvm2_direct-scripts',
    intapi => '/etc/direct-tokens/tvm2_direct-intapi',
    web => '/etc/direct-tokens/tvm2_direct-web',
    api => '/etc/direct-tokens/tvm2_direct-api',
    canvas => '/etc/direct-tokens/tvm2_direct-canvas',
);

# адрес песочницы
our $SANDBOX_SERVICE_URL = 'https://soap-sandbox-ipv6.direct.yandex.net/jsonrpc/SandboxService';
our $SANDBOX_INTAPI_TVM2_ID = '2000920';

# secret-phrase для подписи
# получено как head -c 100 /dev/random|md5sum
our $SECRET_PHRASE = '29acb93af5a72e31a2e55c0d41913b6f';

{
    no warnings 'once';
    $BS::Export::LOGBROKER_LOG_LEVEL = 6;
}

our $BS_EXPORT_PROXY = 'http://bssoap.yandex.ru/';
our $BS_EXPORT_PROXY_READONLY = $BS_EXPORT_PROXY;
###### Хосты, используемые в BS::URL для разных ручек
our $BS_HOST_FAST = 'bsfastexport.yandex.ru';
our $BS_HOST_FAST_PRE = 'bsfastexport-pre.yandex.ru';
our $BS_HOST_EXPORT = 'bssoap.yandex.ru';
our $BS_HOST_EXPORT_PRE = undef;
our $BS_HOST_ID_GENERATOR = 'yabs-id-generator.yabs.yandex.ru';
# хосты для экспорта от нас в БК
our $BS_HOST_IMPORT = 'bssoap.yandex.ru';
our $BS_HOST_IMPORT_PRE = 'bssoap-pre.yandex.ru';
# для непродакшена
our $BS_HOST_FAKE;
#########
our $YABS_ID_GENERATOR_TVM2_ID = 2018015;

# Урлы для получения данных о торгах:
# основные торги
our $BSRANK_BASE_URL = 'http://bsrank.yandex.ru';
our $BSRANK_URL = "$BSRANK_BASE_URL/rank/24";

# даже если обращаться будем к каким-нибудь тестовым торгам -- в запросе надо указать заголовок Host:
our $BSRANK_HOST = 'bsrank.yandex.ru';
# таймаут для bsrank
our $BS_TIMEOUT = 60;
our $BS_NUM_ATTEMPTS = 3;
our $BS_SOFT_TIMEOUT = 1.5;
# всего делаем ретраи не более чем на 50% запросов
our $BS_TOTAL_TRIES_COEF = 0.5;

# степень параллелизации при вызовах торгов
our $BS_RANK_PARALLEL_LEVEL = 10;

# Быстрые статусы фраз из торгов
our $BSRANK_PHRASE_STATUSES = "http://bsrank.yandex.ru/ppstate/";
# Значение ранка по умолчанию, подставляемое в быстром импорте статусов фраз во фразы не отключенные на поиске.
our $DEFAULT_RANK = 10_000;

# ручка, используемая для поиска объявлений конкурентов и полнотекстового по фразам
our $BS_COMPETITORS_SEARCH_URL = 'http://bsrank.yandex.ru/rank/23';
# ручка, используемая для полнотекстового поиска по баннерам
our $BS_FULLTEXT_SEARCH_URL = 'http://bsrank.yandex.ru/bansearch';
# таймаут для полнотекстового поиска
our $BS_FULLTEXT_SEARCH_TIMEOUT = 60;

# имя property, куда записано время обновления 28-дневной статистики
our $BS_RANKSTAT_TIME_PROP = 'bs_rankstat_time';

# имя проперти с длительностью видеоподложек. В БК ролик будет обрезаться до этой длительности.
our $BS_VIDEO_AD_DURATION_LIMIT_PROP = 'bs_video_ad_duration_limit';

# имя property, куда записан денежный порог для создания автоматических заявок на ПП.
our $FIRST_AID_PAID_SUM_LIMIT_PROP    = 'first_aid_paid_sum_limit';
our $FIRST_AID_PAID_SUM_LIMIT_DEFAULT = 35;
# как давно должны были быть утверждены ПП, чтобы можнобыло создать заявку на ВП.
our $SECOND_AID_INTERVAL_FROM_FIRST_AID = [90, 91];

# количество попыток обновить данные про мобильный контент джобой UpdateStoreContentJob
our $MOBILE_APPLICATION_TRIES_LIMIT = 100;

our $DISABLE_MODERATION_NOTIFICATIONS_PROP = 'disable_moderation_notifications';

# использовать TVM в blackbox
{
    no warnings 'once';
    $Yandex::Blackbox::BLACKBOX_USE_TVM_CHECKER = sub { return 1;};
}

# from email for notifications
# когда будут массовые изменения по поводу уведомлений,
# это стоит переделать и передавать в send_prepared_mail параметр $from как хэш,
# в котором поле email уже будет иметь адрес, выбранный в зависимости от языка
our $NOTIFICATION_EMAIL_FROM = 'DEFAULT_FROM_FIELD_DEPENDING_ON_LANG';
our $DEFAULT_FROM_FIELD_DEPENDING_ON_LANG = {
    ru => 'direct_noreply@yandex-team.ru',
    en => 'direct_noreply@yandex-team.com',
    ua => 'direct_noreply@yandex-team.com.ua',
    tr => 'direct_noreply@yandex-team.com.tr',
};

our $YA_AGENCY_NOTIFICATION_EMAIL_TO = 'nadiano@yandex-team.ru, stitov@yandex-team.ru, client-service@yandex-team.ru';

our $SPECIFY_PRICES_LOCK_NAME = 'SPECIFY_PRICES';

# Дирректория для логов
our $LOG_ROOT = "$ROOT/protected/logs";

our $DOSTUP_MAIL = 'dostup@yandex-team.ru';

our $INFOBLOCK_MESSAGES_URL = '/public?cmd=ajaxInfoblockRequest';
our $INFOBLOCK_NEWS_URL = '/public?cmd=ajaxGetNewsById';
our $INFOBLOCK_URL = "${DIRECT_INTAPI_URL}infoblock/";
our $INFOBLOCK_TEASERS_URL = 'https://yabs.yandex.ru/page/236547';

# uid-ы superreader+is_developer, которые могут менять менять непродуктовые настройки, влияющие
# на работу продакшена (таймауты и прочее)
our %DEVOPS_LOGINS = (
    'yndx-yukaba-superreader'  => 1,
    'yndx-gerdler-superreader' => 1,
    'yndx-pe4kin' => 1,
    'yndx-pema4-superreader' => 1,
    'yndx-darkkeks-superreader' => 1,
    'yndx-ppalex-superreader' => 1,
    'yndx-kuhtich-superreader' => 1,
    );

# property, где записано, какие операции сервисов API5 проксировать в java
# там должно быть записано сервис.операция через пробел
# например: "bids.get bids.set"
our $API5_JAVA_PROXY_SERVICE_OPERATIONS_PROP = "API5_JAVA_PROXY_SERVICE_OPERATIONS";

# как часто эту property надо проверять в базе
our $API5_JAVA_PROXY_SERVICE_OPERATIONS_PROP_CACHE_TTL = 10;

# какие операции в принципе можно проксировать с java; если
# операция есть в property, но её нет в этом списке, она не прокинется
our %API5_JAVA_ALLOW_PROXYING_OPERATION = map { $_ => 1 } qw(
    campaigns.add
    campaigns.archive
    campaigns.delete
    campaigns.get
    campaigns.resume
    campaigns.suspend
    campaigns.unarchive
    campaigns.update
    campaignsext.add
    campaignsext.archive
    campaignsext.delete
    campaignsext.get
    campaignsext.resume
    campaignsext.suspend
    campaignsext.unarchive
    campaignsext.update
    changes.check
    changes.checkCampaigns
    changes.checkDictionaries
);

# property, где хранится количество баллов API5, после которого клиент считается приоритетным
our $PRIORITY_CLIENTS_API5_UNITS_THRESHOLD_PROPERTY_NAME = 'PriorityClientsUnitsThreshold';

# количество дневного лимита баллов API5 по умолчанию для приоритетных клиентов (по нему отбираем % пользователей для выгрузки)
our $PRIORITY_CLIENTS_API5_UNITS_DEFAULT_THRESHOLD = 3400000;

{
    no warnings 'once';

    # директория для логов
    $Yandex::Log::LOG_ROOT = $LOG_ROOT;
    $Yandex::Log::LOG_UMASK = 002;
    # отправлять ли с текущей машины данные в syslog
    my @syslog_clients = (qw/ppcdev1.yandex.ru ppcscripts01h.yandex.ru limtest2-direct.yandex.ru/, map {"ci0${_}e.yandex.ru"} (1 .. 4));
    $Yandex::Log::USE_SYSLOG = {map {$_ => 1} @syslog_clients}->{Yandex::Hostname::hostfqdn()};
    $Yandex::Log::SYSLOG_PREFIX = 'direct-'.$CONFIGURATION;

    # '' - отсылаем письма нормально
    # 'file: XXX' - пишем письма в файл
    # 'mailto: a@b.c' - все письма шлём на определённый адрес
    $Yandex::SendMail::FAKEMAIL = '';
    $Yandex::SendSMS::FAKESMS = undef;

    $Yandex::SendMail::YSERVICE_SALT = '76336c7a96b13f0258054d239e70fec8';
    $Yandex::SendMail::YSERVICE_NAME = 'yadirect';
    $Yandex::SendMail::FROM_FIELDS_FOR_ALERTS = '"Yandex.PPC" <ppc-admin@yandex-team.ru>';
    $Yandex::SendMail::MAIL_FOR_ALERTS = 'ppc-admin@yandex-team.ru';
    $Yandex::SendMail::SUBJ_FOR_ALERTS = 'PPC:error';
    $Yandex::SendMail::ENVELOPE_SENDER = 'direct_noreply@yandex-team.ru';

    # Лог для контролируемой рассылки алертов
    $Yandex::SendMail::SEND_ALERT_LOG = "$LOG_ROOT/sendAlert.log";

    # Метка для запросов из Директа для проверки орфографии
    $Yandex::Speller::SRV = 'yadirect';

    $Yandex::OAuth::OAUTH_URL = "https://oauth.yandex.ru/";
    $Yandex::OAuth::TIMEOUTS = (1, 1);

    $Template::Plugin::DocsL10n::DOC_ROOT = "$ROOT/data/docs";

    # Значение поля from в запросе на создание логина
    $Yandex::Passport::SERVICE_NAME_IN_PASSPORT = 'slova';

    $Yandex::Balance::BALANCE_FAILS_MAIL = 'ppc-admin-fails@yandex-team.ru';
    $Yandex::Balance::BALANCE_XMLRPC = 'http://balance-xmlrpc.yandex.net:8002/xmlrpc';
    $Yandex::Balance::Simple::BALANCE_SIMPLE_XMLRPC = 'https://balance-simpleapi.yandex.ru:8023/simpleapi/xmlrpc';
    $Yandex::Balance::Simple::DIRECT_SERVICE_TOKEN = 'PPC_d5bc1fbe74a173f4688d24fc6bf8399a';

    $Yandex::YaMoney::YAMONEY_API_URL = "https://money.yandex.ru/api/";

    # Path to the folder with email templates
    $Yandex::MailTemplate::EMAIL_TEMPLATES_FOLDER = $ROOT . "/data/t/emails";

    # файл с md5 от всех шаблонов писем для отслеживания изменения писем
    $Yandex::MailTemplate::MD5_OF_EMAILS_FILENAME = "$DATA_ROOT/md5_of_emails";

    # Массив возможных дополнительных (кроме description и subject) атрибутов шаблонов писем
    $Yandex::MailTemplate::EMAIL_TEMPLATE_ADDITIONAL_PROPERTIES = [{name => 'no_reps_sms', desc => 'не посылать SMS представителям', type => 'checkbox'}, {name => 'fio_var_name', desc => 'имя переменной для ФИО для копии письма представителям', type => 'text'}];

    # Авторизация в Доставляторе
    $Yandex::Subscriptions::AUTHORIZATION_STR = 'X-Key JF92YiozJTFiYWg0MCt6NDZrYShxIV5w';

    $MetrikaIntapi::METRIKA_INTAPI_URL = $METRIKA_INT_API_READONLY_HOST;
    $MetrikaIntapi::METRIKA_TVM2_ID = $METRIKA_TVM2_ID;

    # Апи Яндекс.Аудитории
    $Yandex::Audience::AUDIENCE_API_URL = 'https://api-audience.yandex.ru';
    $Yandex::Audience::AUDIENCE_API_TOKEN_FILE = '/etc/direct-tokens/audience_yndx-robot-direct-aud';

    $Yandex::DBQueue::Typemap::SOURCE_FILE_PATH = "$ROOT/etc/dbqueue-types.yaml";

    %Direct::ResponseHelper::CSP_HEADERS_FILE = (
        data => "$ROOT/data/csp_headers.yml",
        data3 => "$ROOT/data3/csp_headers.yml",
    );

    %Direct::ResponseHelper::CSP_HEADER_PLACEHOLDER = (
        canvas_tld => 'canvas',
        turbo_ui_tld => 'ad-constructor',
        bannerstorage_domain => 'rest-api.bannerstorage.yandex.net',
        card_bind_form_domain => 'trust.yandex.ru',
        no_cookies_domain => $NO_COOKIES_DOMAIN,
        sprav_tld => '',
        # интерфейс CDP в Яндекс.Метрике. Пустая строка, так как домен не имеет префикса в проде
        cdp_tld => '',
        # в проде brandlift живет под другим CSP-правилом ("surveys.#yandex_domain#")
        # но чтобы не было ошибки CSP в консоли напишем здесь never, чтобы не нарушать синтаксис CSP-заголовка
        pythia_tld => 'never',
        csp_header_name => 'Content-Security-Policy',
    );
}

# Выгрузки Адресов
our $BACKA_EXPORT_URL = 'http://export.backa.yandex.ru/backa-export';

# hostname для API
our $API_SERVER_PATH = 'soap.direct.yandex.ru';
our $API_WSDL_PATH = 'soap.direct.yandex.ru';
our $API_SERVER_PATH_TEST = 'api.test.direct.yandex.ru:14443';
our $API_SERVER_PATH_SANDBOX = 'api-sandbox.direct.yandex.ru';

# максимальное количество одновременных заапросов к API от клиента
our $API_PARALLEL_QUERIES = 10;
our $API_LOCKS_DIR = "$DATA_ROOT/soap-locks";

# Директория для отчетов для API
our $REPORT_PATH = "$DATA_ROOT/soap-files/";

# период (в днях) за который используется статистика при расчёте баллов АПИ
our $API_UNITS_CALC_PERIOD = 28;

# максимальное количество фраз в запросе к ADVQ
our $API_MAX_KEYWORDS_PER_ADVQ_QUERY = 10;

# максимальное количество фраз в запросах к ADVQ за день
our $DEFAULT_WORDSTAT_DAILY_LIMIT = 1000;

# максимальное количество неудач при попытке выполнить финансовую операцию, перед отключением доступа
our $API_MAX_FIN_OPS_FAULTS = 10;

# максимальное количество групп в запросах на массовое обновление: удаление, отправка в БК, перемодерация...
# это константа так же хранится в java (ValidationConstantsUtil.MAX_AD_GROUPS_COUNT_PER_UPDATE) и отдается на фронт через graphQL запрос.
# Пожалуйста, если правите тут, то поправьте и там)
our $MAX_AD_GROUPS_PER_UPDATE_REQUEST = 1000;

# SSL-ные сертификаты, пути, ...
our $CA_CONFIG = "/etc/ssl/soapCA/openssl.cnf";
# какие файлы нужно дополнительно прикладывать к архиву с сертификатом
our @CA_ADD_FILES = ('/etc/ssl/soapCA/cacert.pem');

# Путь к stop-файлу. Если он есть - показываем страницу "Интерфейс временно не доступен"
our $WEB_STOP_FLAG = "$ROOT/protected/run/web_stop.flag";
our $CMD_STOP_FLAG = "$ROOT/protected/run/cmd_stop.flag";

# умолчательное ограничение на количество одновременных запросов в веб интерфейс
our $DEFAULT_WEB_PARALLEL_LIMIT = [ {Key => ['UID', 'FORM'], Num => 7} ];

#IP-адреса, которые не разрешается блокировать пользователю Директа
our $UNBLOCKABLE_IPS = "$ROOT/protected/unblockable_ips.txt";

#internal networks
our $NETWORKS_DIR = "$ROOT/protected/data/networks";
our $INTERNAL_NETWORKS = "$NETWORKS_DIR/internal.txt";
our $PRIVATE_NETWORKS = "$NETWORKS_DIR/private.txt";

# метка openStat
our $OPENSTAT_LABEL = 'dGVzdDsxOzE7';

# max phrase length
our $MAX_PHRASE_LENGTH = 4096;

# максимальная длина заголовка, тела объявления, урла
our $MAX_TITLE_LENGTH = 35;
our $NEW_MAX_TITLE_LENGTH = 56;
our $MAX_TITLE_LENGTH_CONTENT_PROMOTION = 200;
our $MAX_TITLE_EXTENSION_LENGTH = 30;
our $MAX_BODY_LENGTH = 81;
our $MAX_BODY_LENGTH_MOBILE = 75;
our $MAX_BODY_LENGTH_CONTENT_PROMOTION = 200;
our $MAX_URL_LENGTH = 1024;

our $MAX_DOMAIN_LENGTH = 35;

# максимальные длины непрерывных строк в заголовке и теле объявления
our $MAX_TITLE_UNINTERRUPTED_LENGTH = 22;
our $MAX_BODY_UNINTERRUPTED_LENGTH = 23;

# максимальное количество узких символов в заголовке и теле объявления
our $MAX_NUMBER_OF_NARROW_CHARACTERS = 15;

# default region for easy banners
our $DEFAULT_EASY_GEO = '225,166';

# коэффициент для показов/кликов/открутки в рабочий день относительно недели (типичное значение из Автобюджета 2.0)
our $WEEKDAY_FACTOR = 0.17;

# При добавлении агентством логина, зарегистрированного позднее указанного числа дней, требовать подтверждения от клиента
our $MAX_LOGIN_AGE_DAYS = 5;

# Масимальная дата, конец эпохи
our $END_OF_TIME = '2038-01-19';
our $EXPIRES_NEVER = 'Tue, 19 Jan 2038 07:14:07 GMT';

# алфавиты различные
our $LAT_LETTERS = qq!abcdefghijklmonpqrstuvwxyzABCDEFGHIJKLMONPQRSTUVWXYZ!;
our $RUS_LETTERS = qq!абвгдеёжзийклмнопрстуфхцчшщъыьэюяАБВГДЕЁЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯ!;
our $KAZ_LETTERS = qq!\x{4B0}\x{492}\x{493}\x{4E8}\x{4A2}\x{49A}\x{4BA}\x{4AE}\x{4B1}\x{4E9}\x{4A3}\x{49B}\x{4BB}\x{4AF}!
                  .qq!\x{496}\x{4B2}\x{4B3}\x{497}\x{4D8}\x{4D9}!; # ҰҒғӨҢҚҺҮұөңқһүҖҲҳҗӘә
our $UKR_NATIVE_LETTERS = qq!\x{404}\x{407}\x{454}\x{457}\x{490}\x{491}!; # ЄЇєїҐґ
our $UKR_LETTERS = qq!${UKR_NATIVE_LETTERS}'!;
our $BEL_NATIVE_LETTERS = qq!\x{40E}\x{45E}!; # Ўў
our $BEL_LETTERS = qq!${BEL_NATIVE_LETTERS}'!;

# общие символы украинского и белорусского алфавитов
our $COMMON_UKR_BEL_LETTERS = qq!\x{406}\x{456}!; # Іі <- кириллические і

# Уникальные символы турецкого алфавита, не входящие в немецкий и другие описанные допустимые языки
# ğĞşŞçÇıİ̇âÂîÎûÛé
our $UNIQUE_TR_LETTERS = "\x{11F}\x{11E}\x{015F}\x{15E}\x{E7}\x{C7}\x{131}\x{130}\x{307}\x{E2}\x{C2}\x{EE}\x{CE}\x{FB}\x{DB}\x{E9}";
# Уникальные символы немецкого алфавита, не входящие в турецкий и другие описанные допустимые языки
# Ääßẞ
our $UNIQUE_DE_LETTERS = "\x{C4}\x{E4}\x{DF}\x{1E9E}";
# Общие символы турецкого и немецких алфавитов
# üÜöÖ
our $GENERAL_TR_DE_LETTERS = "\x{FC}\x{DC}\x{F6}\x{D6}";
# Общие символы для узбекского языка
# ʼ
our $GENERAL_UZ_LETTERS = "\x{2BC}";
# Уникальные символы латинской версии узбекского языка
# ʻ
our $UNIQUE_UZ_LATIN_LETTERS = "\x{2BB}";
# Уникальные символы кириллической версии узбекского языка
# Ҳҳ
our $UNIQUE_UZ_CYRILLIC_LETTERS = "\x{4B2}\x{4B3}";
# Уникальные символы вьетнамского алфавита
# ÁáÀàẢảÃãẠạĂăẮắẰằẲẳẴẵẶặẤấẦầẨẩẪẫẬậĐđÉÈèẺẻẼẽẸẹÊêẾếỀềỂểỄễỆệÍíÌìỈỉĨĩỊịÓóÒòỎỏÕõỌọÔôỐốỒồỔổỖỗỘộƠơỚớỜờỞởỠỡỢợÚúÙùỦủŨũỤụƯưỨứỪừỬửỮữỰựÝýỲỳỶỷỸỹỴỵ
our $UNIQUE_VIE_LETTERS = "\x{C1}\x{E1}\x{C0}\x{E0}\x{1EA2}\x{1EA3}\x{C3}\x{E3}\x{1EA0}\x{1EA1}\x{102}\x{103}\x{1EAE}\x{1EAF}\x{1EB0}"
    ."\x{1EB1}\x{1EB2}\x{1EB3}\x{1EB4}\x{1EB5}\x{1EB6}\x{1EB7}\x{1EA4}\x{1EA5}\x{1EA6}\x{1EA7}\x{1EA8}\x{1EA9}\x{1EAA}\x{1EAB}\x{1EAC}"
    ."\x{1EAD}\x{110}\x{111}\x{C9}\x{C8}\x{E8}\x{1EBA}\x{1EBB}\x{1EBC}\x{1EBD}\x{1EB8}\x{1EB9}\x{CA}\x{EA}\x{1EBE}\x{1EBF}\x{1EC0}"
    ."\x{1EC1}\x{1EC2}\x{1EC3}\x{1EC4}\x{1EC5}\x{1EC6}\x{1EC7}\x{CD}\x{ED}\x{CC}\x{EC}\x{1EC8}\x{1EC9}\x{128}\x{129}\x{1ECA}\x{1ECB}"
    ."\x{D3}\x{F3}\x{D2}\x{F2}\x{1ECE}\x{1ECF}\x{D5}\x{F5}\x{1ECC}\x{1ECD}\x{D4}\x{F4}\x{1ED0}\x{1ED1}\x{1ED2}\x{1ED3}\x{1ED4}\x{1ED5}"
    ."\x{1ED6}\x{1ED7}\x{1ED8}\x{1ED9}\x{1A0}\x{1A1}\x{1EDA}\x{1EDB}\x{1EDC}\x{1EDD}\x{1EDE}\x{1EDF}\x{1EE0}\x{1EE1}\x{1EE2}\x{1EE3}"
    ."\x{DA}\x{FA}\x{D9}\x{F9}\x{1EE6}\x{1EE7}\x{168}\x{169}\x{1EE4}\x{1EE5}\x{1AF}\x{1B0}\x{1EE8}\x{1EE9}\x{1EEA}\x{1EEB}\x{1EEC}"
    ."\x{1EED}\x{1EEE}\x{1EEF}\x{1EF0}\x{1EF1}\x{DD}\x{FD}\x{1EF2}\x{1EF3}\x{1EF6}\x{1EF7}\x{1EF8}\x{1EF9}\x{1EF4}\x{1EF5}";

# Прочие буквы европейских алфавитов. В идеале нужна юникодная регулярка на просто все буквы. Часть букв неуникальна.
# áéíñóúÁÉÍÑÓÚ — испанский алфавит
our $EXTRA_SPANISH_LETTERS = "\x{e1}\x{e9}\x{ed}\x{f1}\x{f3}\x{fa}\x{c1}\x{c9}\x{cd}\x{d1}\x{d3}\x{da}";
# áàâãéèêíïóôõöúçñÁÀÂÃÉÈÊÍÏÓÔÕÖÚÇÑ — португальский
our $EXTRA_PORTUGUESE_LETTERS = "\x{e1}\x{e0}\x{e2}\x{e3}\x{e9}\x{e8}\x{ea}\x{ed}\x{ef}\x{f3}\x{f4}\x{f5}\x{f6}\x{fa}\x{e7}\x{f1}\x{c1}"
    ."\x{c0}\x{c2}\x{c3}\x{c9}\x{c8}\x{ca}\x{cd}\x{cf}\x{d3}\x{d4}\x{d5}\x{d6}\x{da}\x{c7}\x{d1}";
# áčďéěíňóřšťúůýžÁČĎÉĚÍŇÓŘŠŤÚŮÝŽ — чешский
our $EXTRA_CZECH_LETTERS = "\x{e1}\x{10d}\x{10f}\x{e9}\x{11b}\x{ed}\x{148}\x{f3}\x{159}\x{161}\x{165}\x{fa}\x{16f}\x{fd}\x{17e}\x{c1}"
    ."\x{10c}\x{10e}\x{c9}\x{11a}\x{cd}\x{147}\x{d3}\x{158}\x{160}\x{164}\x{da}\x{16e}\x{dd}\x{17d}";
# ąćęłńóśźżĄĆĘŁŃÓŚŹŻ — польский
our $EXTRA_POLISH_LETTERS = "\x{105}\x{107}\x{119}\x{142}\x{144}\x{f3}\x{15b}\x{17a}\x{17c}\x{104}\x{106}\x{118}\x{141}\x{143}\x{d3}\x{15a}\x{179}\x{17b}";
our $EXTRA_EUROPEAN_LETTERS = $EXTRA_SPANISH_LETTERS . $EXTRA_PORTUGUESE_LETTERS . $EXTRA_CZECH_LETTERS . $EXTRA_POLISH_LETTERS;

our $NON_LAT_ALPHABET_LETTERS = "${RUS_LETTERS}${UKR_LETTERS}${BEL_LETTERS}${COMMON_UKR_BEL_LETTERS}${KAZ_LETTERS}${UNIQUE_DE_LETTERS}${UNIQUE_TR_LETTERS}${GENERAL_TR_DE_LETTERS}${UNIQUE_UZ_LATIN_LETTERS}${UNIQUE_UZ_CYRILLIC_LETTERS}${GENERAL_UZ_LETTERS}${UNIQUE_VIE_LETTERS}${EXTRA_EUROPEAN_LETTERS}";
our $ALLOWED_ALPHABET_LETTERS = "${LAT_LETTERS}${NON_LAT_ALPHABET_LETTERS}";
our $ALLOW_LETTERS = qq!${ALLOWED_ALPHABET_LETTERS}\\[\\]0123456789.!;
our $ALLOW_MINUS_PHRASE_LETTERS = qq!${ALLOW_LETTERS}\\-\\[\\]\\"!;
our $ALLOW_MINUS_WORD_LETTERS = qq!${ALLOWED_ALPHABET_LETTERS}0123456789.!;
# \x{00a0} -- неразрывный пробел
my $banner_special_chars = qq!™®©’°⁰¹²³⁴⁵⁶⁷⁸⁹\x{20bd}!;
our $ALLOW_BANNER_LETTERS_STR = qq/$ALLOW_LETTERS-+,. "¡!¿?\\()%\$€;:\/&'*_=#№«»\x{00a0}–—−$banner_special_chars/;
# TODO везде, где делается lc($str) =~ $DISALLOW_BANNER_LETTER_RE; надо убрать lc. EXP 2013-10-10
our $ALLOW_BANNER_LETTER_RE = qr/[\Q$ALLOW_BANNER_LETTERS_STR\E]/i;
our $DISALLOW_BANNER_LETTER_RE = qr/[^\Q$ALLOW_BANNER_LETTERS_STR\E]/i;
our $NARROW_SYMBOLS_STR = qq/.,!:;"/;
our $NARROW_SYMBOLS_RE = qr/[\Q$NARROW_SYMBOLS_STR\E]/;

my $camp_special_chars = qq!™®©’°⁰¹²³⁴⁵⁶⁷⁸⁹\x{20bd}!;
our $ALLOW_CAMP_LETTERS_STR = qq/$ALLOW_LETTERS-+,. "¡!¿?\\()%\$€;:\/&'*_=#№«»\x{00a0}–—−$camp_special_chars/;
our $ALLOW_CAMP_LETTER_RE = qr/[\Q$ALLOW_CAMP_LETTERS_STR\E]/i;
our $DISALLOW_CAMP_LETTER_RE = qr/[^\Q$ALLOW_CAMP_LETTERS_STR\E]/i;

# размер, при достижении которого чайлд апача будет умирать
# проверяется после выполнения каждого запроса
our $APACHE_MAX_PROC_SIZE = 1 * 1024 * 1024 * 1024;
our $SOAP_APACHE_MAX_PROC_SIZE = 800 * 1024 * 1024;
# лимит времени на вызов веб-интерфейса, контроллеры должны сами об этом заботиться
our $WEB_MAX_REQ_TIME = 500;

our $DEF_WARN_PLACE_INTERVAL = 60;
our @DEF_WARN_PLACE_INTERVAL_VALUES = (15, 30, 60);

# максимальный размер пакета слов для МКБ
our $MAX_MCB_PACKET_SIZE = 16 * 1024;

our $MAX_MEDIA_BANNER_COUNT = 50;
our $MIN_MONTH_MEDIA_SHOWS = 750_000;
our $MIN_MONTH_MEDIA_SHOWS_FOR_TURKEY = 10_000;

our $DEFAULT_RF = 3;
our $DEFAULT_RF_RESET = 28;

our $CAMPAIGN_MINUS_WORDS_LIMIT = 20000;
our $GROUP_MINUS_WORDS_LIMIT = 4096;
# max phrase length
our $MAX_MINUS_WORDS_LENGTH = 4096;
# максимальное количество слов в минус-фразе
our $MAX_WORDS_IN_MINUSPHRASE = 7;

# значение устаревает с 1 января 2019 и не должно содержательно использоваться
our $NDS_RU_DEPRECATED = 0.18;
our $NDS_UA = 0.20;

our $IMAGE_HOST = '//ba.yandex.net/files';
our $IMAGE_HOST_FOR_INTERNAL_USAGE = 'http://ba.yandex.net/files';

# показ предупреждений по фразам
our $MIN_PHRASE_RANK_WARNING = 2;
our $MAX_PHRASE_RANK_WARNING = 7000;

our $BAD_PAGE_CTR = 0.1;    # 0.1 % == 0.001
our $BAD_PAGE_MIN_SHOWS = 1000;

our $MAX_XLS_SIZE = 32*1024*1024;
our $MAX_COMPRESSED_XLS_SIZE = 4*1024*1024;

# сколько храним загруженные и выгруженные xls-файлы
our $XLS_EXPIRES_DAYS = 90;

# максимальное кол-во объявлений в кампании для "Первой помощи"
our $MAX_COUNT_BANNERS_FIRST_AID = 5;
# максимальное кол-во кампаний для "Первой помощи"
our $MAX_COUNT_CAMPS_FIRST_AID = 2;
# количество дней на которые скрываем первую помощь при клике клиента на "Посмотреть позже"
our $AID_POSTPONE_DAYS = 3;

 # Дефолтное количество баннеров на одной странице кампании
our $DEFAULT_BANNERS_ON_PAGE = 30;
# Дефолтное количество групп на одной странице кампании
our $DEFAULT_GROUPS_ON_PAGE = 30;

# сколько секунд после остановки кампании, с неё нельзя переносить средства
our $TRANSFER_DELAY_AFTER_STOP = 30 * 60;

# максимальная длина описания на кампании
our $MAX_CAMPAIGN_DESCRIPTION_LENGTH = 4096;

# максимальное количество условий ретаргетинга на клиента
our $MAX_RETARGETINGS_ON_CLIENT = 2000;
# максимальное количество групп в условии ретаргетинга
our $MAX_RETARGETING_GROUPS = 50;
# максимальное количество целей в группе условия ретаргетинга
our $MAX_RETARGETING_GOALS_IN_GROUP = 250;
# максимальное время достижения цели для ретаргетинга
our $MAX_RETARGETING_GOAL_TIME_DAYS = 90;
# по умолчанию подставляем цену для условий для охвата 80%
our $DEFAULT_COVERAGE_FOR_RETARGETING = 80;
# максимальное количество баннеров, которые можно открыть на редактирование.
our $MAX_OPEN_FOR_EDIT_BANNERS = 500;

# ключи для доступа к Я.Картам
# зависят от домена, универсального ключа не бывает
# DIRECT-16681
# в интерфейсе не используются, т.к. в JavaScript API карт 2.0 ключ стал необязательным
# но продолжает использоваться в запросах к геокодеру
our %MKEYS = (

    'direct.yandex.com' => 'ACiRxE8BAAAADhm5fAMA5pkODuDOZXmuL5N3Szqdgj6Wx7kAAAAAAAAAAABUYx_k4Jrh1ib8rcUyP2zdSEYW2g==',
    'direct.yandex.ua' => 'ADCSxE8BAAAA9XpwSgMAHBN6BHhzya3TUZ0uERLHH_J_fZkAAAAAAAAAAAB-KVTjhC3poresy24NmOr0-WksKQ==',
    'direct.yandex.ru' => 'AEeSxE8BAAAAbg7UaQMATRT2fxZ0mOP1aH-8crickCS2PlAAAAAAAAAAAADD15lajD6u0DO1QO1Iy7UIIh0GTA==',
    'direct.yandex.by' => 'AGCSxE8BAAAAGC_XZAMAH1m1aWas5AT0CAtNczm3GfB25BQAAAAAAAAAAADH80bZZpmy16o7OSmIA2OLQ_992A==',
    'direct.yandex.kz' => 'AHaSxE8BAAAAh4YFVgMAbyZmE6T5EMYfraKFKbEYbaVsYI8AAAAAAAAAAABqe51WhQFTHxJww4iDQpTt9BGW6A==',
    'direct.yandex.com.tr' => 'AIuSxE8BAAAAwsncWAQA8JHSuismXNPNiM9asiaMOBiWTQcAAAAAAAAAAAAcOz1UUxQEcLdQ6FxXaLYEz4gwzQ==',

    'test-direct.yandex.ru' => 'AKSSxE8BAAAARaqxFAMAQadBocxjpOf54vye3Vda5MUDo0AAAAAAAAAAAADcWXOUWt9UK1hwr4xNeJP3Gj_CFA==',
    'test-direct.yandex.ua' => 'ALmSxE8BAAAAg3yXFwMAEMfEhnnVLIWNr7bbHbnW2WX5CE8AAAAAAAAAAADOZuyB7I7gw-lRZ_iP0VS2gX-3eg==',
    'test-direct.yandex.by' => 'AM6SxE8BAAAA4wQVGwMAo-JVniUosAB92tHO5q-FHjfc-jMAAAAAAAAAAAAGdudpf5kpZKxc1JuGHD3jOV-jZw==',
    'test-direct.yandex.com' => 'AOOSxE8BAAAATn6rHgMA2BvqnkMSt76Igzw2w2JjwtwWpdAAAAAAAAAAAACAWCNlb9NFjBntlgMNMrLDIV9QRw==',
    'test-direct.yandex.kz' => 'APmSxE8BAAAAKWvlDgMAQeC0pgY_tZ3q5Dg4odVUZEDinRoAAAAAAAAAAAD3t4C3pTdFB2Lm0iZ4MWZIb7gbpw==',
    'test-direct.yandex.com.tr' => 'AAyTxE8BAAAABx1qdwQAOpvAOtbWI6sxLC3xLk2vPg6zjk8AAAAAAAAAAAApF_MxHaL4rhWbXvr7MAyeEy-v7w==',
    'test2-direct.yandex.ru' => 'ACGTxE8BAAAAi9GJeQMAJB5gjhm7e35QsgSLFZKz7fXJSuIAAAAAAAAAAADWkP72tZVjwTwCPxwjpsOvl9J_Sw==',

    'loadtest-direct.yandex.ru' => 'ADaTxE8BAAAAV_ylfQMAKtz2GzMbVxuxOCFYqCXXAg5rzX0AAAAAAAAAAABcR3QcbZzNLLRax8okO_8Y1V1Cdw==',
    'loadtest-direct.yandex.kz' => 'AF-TxE8BAAAA-HxOVgMA7QCzVPZu2DlfRKrG7MDHtLVztrAAAAAAAAAAAACT8HiNd3vg3UiyOtwJRvhIk_Ooow==',
    'loadtest-direct.yandex.ua' => 'AHeTxE8BAAAA4WePIwMAN2Uz5s9aHFgegra9-gav_pc4obcAAAAAAAAAAAByxzfHsf8ShPLmiF0nhRvY1okBGQ==',
    'loadtest-direct.yandex.by' => 'AIqTxE8BAAAAve4pCwMA1iLwUp3_FlO3aaKtEVdpdb7-S-oAAAAAAAAAAADc8m57dJC2h0YptAL168pDnwHZhA==',
    'loadtest-direct.yandex.com' => 'AJuTxE8BAAAAtyeuVgMAtREZzdz5ELJD8yGx4uE2cLoYCSsAAAAAAAAAAADcCo1x_bfXfEhQfk2nR5HVwkVQWQ==',
    'loadtest-direct.yandex.com.tr' => 'ALGTxE8BAAAAboa1BwQAFd7iJB-tdbyOr6BRo9H-RRrIYdUAAAAAAAAAAADc3wpkftmVHY9GX_3J1a0YwX4qRg==',

    'test-bs-direct.yandex.ru' => 'AMiTxE8BAAAAkZsKJwMAIqiBwu7pwGGKvQ7nHlAsWzHfYIcAAAAAAAAAAABLL3aaLFeJ2SW_wXEUeFUbR2MY_w==',

    'yandex.ru' => 'AE_AjkgBAAAAVhRKNwIAC8tjU2RrhP-ZqBu8wUeLshaL0DUAAAAAAAAAAABvwCsB0jR6VKSmbT2ZrfeIDgc8bg=='
);
our $YMAPS_ORIGIN = "direct";

our @KARMA_CONST_LIMITS = ({x=>0,y=>0}, {x=>50,y=>100}, {x=>85,y=>50}, {x=>99,y=>10});
our $KARMA_API_AUTOBLOCK = 80;

# номера версий, доступных в API и предположительное время их вывода из поддержки
#   если время не известно - undef (must для текущей доступной версии),
#   если версия АПИ заканчивает поддержку - удаляем ее из списка
#   ОЧЕНЬ ПЛОХО удалять версию до истечения ее срока жизни БЕЗ ОБЪЯВЛЕНИЯ об заранее пользователям
#   последняя доступная версия НЕ ИМЕЕТ СРОКА!

our %AVAILABLE_API_VERSIONS = (
    '4'  => {border_date => undef},
    '4-latest' => {border_date => undef},
    '41-latest' => {border_date => undef},
    '42-latest' => {border_date => undef},
    '5' => {border_date => undef, hidden => 1},
);

=head2 $GEOCONTEXT_SUPER_UID

    Пользователь yndx.geomanager, из-под которого работает Геоконтекст

=cut

our $GEOCONTEXT_SUPER_UID = 112635943;


=head2 %UIDS_NO_LIMITS_API

    Список uid'ов, для которых отключены ограничения в АПИ

=cut

our %UIDS_NO_LIMITS_API = (
    $GEOCONTEXT_SUPER_UID => 'yndx.geomanager',
    233382465 => 'yndx-yabs-direct-audit',
);

# интервал протухания записи из mod_edit о том, что баннер редактировался на модерации.
# По истечении этого интервала сообщение пользователю показываться не будет
# значение в формате mysql interval
our $MOD_EDIT_EXPIRATION = '2 week';

# для пользователей, у которых количество фраз во всех кампаниях превышает
# $AUTOBAN_UPPER_BOUND + (количество внесенных денег в у.е. на аккаунте * $AUTOBAN_MONEY_COEF) + clients_autoban.autoban_bonus
# ставим автоматическую каптчу с частотой $AUTOBAN_CAPTCHA_FREQ
our $AUTOBAN_CAPTCHA_FREQ = 10;
our $AUTOBAN_MONEY_COEF   = 10;
our $AUTOBAN_UPPER_BOUND  = 50_000;

# сервера Memcached, нужны для Yandex::MemcachedLock
our $MEMCACHED_SERVERS = ['ppc-memcached-1.da.yandex.ru:11211', 'ppc-memcached-2.da.yandex.ru:11211', 'ppc-memcached-3.da.yandex.ru:11211'];

# префикс ключей в Redis
our $REDIS_KEY_PREFIX = '';

# сервера ZooKeeper
our $ZOOKEEPER_PORT = 2181;
our $ZOOKEEPER_SERVERS = ['ppc-zk-1.da.yandex.ru', 'ppc-zk-2.da.yandex.ru', 'ppc-zk-3.da.yandex.ru'];
our $ZOOKEEPER_SERVERS_NP = ['ppctest-zk-1.da.yandex.ru', 'ppctest-zk-2.da.yandex.ru', 'ppctest-zk-3.da.yandex.ru'];

# максимальное количество слов в ключевой фразе
our $MAX_WORDS_IN_KEYPHRASE = 7;

# количество попыток формирования оффлайнового отчета статистики
our $OFFLINE_STAT_MAX_RETRIES = 5;

# максимальное количество показов в периоде, при котором можно строить статистику онлайн
our $CAMPSTAT_SHOWS_ONLINE_LIMIT = 1_000_000;

# До скольки символов обрезать длину ключевых фраз и метки в Мастере отчетов.
our $PHRASE_TRANCATE_LENGTH = 80;

# пауза в секундах, если очередь обработки кампаний пуста
our $CAMP_QUEUE_SLEEP = 10;

# минимальное кол-во переходов для выбора цели для CPA-оптимизации
our $MIN_GOALS_ON_CAMPAIGN = 40;

# goal_id для стратегии оптимизация по количеству установок приложения
our $DEFAULT_CPI_GOAL_ID = 4;

# deprecated: Магическая константа. Везде в Директе принято, что 0 означает "все цели".
our $ALL_GOALS = 0;

# goal_id для вовлечённых сессий
our $ENGAGED_SESSION_GOAL_ID = 12;

# goal_id для оптимизации по ключевым целям
our $MEANINGFUL_GOALS_OPTIMIZATION_GOAL_ID = 13;

# границы goal_id ecommerce-покупок и событий "положил в корзину"
our $ECOMMERCE_MIN_GOALID = 3_000_000_000;
our $ECOMMERCE_MAX_GOALID = 4_000_000_000;

# порог для выдачи предупреждения о малом количестве целевых визитов/установок, см. Campaign::mass_get_allow_autobudget_avg_cpx()
our $CPX_FACTOR = 3;

# максимальное количество кампаний у клиентов, для которых нет особых ограничений
our $DEFAULT_CAMP_COUNT_LIMIT = 3000;

# максимальное количество неархивных кампаний у клиентов, для которых нет особых ограничений
our $DEFAULT_UNARC_CAMP_COUNT_LIMIT = 1000;

# максимальное количество групп у кампании для клиентов, у которых нет особых ограничений
# название осталось от ограничений на баннеры(теперь баннеры это креативы)
our $DEFAULT_BANNER_COUNT_LIMIT = 1000;

# максимальное количество фраз в группе
our $DEFAULT_KEYWORD_COUNT_LIMIT = 200;

# максимальное количество запрещённых площадок объявлений(кроме видеообъявлений)
our $DEFAULT_GENERAL_BLACKLIST_SIZE_LIMIT = 1000;

# максимальное количество запрещённых площадок видеообъявлений
our $DEFAULT_VIDEO_BLACKLIST_SIZE_LIMIT = 20;

# максимальное количество креативов(блоков) на группу
our $DEFAULT_CREATIVE_COUNT_LIMIT = 50;

#  максимальное количество перформанс креативов в аккаунте клиента
our $DEFAULT_PERFORMANCE_CREATIVE_COUNT_LIMIT = 3000;

# максимальное количество фидов на клиента
our $DEFAULT_FEED_COUNT_LIMIT = 50;

# ограничение на размер файла фида
our $DEFAULT_FEED_MAX_FILE_SIZE = 512 * 1024 * 1024;

# интервал обновления фида по умолчанию
our $DEFAULT_FEED_REFRESH_INTERVAL = 24 * 60 * 60;

# максимальная длина параметра ссылки (a.k.a. Param1, Param2 в API)
our $MAX_HREF_PARAM_LENGTH = 255;

our $MAX_ATTACHED_DOCUMENTS = 10;
our $MAX_ATTACHED_DOCUMENT_SIZE = 16 * 1024 * 1024;
our $MAX_ATTACHED_DOCUMENTS_DAY_COUNT = 50;

# файл с данными для langdetect (ставится пакетом yandex-lang-detect-data)
our $LANG_DETECT_DATA_FILE = '/usr/share/yandex/lang_detect_data.txt';
# номер блока в куке my для языка интерфейса
our $LANG_DETECT_COOKIE_MY_LANG_NUM = 39;

# допустимые расширения файлов документов клиентов для модерации
our @ALLOWED_DOC_EXTENSIONS = (qw/jpg png bmp gif pdf doc jpeg pdf docx rtf zip rar 7z/);

# через сколько дней удаляем логин после последнего изменения, должно быть больше чем $DAYS_EXPIRE в ppcClearEmptyCampaigns.pl
our $DAYS_EXPIRE_FOR_CLEAR_LOGIN = 30;

# настройки удаления пустых кампаний
our $HOURS_EXPIRE = 7*24;
our $DAYS_EXPIRE_FORCE = 70;

# через сколько секунд после нажатия "Напомнить позже" снова начинаем показывать развёрнутым тизер про переход в реальную валюту
our $MULTICURRENCY_TEASER_DELAY_SECONDS = 24 * 60 * 60; # сутки

# только раз в сутки даем включать общий счет
our $MIN_WALLET_DAYS_INTERVAL = 1;

# максимальное значение процента остатка средств для получения предупреждения об окончании средств
our $MAX_MONEY_WARNING_VALUE = 50;

# дефолтное значение процента остатка средств для получения предупреждения об окончании средств
our $DEFAULT_MONEY_WARNING_VALUE = 20;

# сколько минут не даем архивировать кампанию после последнего показа
our $MINUTES_AFTER_LAST_SHOW_FOR_ARC_CAMP = 60;

# длина одного уточнения
our $MAX_CALLOUT_LENGTH = 25;

# количество привязанных уточнений на баннер
our $MAX_CALLOUTS_COUNT_ON_BANNER = 50;

# количество уточнений на клиента
our $MAX_CALLOUTS_COUNT_ON_CLIENT = 1000;

# количество уточнений на клиента с учетом удаленных
our $MAX_CALLOUTS_COUNT_ON_CLIENT_WITH_DELETED = 10000;

# рекомендуемая длина уточнений на баннер
our $MAX_CALLOUT_LENGTH_ON_BANNER = 66;

#  максимальное количество библиотечных элементов в аккаунте клиента
our $LIBRARY_MINUS_WORDS_COUNT_LIMIT = 30;

# Типы продуктов, для которых мы хотим автоматически создавать биллинговые агрегаты
# при создании кампании.
# Пока есть необходимость только в агрегатах для продуктов cpm_banner, cpm_video и cpm_audio,
# и на начальных этапах не создаем автоматически сверх того.
our $BILLING_AGGREGATES_AUTO_CREATE_TYPES = [qw/cpm_banner cpm_video cpm_outdoor cpm_indoor cpm_audio/];

#### Новости

our $NEWS_ARCHIVE_URL = 'https://yandex.<tld>/adv/news?tag=<tag>';
our $ADV_NEWS_API_URL = 'https://adv-api.common.yandex.ru/v1/posts/';

our $ADV_NEWS_TVM2_ID = '2000084';

# количество новостей на морде
our $NUM_OF_NEWS_ON_FRONT = 3;

#значение приоритета дефотной группы в прайсовых кампаниях
our $DEFAULT_CPM_PRICE_ADGROUP_PRIORITY = 0;
#значение приоритета специфичной группы в прайсовых кампаниях
our $SPECIFIC_CPM_PRICE_ADGROUP_PRIORITY = 10;

# Доступные фиды новостей, ключ - язык блога новостей
# Поля:
#   api_slug - идентификатор, блога дописывается к $ADV_NEWS_API_URL
#   locale - язык блога, передается в параметре lang при запросе в $ADV_NEWS_API_URL
#   tag - (опционально) тема (тег) по которой нужно забирать выборку новостей из блога, передается параметром tag при запросе в $ADV_NEWS_API_URL
#   tld - домен второго уровня, который подставится в ссылку на новость
#   date_format - формат даты публикации новсти в котором она будет отображаться на морде Директа и в RSS
our %NEWS_FEED = (
    ru => {
        api_slug => 'adv-news',
        tag => 'direkt',
        tld => 'ru',
        locale => 'ru-RU',
        date_format => "d MMMM yyyy г",
    },
    en => {
        api_slug => 'adv-news-com',
        tag => 'yandex-direct',
        tld => 'com',
        locale => 'en-EN',
        date_format => "MMMM d, yyyy",
    },
    tr => {
        api_slug => 'adv-news-com-tr',
        tag => 'yandex-direct',
        tld => 'com.tr',
        locale => 'tr-TR',
        date_format => "d MMMM yyyy",
    },
);

# Какие языки новостей для каких регионов доступны
our %NEWS_LANG_REGIONS = (
    ru => {
        region => [ qw/ ru en kz by/ ],
    },
    en => {
        region => [ qw/ ru en tr kz by/ ],
    },
    tr => {
        region => [ qw/ tr / ],
    },
);

our %NEWS_REGION_ALIAS = (
    ua => 'ru',
);


our $SSRF_PROXY = "zora-online.yandex.net:8166";
our $SSRF_PROXY_SOURCENAME = 'direct_userproxy';

our $GOZORA_PROXY = 'http://go.zora.yandex.net:1080';
our $GOZORA_PROXY_SOURCENAME = 'direct_userproxy';
our $GOZORA_PROXY_HEADERS = {
    'X-Ya-Client-Id'  => $GOZORA_PROXY_SOURCENAME,
};

{
    no warnings 'once';
    $LWP::UserAgent::Zora::ZORA_URL = "http://$SSRF_PROXY";
    $LWP::UserAgent::Zora::ZORA_SOURCENAME = $SSRF_PROXY_SOURCENAME;
}

$Yandex::DBShards::IDS_LOG_PREFIX = 'PPC';
$Yandex::DBShards::IDS_LOG_FILE = 'dbshards_ids.log';
{
    no warnings 'once';
    $Yandex::DBTools::CONFIG_FILE = "/etc/yandex-direct/db-config.json";
    $Yandex::DBTools::CHECK_HOST_CHANGES = 1;
    $Yandex::DBTools::QUOTE_DB = 'ppcdict';
    $Yandex::DBTools::TRACE_COMMENT = 1;
    $Yandex::DBUnitTest::SHARDED_DB_RE = qr/^ppc$/;

    $Yandex::DBSchema::DB_SCHEMA_ROOT = "$ROOT/db_schema";
    $Yandex::DBShards::STRICT_SHARD_DBNAMES = 1;
    $Yandex::DBShards::SHARD_DB = 'ppcdict';
    %Yandex::DBShards::SHARD_KEYS = (
        # единственная табличка, которая мэпит в шарды
        ClientID => {
            table => 'shard_client_id',
            shard_key => 'shard',
            not_zero  => 1,
        },
        # таблички для внешних id (без autoincrement)
        uid => {
            table => "shard_uid",
            chain_key => "ClientID",
        },
        login => {
            type => 'str',
            table => "shard_login",
            chain_key => "uid",
        },
        OrderID => {
            table => "shard_order_id",
            chain_key => "ClientID",
        },
        creative_id => {
            table => "shard_creative_id",
            chain_key => "ClientID",
        },
        relation_id => {
            table => "inc_clients_relations_id",
            autoinc => 1,
        },
        reverse_relation_id => {
            table => "inc_reverse_clients_relations_id",
            autoinc => 1,
        },
        id => {
            table => "inc_adgroup_additional_targetings",
            autoinc => 1,
        },
        # таблички для id с автоинкрементом и мэппингом
        (map {
            $_ => {
                table => "shard_inc_$_",
                autoinc => 1,
                chain_key => "ClientID",
            }

        } qw/cid bid mbid pid tag_id sitelinks_set_id ret_cond_id org_details_id vcard_id
            banner_images_pool_id mediaplan_bid strategy_id/),

        # таблички для id только с автоинкрементом
        # TODO: здесь много всего, стоит упорядочить по алфавиту?
        goal_id => {
            table => "inc_mobile_goals_id",
            autoinc => 1,
        },
        href_id => {
            table => "inc_banner_additional_hrefs_id",
            autoinc => 1,
        },
        request_id => {
            table => "inc_client_mcc_requests_id",
            autoinc => 1,
        },
        promotion_id => {
            table => "inc_campaigns_promotions_ids",
            autoinc => 1,
        },
        turbo_app_info_id => {
            table => "inc_turbo_apps_info_id",
            autoinc => 1,
        },
        (map {
            $_ => {
                table => "inc_$_",
                autoinc => 1,
            }
        } qw/phid ret_id aid sl_id mw_id maps_id report_id mcb_phrases_id users_notification_id
             mediaplan_phid mediaplan_ret_id mediaplan_mpid
             dyn_id dyn_cond_id
             opt_camp_request_id opt_camp_postpone_id doubles_request_id cr_id
             client_domains_record_id client_domains_sync_id client_domains_stripped_record_id
             mobile_app_id
             mobile_app_tracker_id
             mobile_content_id
             hierarchical_multiplier_id
             feed_id perf_filter_id
             additions_item_id
             job_id
             bsexport_iter_id
             bs_order_id
             mds_id image_id
             experiment_id
             banner_creative_id
             resource_id
             pixel_id
             agency_offline_report_id
             moderate_banner_page_id
             client_dialog_id
             agency_lim_rep_group_id
             banner_multicards_multicard_id
             filtered_feed_id
             client_cashback_details_id
             client_cashback_program_id
             client_cashback_history_id
             calltracking_settings_id
             dsp_creative_caesar_iter_id
             daas_brief_id
             caesar_iter_id
             client_phone_id
             offline_report_id
             clients_avatars_id
             content_promotion_id
             content_promotion_video_id
             deal_notification_id
             freelancer_project_id
             freelancers_card_id
        /),
    );

    $Yandex::Advmon::GRAPHITE_PREFIX = sub {[qw/one_min direct/, $CONFIGURATION]};
    $Yandex::Advmon::GRAPHITE_SENDER = 'localhost:42000';
};

###
our $DBSTAT_ANALYS_TIMEOUT = 20;

{
    no warnings 'once';

    # наша текущая временная зона на наших серверах
    $Yandex::DateTime::YANDEX_LOCAL_TIMEZONE =  'Europe/Moscow';

    $Yandex::MyGoodWords::MAX_WORDS_IN_KEYPHRASE = $MAX_WORDS_IN_KEYPHRASE;

    # языки которые поддерживаются директом
    # если используется нестандартная локаль для какого-то языка -- дополнительно надо указать это в etc/translation.conf, секция locales
    %Yandex::I18n::LOCALES = (
        ru => 'ru_RU',
        en => 'en_US',
        ua => 'uk_UA',
        'tr' => {locale => 'tr_TR', base => 'en'}
    );
    %Yandex::I18n::LANG_ALIAS = (uk => 'ua');
    $Yandex::I18n::LOCALE_PATH = $ROOT.'/locale/';
    $Yandex::I18n::PROJECT_ID  = 'direct';
    $Yandex::I18nTools::PROJECT_ID_VERSION  = 'direct.yandex.ru';

    # для логина directdeveloper
    $Net::Surveymonkey::SM_API_KEY = 'hgmvmj4qj3mywqvtbdfc27b9';
    $Net::Surveymonkey::SM_API_TOKEN_FILE = '/etc/direct-tokens/direct-surveymonkey.token';

    $Survey::TNS::TNS_BASE_URL = 'http://ts.ktrmr.com/surveyv.aspx';

    $Yandex::Avatars::MDS::LOG_PUT_REQUESTS = 1;
}

our %INTERFACE_LANGS = (
    ru => 'по-русски',
    en => 'in English',
    ua => 'українською',
    'tr' => 'Türkçe'
);

=head2 %SERVICEID

    ServiceID для Директа и Баяна (используется для общения с Балансом и БК); он же EngineID

    имена ключей специально сделаны отличными от text/mcb, чтобы не дублировать (mcb_pkg и т.п.)
    и избежать соблазна использовать $SERVICEID{$type} (в этом случае правильно смотреть на
    EngineID из таблицы products)

=cut

our %SERVICEID = (
    direct => 7,
    banana => 67,
    bayan => 77,
    ya_agency => 177,
);

# Настройки гарыныча
our %GORYNYCH_DATA = (
    AUTH_URL        => 'https://gorynych.yandex-team.ru/direct-token/',
    CLIENT_ID       => '1b8dac53e0f64875912f9dc3e1600688',
    CLIENT_SECRET   => 'b456f7efd74c4882bbec19833bb3803d',
    EMAIL           => 'custom-solutions-dev@yandex-team.ru',
);

# id продуктов для YaAgency
our $YaAgency_PRODUCTS = {
     508495 => '1 руб.(тест)',
     508496 => '5 руб.(тест)',
     508497 => '10 руб.(тест)',
     508499 => 'Минимальный Тариф 3000 руб Для рекламы 1-2 товаров/услуг',
     508498 => 'Базовый Тариф 5000 руб. Для рекламы 3-10 товаров/услуг',
     508500 => 'Расширенный Тариф 10000 руб. Для рекламы 11-30 товаров/услуг',
};

our $YaAgency_PRODUCT_BY_FRONTEND_ID = {
    1 => 508499,
    2 => 508498,
    3 => 508500
};

# Сообщение об ошибке, которое используется при установке таимаута с помощью alarm
# Перевод строки важен для корректного распознания ошибки
our $TIMEOUT_ALERT_MESSAGE = "timeout_alarm\n";

our $AVATARS_MDS_HOST = 'avatars.mds.yandex.net';

our $BETA_PORT;
our $BETA_HOST;

=head2 $AD_DESIGNER_HOST_WITHOUT_TLD

Название хоста фронта сервера по созданию креативов без tld.
tld будет браться "на лету" из запроса пользователя к Директу.

=cut

# значение по умолчанию записано в etc/frontend/nginx/direct-vhost.conf
our $AD_DESIGNER_HOST_WITHOUT_TLD;

=head2 $CANVAS_UI_DOMAIN

Домен, начиная от третьего уровня,  фронт сервера конструктора креативов
Итоговый хост будет https://$CANVAS_UI_DOMAIN.yandex.tld

=cut

our $CANVAS_UI_DOMAIN = "canvas";

=head2 $TURBO_UI_DOMAIN

Домен, начиная от третьего уровня,  фронт сервера конструктора турбо-страниц
Итоговый хост будет https://$TURBO_UI_DOMAIN.yandex.tld

=cut

our $TURBO_UI_DOMAIN = "ad-constructor";

=head2 $SURVEYS_UI_DOMAIN

Домен, начиная от третьего уровня, фронт сервера Я.Взгляда
Итоговый хост будет https://$SURVEYS_UI_DOMAIN.yandex.tld

=cut

our $SURVEYS_UI_DOMAIN = "surveys";

=head2 $CAN_EDIT_COUNTRY_CURRENCY_UIDS

    Ссылка на список паспортных UID'ов суперов, которые могут редактировать страну/валюту клиентов.

=cut

our $CAN_EDIT_COUNTRY_CURRENCY_UIDS;
push @$CAN_EDIT_COUNTRY_CURRENCY_UIDS, (
    969924051, # yndx-saturday-super
    1456233526, # yndx-mvfokin
    1516827906, # yndx-sashaspb-super
    1429003904, # yndx-aogay-super
    1398872267, # yndx-lipchin-super
    1227533131, # yndx-anyksenya-super
    933325662, # yndx-ulyashevda-super
    1347069823, # yndx-dmsuvorov-super
);

=head2 $STOP_OPERATION_MINUTES_BEFORE_CONVERT

    За сколько минут до начала конвертации перестаём совершать с конвертируемыми кампаниями/клиентам
    какие-либо действия. Интерфейс и API на время конвертации заблокированы, но скрипты продолжают
    работать и изменение валюты во время обработки недопустимо. Поэтому используем оптимистическую
    блокировку: за N минут до начала конвертации начинаем пропускать кампании и снова их обрабатываем
    только после полного завершения конвертации.

=cut

our $STOP_OPERATION_MINUTES_BEFORE_CONVERT = 15;

=head2 $MAX_INT_VAL

    Максимальное беззнаковое целочисленное значение в перле.
    Также можно использовать ULONG_MAX из POSIX.

=cut

our $MAX_INT_VAL = ~0;

=head2 $SHARDS_NUM

    Количество поддерживаемых шардов

=cut

our $SHARDS_NUM = 26;

my $YT_ACCOUNT = "direct";

=head2 $YT_CONF

    Данные для коннекта в кластеры YT(mapreduce)

=cut

my %freud_conf = (
        name => 'Freud',
        proxy => 'freud.yt.yandex.net',
        token_path => '/etc/direct-tokens/yt_robot-direct-yt',
        prefix => "//home/$YT_ACCOUNT/",
    );
my %hahn_conf = (
        name => 'Hahn',
        proxy => 'hahn.yt.yandex.net',
        token_path => '/etc/direct-tokens/yt_robot-direct-yt',
        prefix => "//home/$YT_ACCOUNT/",
    );
my %arnold_conf = (
        name => 'Arnold',
        proxy => 'arnold.yt.yandex.net',
        token_path => '/etc/direct-tokens/yt_robot-direct-yt',
        prefix => "//home/$YT_ACCOUNT/",
    );
my %arnold_dev_conf = (
    %arnold_conf,
    prefix => "//home/direct-dev/",
);

our $YT_CONF = {
    prod => {%hahn_conf},
    hahn => {%hahn_conf},
    arnold => {%arnold_conf},
    'arnold-dev' => {%arnold_dev_conf},
    freud => {%freud_conf},
    backup =>  {%freud_conf},
};

# выделенные пулы для продакшн процессов. если не определен - пул не будет указан
our $YT_POOL_UPLOAD_DB = 'direct-upload-ppcdata';
our $YT_POOL_PROCESS_LB = 'direct-process-logbroker-log';

our $OTRS_EMAIL = 'api-direct-apps@support.yandex.ru';

=head2 @UNARCHIVABLE_TEST_USERS

    Тестовые пользователи, которые не изменяют свои объекты, но нужны
    Их объекты нельзя архивировать

=cut

our @UNARCHIVABLE_TEST_USERS = qw(yb-adm yb-adm2 yb-other-1 yb-manager-2 yb-other-2 yb-manager-3 yb-agency-1 yb-client-1 bk-direct-test);

=head2 @UNARCHIVABLE_AGENCYIDS

    Агентства, кампании субклиентов которых не нужно автоматически ахивировать

=cut

our @UNARCHIVABLE_AGENCYIDS = (
    4644194, # booking-mcc, DIRECT-49684
    5233971, # booking-adnetwork-mcc, DIRECT-62555
    2304484, # omd-for-apple, DIRECT-66337
    15241527, # omd-apple-usd, DIRECT-66337
    74171260, # yndx-smart-recommend-agency, DIRECT-114272
    71028274, # bkagentstvo, DIRECT-117347
);

# uidы логинов операторов, для которых разрашаем использовать чужие счётчики для смарт-кампаний
our %DO_NOT_VALIDATE_ACCESS_TO_METRIKA_GOALS = (
    74171260 => 1, # yndx-smart-recommend-agency
);

=head2 UNREGISTERED_APPS_STOP_FLAG

    Для API, нужно ли останавливать не зарегистрированные приложения

=cut

our $UNREGISTERED_APPS_STOP_FLAG = "$ROOT/protected/run/unregistered_apps_stop.flag";

our $MDS_NAMESPACE = 'direct-files';

our $BANNER_LAND_URL = 'http://bmapi.yandex.ru/fcgi-bin/';

# переменные для управления скриптом ppcProcessImageQueue.pl
our $ProcessImageQueue_MAX_ITERATIONS = 2_000;
our $ProcessImageQueue_MIN_ITERATION_DURATION = 20;

# переменные для управления скриптом ppcCampAutoPrice.pl
our $CampAutoPrice_SLEEP_BETWEEN_EXEC = 10;

{
no warnings 'once';
%Yandex::Balance::BALANCE_CALLS_LOG_SETTINGS = (
    no_log => 1,
    no_date => 1,
    use_syslog => 1,
    syslog_prefix => 'BALANCE',
    log_file_name => "balance_calls.log",
);
}

{
no warnings 'once';
%ADVQ6::ADVQ_CALLS_LOG_SETTINGS = (
    no_log => 1,
    no_date => 1,
    use_syslog => 1,
    syslog_prefix => 'ADVQ',
    log_file_name => "advq_calls.log",
);
}

# настройки вокруг switchman
our $SWITCHMAN_MEM_LEASE_NAME_IN_META = 'mem';
# ВНИМАНИЕ, если в ноде /direct/switchman нет resources с такими именами - ничего работать не будет!
our $SWITCHMAN_MEM_LEASE_NAME_IN_PARAMS = 'FQDN_mem2';
# при смене значения желательно поменять также SWITCHMAN_MEM_LEASE_NAME_IN_PARAMS (например FQND_mem <-> FQDN_mem2)
# так как switchman не будет работать с новым значение (под старым именем) пока есть "живая" аренда со старым значением
our $SWITCHMAN_DEFAULT_FQDN_MEM_TOTAL = "int(6/4*MEMMB)";

# Путь в ZooKeeper, по которому кокаиновые приложения получают конфиг базы данных через сервис unicorn.
our $DB_CONFIG_UNICORN_NODE = '/direct/unicorn/db-config';

# Максимальный размер сериализованных в json условий нацеливания ДО и performance-фильтров
our $MAX_CONDITION_JSON_LENGTH = 65535;

our $REQ_WIZARD_URL = 'http://reqwizard.yandex.net:8891/wizard';

our $BASE_CANVAS_URL = 'http://canvas.yandex.ru';
# URL для canvas-креативов
our $CANVAS_URL = $BASE_CANVAS_URL . '/creatives';

# URL для доступа к API видеоплатформы
our $VIDEO_API_URL = 'http://api.video.yandex.net:8080/v1';
# пользователь, под которым загружаем ресурсы в видеоплатформу
# login: videodirekt
our $VIDEO_API_UID = 441898373;

# URL кабинета кампаний Дзена
our $ZEN_VIEW_URL = "https://zen.yandex.ru/profile/editor/campaigns/direct/"; # + cid

{
no warnings 'once';
# URL для получения турболендингов
$BannerStorage::BS_TURBOLANDINGS_API_URL = 'https://canvas.yandex.ru/landings/rest/landings/direct';
$BannerStorage::UNIFIED_TURBOLANDINGS_API_URL = 'https://ad-constructor.yandex.ru/api/direct';
}

our $QUERYREC_JAVA_HTTP_URL = $DIRECT_JAVA_INTAPI_URL.'queryrec/recognize_texts';
our $ANALYZE_TEXTS_LANG_JAVA_HTTP_URL = $DIRECT_JAVA_INTAPI_URL.'queryrec/analyze_texts_lang';
our $CHECK_AUTH_FOR_SMS_JAVA_HTTP_URL = $DIRECT_JAVA_INTAPI_URL.'sms_auth/check_auth';

# сейчас используется в Директе только на разработческих средах и ТС, для отправки фейковых нотификаций в старый INTAPI
our $DIRECT_INTAPI_SOAP_URL = $DIRECT_INTAPI_URL.'soap';

{
    no warnings 'once';

    # Включена ли "внешняя шаблонизация" через ynode
    our $EXTERNAL_TEMPLATING = 1;
    $Direct::Template::EXTERNAL_TEMPLATING_URL = "http://127.0.0.1:7200/template";

    # Соответствует указанию "name: scripts.SCRIPT_NAME_WITHOUT_EXTENSION.working" в метаданных
    $ScriptsMetadata::DEFAULT_JUGGLER_NAME_TEMPLATE = 'scripts.%s.working';

    # Соответствует указанию в метаданных:
    #   для нешардированных скриптов "raw_events: scripts.SCRIPT_NAME_WITHOUT_EXTENSION.working"
    #   для шардированных "raw_events: scripts.SCRIPT_NAME_WITHOUT_EXTENSION.working.shard_$shard"
    $ScriptsMetadata::DEFAULT_JUGGLER_RAW_EVENTS_TEMPLATE = 'scripts.%s.working%s';

    @ScriptsMetadata::DEFAULT_JUGGLER_RAW_HOST = ('CGROUP%direct_ng_scripts_prod');

    $ScriptsMetadata::JUGGLER_CHECK_RAW_HOST = 'checks_auto.direct.yandex.ru';
}

our $CPM_SHOWS_COEF = 1000;

# HOST для корзины "Баланса"
our $BALANCE_CART_UI_URL = "https://balance.yandex.ru";

# куда редиректить незалогиненных пользователей вместо index
our %DIRECT_LANDING_PAGE_URL = (
    # lpc-promo — location в nginx, потом название страницы в конструкторе креативов по адресу https://yandex.ru/promo/direct/main/tld/$1
    ru => "/lpc-promo/ru15",
    by => "/lpc-promo/by5",
    kz => "/lpc-promo/kz5",
);

our $DNA_OVERRIDE_HASHSUM_ALLOWED = 0;

our $USE_EXTERNAL_HASHSUM_AND_BUNDLES_FLAG = "$ROOT/protected/run/use_external_hashsum_and_bundles.flag";

my $settings_local_file = $ROOT."/perl/settings/Settings".($ENV{SETTINGS_LOCAL_SUFFIX} || 'Local').".pm";
our $NO_SETTINGS_LOCAL;
if (!$Settings::NO_SETTINGS_LOCAL && ($ENV{SETTINGS_LOCAL_SUFFIX} || -e $settings_local_file)) {
    no warnings 'once';
    do $settings_local_file or die "Can't load $settings_local_file: $@";

    my $beta_ctl = '/usr/local/bin/beta-ctl';
    if (-x $beta_ctl && !$ENV{SETTINGS_LOCAL_SUFFIX}) {
        require JSON;
        my %beta_settings = %{ +eval { JSON::decode_json(`'$beta_ctl' --dir '$ROOT' get-settings`) } || {} };
        warn $@ if $@;

        if (my $ess = $beta_settings{"java_properties"}{"tracing.tags.ess"}) {
            my $old_vars = $Yandex::DBTools::TRACE_COMMENT_VARS;
            $Yandex::DBTools::TRACE_COMMENT_VARS = sub {return {%{$old_vars->()}, ess => $ess}; };
        }

        $Settings::INFOBLOCK_URL = $beta_settings{infoblock_url} if exists $beta_settings{infoblock_url};
        $Settings::INFOBLOCK_MESSAGES_URL = $beta_settings{infoblock_ajax_url} if exists $beta_settings{infoblock_ajax_url};
        $Moderate::Settings::MODERATE_JSON_URL = $beta_settings{moderate_json_url} if exists $beta_settings{moderate_json_url};
        $Moderate::Settings::MODERATE_URL = $beta_settings{moderate_soap_url} if exists $beta_settings{moderate_soap_url};
        $Moderate::Settings::MODERATE_JSON_PROXY_URL = $beta_settings{moderate_json_proxy_url} if exists $beta_settings{moderate_json_proxy_url};
        $Yandex::DBTools::CONFIG_FILE = $beta_settings{db_config_file} if exists $beta_settings{db_config_file};
        $Direct::Template::EXTERNAL_TEMPLATING_URL = $beta_settings{js_templater_url} if exists $beta_settings{js_templater_url};

        # настройки, связанные с канвасом
        $Settings::CANVAS_UI_DOMAIN = $beta_settings{canvas_ui_domain} if exists $beta_settings{canvas_ui_domain};
        $BannerStorage::BS_TURBOLANDINGS_API_URL = "https://$beta_settings{canvas_ui_domain}.yandex.ru/landings/rest/landings/direct" if exists $beta_settings{canvas_ui_domain};
        $Direct::ResponseHelper::CSP_HEADER_PLACEHOLDER{canvas_tld} = $beta_settings{canvas_ui_domain} if exists $beta_settings{canvas_ui_domain};
        # апи канваса можно более приоритетно переопределить отдельно от canvas_ui_domain. Это нужно для работы локального канваса
        $BannerStorage::BS_CANVAS_API_URL = exists $beta_settings{bs_canvas_api_url} ? $beta_settings{bs_canvas_api_url} :
            exists $beta_settings{canvas_ui_domain} ? "https://$beta_settings{canvas_ui_domain}.yandex.ru:8080/direct" : $BannerStorage::BS_CANVAS_API_URL;
        $BannerStorage::BS_VIDEO_ADDITION_API_URL = exists $beta_settings{bs_video_additions_api_url} ? $beta_settings{bs_video_additions_api_url} :
            exists $beta_settings{canvas_ui_domain} ? "https://$beta_settings{canvas_ui_domain}.yandex.ru:8081/video/direct" : $BannerStorage::BS_VIDEO_ADDITION_API_URL;
        $DNA_ROOT = "$ROOT/dna" if $beta_settings{dna_enabled};

        $Settings::SURVEYS_UI_DOMAIN = $beta_settings{surveys_ui_domain} if exists $beta_settings{surveys_ui_domain};

        $Settings::DNA_OVERRIDE_HASHSUM_ALLOWED = $beta_settings{dna_override_hashsums_allowed} if exists $beta_settings{dna_override_hashsums_allowed};
    }
}
# Пожалуйста, не добавляйте в этом месте новых настроек.
# Добавляйте их выше по коду, до подключения SettingsLocal.pm

1;

=head1 AUTHORS

in alphabetical order:

  Maxim Kuzmin C<kuzmin@yandex-team.ru>
  Sergey Mudrik C<msa@yandex-team.ru>
  Sergey Zhuravlev C<zhur@yandex-team.ru>

=head1 COPYRIGHT

Copyright (c) 2005-2009 Yandex. All rights reserved.

=cut
