package SettingsALL;

# $Id$

=head1 NAME

    SettingsALL

=head1 DESCRIPTION

    Модуль позволяет использовать разные базы данных (prod/dev/...) в одном скрипте.
    Запрещается использовать в продакшен.    

=head1 SYNOPSIS
    
    use SettingsALL;
    use Yandex::DBTools;
    for my $db (PPC, DEV_PPC, PRODUCTION_PPC) {
        print $db, " ", get_one_field_sql($db, "SELECT count(*) from campaigns"), "\n";
    }

=cut

use warnings;
no warnings 'once';
use strict;

use constant;
use Carp qw/croak/;
use File::Basename;
use File::Slurp;
use YAML;
use JSON;
use Data::Dumper;

use Yandex::HashUtils;
use Yandex::DBTools;

use base 'Exporter';

our @EXPORT;

use utf8;

##Для запусков в CI
if ($ENV{SETTINGS_LOCAL_SUFFIX} eq 'Distbuild') {
    no warnings 'redefine';
    *Sys::Hostname::hostname = sub {
        return "ppcdev100.yandex.ru"
    };
}

sub load_db_config {
    my $file = shift;

    ##Для запусков в CI
    if ($ENV{SETTINGS_LOCAL_SUFFIX} eq 'Distbuild') {
        $file = $ENV{UNIT_TEST_DB_CONFIG_PATH};
    }

    if ($file =~ /\.ya?ml$/) {
        return YAML::LoadFile($file);
    } elsif ($file =~ /\.json$/) {
        return JSON::from_json(scalar read_file($file));
    } else {
        die "Unknown db-config format: $file";
    }
}

my @CONFIGURATION_NAMES = qw(
    Production

    DevTest
    Dev7
    Test
    Test2
    TestLoad
    Sandbox
    SandboxDevTest
    SandboxDev7
    SandboxTest
    SandboxTest2
);

sub import {
    shift;
    my @imports = @_;

    no warnings qw/once redefine/;

    my %all_childs;

    if ($INC{'Settings.pm'}) {
        croak "SettingsALL must be loaded before Settings";
    }

    local $Settings::NO_SETTINGS_LOCAL=1;
    local $Settings::NO_REGISTER_DB_NAMES = 1;
    require Settings;
    for my $name (@CONFIGURATION_NAMES) {
        if ($name ne 'Production') {
            do "$Settings::ROOT/perl/settings/Settings$name.pm" or croak "Can't load settings for $name: $@";
        }
        my $cfg = $all_childs{lc $name} = load_db_config($Yandex::DBTools::CONFIG_FILE)->{db_config};
        while(my ($key, $val) = each %{$cfg->{CHILDS}}) {
            $val->{db} ||= $key;
        }
    }
    $Settings::NO_SETTINGS_LOCAL=0;
    do "$Settings::ROOT/perl/settings/Settings.pm" or croak $@;
    
    hash_merge \%Yandex::DBTools::DB_CONFIG, load_db_config($Yandex::DBTools::CONFIG_FILE)->{db_config};
    hash_merge $Yandex::DBTools::DB_CONFIG{CHILDS}, \%all_childs;

    @Settings::DB_NAMES = @{get_db_childs("", recursive => 1)};

    Settings::register_db_names();
    Settings->import(@imports);
    @EXPORT = @Settings::EXPORT;

    SettingsALL->export_to_level(1, @imports);
}

1;
