package Settings;

use warnings;
no warnings 'once';
use utf8;

sub BEGIN {
    no warnings 'redefine';
    require Sys::Hostname;
}

do 'SettingsTest.pm' or die $@;

$BETA_PORT = $ROOT =~ /\.(\d{4,5})(?:(?:\/arcadia)?\/direct\/perl)?\/*$/ ? $1 : 80;
my ($ppcdev_num) = (Sys::Hostname::hostname() =~ /ppcdev(\d+)/);
unless ($ppcdev_num) {
    warn "failed to get ppcdev number";
    $ppcdev_num = 1;
}
$BETA_HOST = "$BETA_PORT.beta$ppcdev_num.direct.yandex.ru";

$CONFIGURATION = 'devtest';

require Yandex::Log;
require Yandex::Log::Messages;
$Yandex::Log::LOG_UMASK = 0;
$Yandex::Log::Messages::_HOSTNAME = "$BETA_PORT.$Yandex::Log::Messages::_HOSTNAME" if $Yandex::Log::Messages::_HOSTNAME !~ /^$BETA_PORT\./;

$Settings::SHARDS_NUM = 21;
$Yandex::DBTools::CONFIG_FILE = "/etc/yandex-direct/db-config-np/db-config.devtest.json";
$Yandex::DBTools::QUERIES_LOG = 'dbtools_queries.log';

require Log::Any::Adapter;
require Yandex::DBTools;

# логирование ворнингов mysql
Log::Any::Adapter->set(
    { category => $Yandex::DBTools::LOG_WARNINGS_CATEGORY },
    YandexLog => (log_file_name => 'dbtools_warnings.log', date_suf => '%Y%m%d'),
#    Stderr => (),
);

# логирование запросов к геокодеру Я.Карт
# Log::Any::Adapter->set({category => 'Yandex::YMaps'}, Stderr => ());

# логирование запросов к интапи Метрики
# Log::Any::Adapter->set({category => 'MetrikaIntapi'}, Stderr => ());

# логирование запросов к апи Аудиторий
Log::Any::Adapter->set({category => 'Yandex::Audience'}, Stderr => ());


$Yandex::Balance::DEBUG = 1;

# Чтобы тестировать песочницу, надо завести вторую бету (Песочницу) и ее номер подставить в $SANDBOX_SERVICE_URL
# http://wiki.yandex-team.ru/users/eboguslavskaya/Kaktestirovatpesochnicu
# актуальный список необходимых для песочницы скриптов https://wiki.yandex-team.ru/Direkt/Betas
$SANDBOX_SERVICE_URL = "https://14452.beta7.direct.yandex.ru/jsonrpc/SandboxService";

# Директория для отчетов для API
$REPORT_PATH = "$ROOT/soap-files/";

# тестовые торги
#$BSRANK_URL                   = 'http://bstest01c.yandex.net/rank/24';

#$Yandex::SendMail::FAKEMAIL = "file:$LOG_ROOT/fakemail.log";
$Yandex::SendMail::FAKEMAIL = 'mailto:direct-dev-letters@yandex-team.ru';
$Yandex::SendSMS::FAKESMS = 'mailto:direct-dev-letters@yandex-team.ru';

$API_SERVER_PATH = "$BETA_HOST:14443";
$API_WSDL_PATH = "$BETA_HOST:14080";

# сервера Memcached, нужны для Yandex::Memcached::Lock
$MEMCACHED_SERVERS = ['ppctest-proxy.ppc.yandex.ru:11211'];

$API::Settings::REPORTS_DAEMON_MAX_PROCESS = 1;

{
    no warnings 'once';
    # для упрощения локального запуска тестов на бетах доступ есть для всех соединений из внутренней сети
    my $at_persistent_token_client_key = '8713b92de76dc2b0d8a54361f455cfcacf715ac1adeb0a2fd106529294fa016b';
    if (exists $API::Settings::API_PERSISTENT_TOKENS->{$at_persistent_token_client_key}) {
        $API::Settings::API_PERSISTENT_TOKENS->{$at_persistent_token_client_key}{allow_to}[0] = 'networks:internal.txt'
    }
}

# приложение для тестов принадлежит yukaba-client, callbackurl=https://8025.beta1.direct.yandex.ru/public/main.pl?cmd=sendTokenToTechSales
%GORYNYCH_DATA = (
    AUTH_URL        => 'http://'.$BETA_HOST.'/direct-token/',
    CLIENT_ID       => 'd259c43ad8a3476d9433f25503738ee0',
    CLIENT_SECRET   => '54ac1cf5d3ab4292873db226d78e018b',
    EMAIL           => $Yandex::SendMail::FAKEMAIL,
);


$IMAGE_HOST = "//$BETA_PORT.beta$ppcdev_num.ba.yandex.ru/files";
$IMAGE_HOST_FOR_INTERNAL_USAGE = "http://$BETA_PORT.beta$ppcdev_num.ba.yandex.ru/files";

{
    no warnings 'once';

    $Moderate::Settings::MODERATE_JSON_URL ='http://9785.ppcmoddev2.yandex-team.ru/jsonrpc/';
    $Moderate::Settings::MODERATE_JSON_PROXY_URL = $Moderate::Settings::MODERATE_JSON_URL;
    $Moderate::Settings::MODERATE_URL ='http://9785.ppcmoddev2.yandex-team.ru/soap/';

    $search::CAPTCHA_MAX_REQ = 10;
    $search::CAPTCHA_INTERVAL = 60;
    $search::CAPTCHA_FREQ = 2;
    $PSGIApp::Public::CAPTCHA_MAX_REQ = 10;
    $PSGIApp::Public::CAPTCHA_INTERVAL = 60;
    $PSGIApp::Public::CAPTCHA_FREQ = 2;
}

#$Pokazometer::POKAZOMETER_THRIFT_HOST = 'usdev2.advq.yandex.ru';

$Direct::ReShard::Process::VALIDATE_DB_SCHEMA = 0;
$Direct::ReShard::Process::VALIDATE_DB_COLS   = 0;

if ($BETA_PORT != 80) {
    (our $BETA_SYSLOG_PREFIX = $ROOT) =~ s!.*/!!;
    $BETA_SYSLOG_PREFIX =~ s!\.!_!g;

    %Yandex::Balance::BALANCE_CALLS_LOG_SETTINGS = (
        no_log => 1,
        no_date => 1,
        use_syslog => 1,
        syslog_prefix => $BETA_SYSLOG_PREFIX,
        log_file_name => "balance_calls.log",
    );
    %Yandex::YaMoney::YA_MONEY_LOG_SETTINGS = (
        no_log => 1,
        use_syslog => 1,
        syslog_prefix => $BETA_SYSLOG_PREFIX,
        log_file_name => "ya_money_calls.log",
    );
    %Intapi::LOG_SETTINGS = (
        no_log => 1,
        use_syslog => 1,
        syslog_prefix => $BETA_SYSLOG_PREFIX,
    );
    %ADVQ6::ADVQ_CALLS_LOG_SETTINGS = (
        no_log => 1,
        no_date => 1,
        use_syslog => 1,
        syslog_prefix => $BETA_SYSLOG_PREFIX,
        log_file_name => "advq_calls.log",
    );

    $Yandex::DBQueue::Job::NAMESPACE = "beta:$BETA_PORT";

    $API::Settings::API_REPORTS_TMPDIR = "$Settings::ROOT/tmp/api-reports";
}

$CANVAS_UI_DOMAIN = "qanvas-devtest.qams";
$TURBO_UI_DOMAIN = 'ad-constructor-integration.common';
$SURVEYS_UI_DOMAIN = 'pythia-direct-devtest.common';

$BannerStorage::BS_CANVAS_API_URL = "http://canvas.devtest.direct.yandex.ru:84/direct";
$BannerStorage::BS_CANVAS_API_TOKEN = 's3cr3t';
$BannerStorage::BS_REST_API_TOKEN = undef;
$BannerStorage::BS_REST_TOKEN_FILE = $ROOT.'/etc/direct-tokens/banner_storage_auth.test';
$BannerStorage::BS_VIDEO_ADDITION_API_URL = "http://canvas.devtest.direct.yandex.ru:84/video/direct";
$BannerStorage::BS_TURBOLANDINGS_API_URL = "https://$CANVAS_UI_DOMAIN.yandex.ru/landings/rest/landings/direct";
$BannerStorage::UNIFIED_TURBOLANDINGS_API_URL = 'https://ad-constructor-integration.common.yandex.ru/api/direct';

%Direct::ResponseHelper::CSP_HEADER_PLACEHOLDER = (
    canvas_tld => $CANVAS_UI_DOMAIN,
    turbo_ui_tld => 'ad-constructor-integration.common',
    bannerstorage_domain => 'bsapi-test-maple.mediaselling.yandex.net',
    card_bind_form_domain => 'trust-test.yandex.ru',
    no_cookies_domain => $Settings::NO_COOKIES_DOMAIN,
    sprav_tld => 'l7test.',
    # интерфейс CDP в Яндекс.Метрике
    cdp_tld => 'cdp.dev.',
    pythia_tld => 'pythia-direct-devtest',
    csp_header_name => 'Content-Security-Policy',
);

$Settings::DB_CONFIG_UNICORN_NODE = '/direct/unicorn/db-config.devtest';

$Direct::Template::EXTERNAL_TEMPLATING_URL = "http://" . ($BETA_PORT == 80 ? "127.0.0.1:7200" : "127.0.0.10:".($BETA_PORT+2000)) . "/template";

# для бет (но не для ТС) разрешаем логгировать из браузера больше данных
# на продакшене ограничение закручено, чтобе не заспамили;
# на ТС -- чтобы отлавливать непреднамеренные большие записи из нашего же кода
$PSGIApp::LogJS::MAX_DATA_SIZE = 2 * 1024 * 1024;

$DIRECT_INTAPI_URL = "http://$BETA_PORT.beta$ppcdev_num.intapi.direct.yandex.ru/";
# на бетах используем проксирование nginx
$DIRECT_JAVA_INTAPI_URL = $DIRECT_INTAPI_URL;

$INFOBLOCK_URL = 'http://8998.beta1.intapi.direct.yandex.ru/infoblock';

$Settings::GEOSEARCH_JAVA_INTAPI_URL = $DIRECT_INTAPI_URL . 'geosearch';

$AD_DESIGNER_HOST_WITHOUT_TLD = 'ad-designer-test-maple.mediaselling.yandex';

$BannerStorage::BS_REST_API_URL = 'https://bsapi-test-maple.mediaselling.yandex.net/rest/v0.2';

$QUERYREC_JAVA_HTTP_URL = $DIRECT_JAVA_INTAPI_URL.'queryrec/recognize_texts';
$ANALYZE_TEXTS_LANG_JAVA_HTTP_URL = $DIRECT_JAVA_INTAPI_URL.'queryrec/analyze_texts_lang';
$CHECK_AUTH_FOR_SMS_JAVA_HTTP_URL = $DIRECT_JAVA_INTAPI_URL.'sms_auth/check_auth';

$DIRECT_INTAPI_SOAP_URL = $DIRECT_INTAPI_URL.'soap';

$BASE_CANVAS_URL = 'http://127.0.0.40:' . $BETA_PORT;

$CANVAS_URL = $BASE_CANVAS_URL . '/creatives';


1;
