package Settings;

use warnings;
no warnings 'once';
use utf8;

use Sys::Hostname;

{
    no warnings 'redefine';
    *Sys::Hostname::hostname = sub {
        return "ppcdev100.yandex.ru"
    };
}

{
    no warnings 'redefine';

    eval {
        require API::WSDLFiles;
        API::WSDLFiles->import();
    };

    if (!$@) {
        *API::WSDLFiles::wsdl_directory = sub {
            my $version = API::WSDLFiles::_check_version(@_); # number
            my $wsdls_dir = $ENV{WSDL_PATH}."/data/soap-root/wsdl/v$version";
            -d $wsdls_dir or die "no wsdl dir found: $!";

            return $wsdls_dir;
        }
    }
}


do "SettingsForUnitTests.pm" or die $@;

if (defined $ENV{WRITABLE_PATH}) {
    $Yandex::SendMail::SEND_ALERT_LOG = $ENV{WRITABLE_PATH}."/sendAlert.log";
    $Settings::LOG_ROOT = $ENV{WRITABLE_PATH};
}

if (defined $ENV{PERL_ENV_ROOT}) {
    $Yandex::Queryrec::DATA_PATH = $ENV{PERL_ENV_ROOT}."/var/www/direct-data/queryrec";
    $GeoTools::GEOBASE_BIN = $ENV{PERL_ENV_ROOT}."/var/cache/geobase/geodata4.bin";
}

if (defined $ENV{DIRECT_PERL_ROOT}) {
    $MirrorsTools::MIRRORS_PREPROCESSOR = $ENV{DIRECT_PERL_ROOT}."/unit_tests/MirrorsTools/.mirrors";
}

$CONFIGURATION = 'Distbuild';

