package Settings;

use warnings;
no warnings 'once';
use utf8;

do 'SettingsSandboxTest.pm' or die $@;

$BETA_PORT = $ROOT =~ /\.(\d{4,5})\/*$/ ? $1 : 80;
my $BETA_NUM = $BETA_PORT > 7999 ? int($BETA_PORT / 1000) - 7 : 1;
$BETA_HOST = "$BETA_PORT.beta$BETA_NUM.direct.yandex.ru";


if ($BETA_PORT != 80) {
    (our $BETA_SYSLOG_PREFIX = $ROOT) =~ s!.*/!!;
    $BETA_SYSLOG_PREFIX =~ s!\.!_!g;

    %Intapi::LOG_SETTINGS = (
        no_log => 1,
        use_syslog => 1,
        syslog_prefix => $BETA_SYSLOG_PREFIX,
    );
}

$CONFIGURATION = 'sandboxdevtest';

$Yandex::DBTools::CONFIG_FILE = '/etc/yandex-direct/db-config-np/db-config.sandboxdevtest.json';
$Yandex::DBTools::QUERIES_LOG = 'dbtools_queries.log';

$Yandex::SendMail::FAKEMAIL = 'mailto:direct-dev-letters@yandex-team.ru';
$Yandex::SendSMS::FAKESMS = 'mailto:direct-dev-letters@yandex-team.ru';

$Yandex::YaMoney::YAMONEY_API_URL = "http://$BETA_HOST/FakeYaMoney/";
$Yandex::Blackbox::BLACKBOX_URL = "http://$BETA_HOST/FakeBlackbox/";
$Yandex::Balance::BALANCE_XMLRPC = "http://$BETA_HOST/FakeBalance/";
$Yandex::Passport::PASSPORT_URL = "http://$BETA_HOST/FakePassport/";
$Yandex::Passport::PYTHON_PASSPORT_URL = "http://$BETA_HOST/FakePassport";
$Yandex::BSInfo::ORDERS_STATUS_URL = "http://$BETA_HOST/FakeBSInfo/";
$Settings::BS_EXPORT_PROXY = $Settings::BS_EXPORT_PROXY_READONLY = "http://$BETA_HOST/FakeBS/";
$Settings::BS_HOST_FAST = $Settings::BS_HOST_FAST_PRE = "$BETA_HOST/FakeBS";
$Settings::BS_HOST_EXPORT = $Settings::BS_HOST_IMPORT = $Settings::BS_HOST_IMPORT_PRE = $Settings::BS_HOST_FAST;

$Settings::METRIKA_INT_API_READONLY_HOST = "http://$BETA_HOST/FakeMetrika/";

$API::Settings::REPORTS_DAEMON_MAX_PROCESS = 1;

$MEMCACHED_SERVERS = ['ppctest-proxy.ppc.yandex.ru:11211'];
$API_PARALLEL_QUERIES = 100;

$DIRECT_INTAPI_URL = "http://$BETA_PORT.beta$BETA_NUM.intapi.direct.yandex.ru/";
$DIRECT_JAVA_INTAPI_URL = $DIRECT_INTAPI_URL;
$NOTIFY_ORDER_URL = "$DIRECT_JAVA_INTAPI_URL/BalanceClient/NotifyOrder2";

$Settings::GEOSEARCH_JAVA_INTAPI_URL = $DIRECT_JAVA_INTAPI_URL . 'geosearch';


1;
