package Settings;

use warnings;
no warnings 'once';
use utf8;

do 'SettingsSandbox.pm' or die $@;

$CONFIGURATION = 'sandboxtest';

# тестовые торги
$BSRANK_BASE_URL = 'http://bscork-rank.yandex.ru';       # CNAME
# основные торги
$BSRANK_URL = "$BSRANK_BASE_URL/rank/24";

# Быстрые статусы фраз из торгов
$BSRANK_PHRASE_STATUSES = "$BSRANK_BASE_URL/ppstate/";
# ручка, используемая для поиска объявлений конкурентов и полнотекстового по фразам
$BS_COMPETITORS_SEARCH_URL = "$BSRANK_BASE_URL/rank/23";
# ручка, используемая для полнотекстового поиска по баннерам
$BS_FULLTEXT_SEARCH_URL = "$BSRANK_BASE_URL/bansearch";

$Yandex::DBTools::CONFIG_FILE = "/etc/yandex-direct/db-config-np/db-config.sandboxtest.json";

$Yandex::SendSMS::FAKESMS = 'mailto: direct-test-letters@yandex-team.ru';
$Yandex::SendMail::FAKEMAIL = {
    'default' => 'mailto: direct-test-letters@yandex-team.ru',
    'direct-updates@yandex-team.ru' => 'mailto: direct-testing@yandex-team.ru',
};

$DIRECT_JAVA_INTAPI_URL = 'http://intapi-sandbox-test.direct.yandex.com/';

$NOTIFY_ORDER_URL = $DIRECT_JAVA_INTAPI_URL.'BalanceClient/NotifyOrder2';
$QUERYREC_JAVA_HTTP_URL = $DIRECT_JAVA_INTAPI_URL . 'queryrec/recognize_texts';
$ANALYZE_TEXTS_LANG_JAVA_HTTP_URL = $DIRECT_JAVA_INTAPI_URL . 'queryrec/analyze_texts_lang';
$CHECK_AUTH_FOR_SMS_JAVA_HTTP_URL = $DIRECT_JAVA_INTAPI_URL.'sms_auth/check_auth';
$GEOSEARCH_JAVA_INTAPI_URL = $DIRECT_JAVA_INTAPI_URL . 'geosearch';

$MEMCACHED_SERVERS = ['localhost:11211'];
$API_PARALLEL_QUERIES = 100;

# для тестирования
$API::Settings::NEED_CHECK_REGISTRATION_DATE = '2014-09-17 00:00:00';

$Yandex::Blackbox::BLACKBOX_URL_BASE = 'http://blackbox-mimino.yandex.net/blackbox/';
$Yandex::Blackbox::BLACKBOX_TVM2_ID = '239';

$METRIKA_GRANT_REQUESTS_URL = 'http://127.0.0.1:17080/FakeMetrika/internal/grant_requests';
$METRIKA_INT_API_READONLY_HOST = 'http://127.0.0.1:17080/FakeMetrika/';
$MetrikaIntapi::METRIKA_INTAPI_URL = $METRIKA_INT_API_READONLY_HOST;
$METRIKA_SUPPORT_AUDIENCE_HOST = $METRIKA_INT_API_READONLY_HOST;

$METRIKA_UPDATED_USER_COUNTERS_NUM_URL = "$METRIKA_INT_API_READONLY_HOST/direct/updated_user_counters_num";
$METRIKA_USERS_COUNTERS_NUM_URL = "$METRIKA_INT_API_READONLY_HOST/direct/user_counters_num";

# получение информации о целях
$METRIKA_CHANGED_GOALS_NAMES_URL = "$METRIKA_INT_API_READONLY_HOST/direct/changed_goals";

$Direct::Storage::MDS_AUTHORIZATION_FILE = $Settings::ROOT."/etc/mds/mds-auth.test.txt";

$Yandex::MDS::MDS_GET_HOST = 'storage-int.mdst.yandex.net';
$Yandex::MDS::MDS_PUT_HOST = 'storage-int.mdst.yandex.net:1111';           
$Yandex::MDS::MDS_GLOBAL_EXPIRE = '4d';

%Settings::TVM2_APP_ID = (
    scripts => '2000928',
    intapi => '2000926',
    api => '2000924',
);
%Settings::TVM2_SECRET_PATH = (
    scripts => '/etc/direct-tokens/tvm2_direct-scripts-sandbox-test',
    intapi => '/etc/direct-tokens/tvm2_direct-intapi-sandbox-test',
    api => '/etc/direct-tokens/tvm2_direct-api-sandbox-test',
);

$Settings::TVMTOOL_TOKEN_FILE = '/etc/direct-tokens/tvmtool_test';

$Settings::DIRECT_INTAPI_URL = 'http://intapi.test.direct.yandex.ru:9000/';

$Settings::GEOSEARCH_JAVA_INTAPI_URL = $DIRECT_JAVA_INTAPI_URL . 'geosearch';

1;
