package Settings;

use warnings;
no warnings 'once';
use utf8;

$CONFIGURATION = 'test';

$Yandex::DBTools::CONFIG_FILE = '/etc/yandex-direct/db-config-np/db-config.test.json';
# DIRECT-109621 - отключили, пользуемся редко, а места такие логи занимают много
#$Yandex::DBTools::QUERIES_LOG = 'dbtools_queries.log';

# адрес песочницы
$SANDBOX_SERVICE_URL = 'https://ppctest-sandbox-ts.ppc.yandex.ru:14443/jsonrpc/SandboxService';
$SANDBOX_INTAPI_TVM2_ID = '2000926';

$Direct::Feature::SOFT_TIMEOUT = 0.5;
$Direct::Feature::NUM_ATTEMPTS = 2;

# настройки удаления пустых кампаний
$HOURS_EXPIRE = 1;
$DAYS_EXPIRE_FORCE = 3;

# ТС разработки БК
$BS_EXPORT_PROXY = 'http://bssoap01g.func.bstest.yandex.net/';
#$BS_EXPORT_PROXY = 'http://bssoap-direct-integration-bssoap-55555.haze.yandex.net/';
# ТС тестировщиков БК
#$BS_EXPORT_PROXY = 'http://bssoap2.bshive.yandex.net/';
# фейковая БК (как в песочнице)
# $BS_EXPORT_PROXY = 'http://127.0.0.1:17080/FakeBS/';
$BS_EXPORT_PROXY_READONLY = 'http://bssoap.yandex.ru:81/';
###### Хосты, используемые в BS::URL для разных ручек
$BS_HOST_FAST = 'bsfastexport.yandex.ru:81';
###
# $BS_HOST_FAST_PRE - как в проде
$BS_HOST_EXPORT = 'bssoap.yandex.ru:81';
$BS_HOST_EXPORT_PRE = undef;
# хосты для экспорта от нас в БК
$BS_HOST_IMPORT = 'bssoap01g.func.bstest.yandex.net';
$BS_HOST_IMPORT_PRE = "$BS_HOST_IMPORT/";   # "лишний" / на конце для отличимости
$BS_HOST_FAKE = 'perl-fake-services.test.direct.yandex.ru:17080/FakeBS';

$BS_HOST_ID_GENERATOR = 'yabs-id-generator-test.in.yandex-team.ru';
$YABS_ID_GENERATOR_TVM2_ID = 2018542;

#########

# тестовый сервер для oauth
# $Yandex::OAuth::OAUTH_URL = "http://oauth.morelia.yandex.ru/";

$Yandex::SendMail::FAKEMAIL = {
    'default' => 'mailto: direct-test-letters@yandex-team.ru',
    'direct-updates@yandex-team.ru' => 'mailto: direct-testing@yandex-team.ru',
};
$Yandex::SendSMS::FAKESMS = 'mailto: direct-test-letters@yandex-team.ru';

$Yandex::Subscriptions::SUBSCRIPTIONS_API = "http://subs-api-tst.yandex-team.ru/api/1.0";

$BACKA_EXPORT_URL = 'http://backa-export.bc-export01h.tst.backa.yandex.net';

$Settings::API_PARALLEL_QUERIES = 100;

# Тестовая среда Метрики
# TODO перевести запросы на актуальную версию балансера DIRECT-122581
$METRIKA_TVM2_ID = "2000269";
our $METRIKA_AUDIENCE_TVM2_ID = "2000305";
$METRIKA_INT_API_READONLY_HOST = 'http://internalapi-test.metrika.yandex.ru:8096';
# Актуальная версия
$METRIKA_INT_API_NEW_HOST = 'https://internalapi.test.metrika.yandex.net';

# Сервера с переделанными ручками, что требуются для Я.Аудиторий (DIRECT-52766)
# NB: v6-only адрес заведен нами (MTRSADMIN-2071) и может "разъехаться" с действительностью
# т.к. audience-intapid-test.metrika.yandex.ru - это CNAME на *.haze адрес.
# v6-only сделан чтобы было как в продакшене, там v4 адреса нет.
$METRIKA_SUPPORT_AUDIENCE_HOST = 'http://ipv6.audience-intapid-test.metrika.yandex.ru:8099';

$IMAGE_HOST = '//test-ba.yandex.ru/files';
$IMAGE_HOST_FOR_INTERNAL_USAGE = 'http://test-ba.yandex.net/files';

# серверы Memcached, нужны для Yandex::Memcached::Lock
$MEMCACHED_SERVERS = ['localhost:11211'];

$DirectRedis::REDIS_CACHE_NAME = 'redis';

$BSRANK_BASE_URL = 'http://127.0.0.1:7088';       # caching proxy
# my $BSRANK_BASE_URL = 'http://bscork-rank.yandex.ru';       # balancer
# my $BSRANK_BASE_URL = 'http://bscork-rank01d.yandex.ru';    # Угрешка-А
# my $BSRANK_BASE_URL = 'http://bscork-rank01e.yandex.net';   # Ивантеевка
# основные торги
$BSRANK_URL = "$BSRANK_BASE_URL/rank/24";
# Быстрые статусы фраз из торгов
$BSRANK_PHRASE_STATUSES = "$BSRANK_BASE_URL/ppstate/";
# ручка, используемая для поиска объявлений конкурентов и полнотекстового по фразам
$BS_COMPETITORS_SEARCH_URL = "$BSRANK_BASE_URL/rank/23";
# ручка, используемая для полнотекстового поиска по баннерам
$BS_FULLTEXT_SEARCH_URL = "$BSRANK_BASE_URL/bansearch";

{
    # Установка переменных в модулях Yandex::
    no warnings 'once';
    %APICommon::OBJECT_LIMITS = (
        CreateNewReport => 30_000
        , GetSummaryStat => -1
        , GetSummaryStat__daily => 10_000
        , CreateNewWordstatReport => -1
        , CreateOrUpdateCampaign => -1
        , CreateOrUpdateCampaign_new => 10_000
        , CreateOrUpdateCampaign_update => 10_000
        , CreateOrUpdateBanners => 100_000
        , UpdatePrices  => 300_000
        , CreateNewSubclient => 100
        , SetAutoPrice => 100
        , GetCampaignsSpecialStat => 300
        , GetBannersStat => 30_000
        , FinOperations__daily => 30
        , AccountManagement__transfer => 30
        , AccountManagement__update   => 50
        ); # ограничения в -1 нужны для пропуска проверки в AUTOLOAD

    $Yandex::Blackbox::BLACKBOX_TVM2_ID = '239';
    $Yandex::Blackbox::BLACKBOX_URL = 'http://blackbox-mimino.yandex.net/blackbox';

    $Yandex::Blackbox::LOG_ALL_REQUESTS = 1;
    $Yandex::Balance::BALANCE_XMLRPC = 'http://greed-ts.paysys.yandex.ru:8002/xmlrpc';
    $Yandex::Balance::Simple::BALANCE_SIMPLE_XMLRPC = 'https://balance-payments-test.paysys.yandex.net:8023/simpleapi/xmlrpc';
    $Yandex::Balance::TEST_BALANCE_XMLRPC_URL = "http://greed-ts.paysys.yandex.ru:30702/xmlrpc";
    $Yandex::Balance::RECALL_POLICY = {};
    $Yandex::Balance::DEFAULT_RECALL_POLICY = {tries => 3, pauses => [1,5]};

    $Yandex::Memcached::Lock::LOG_FILE_NAME = 'memcached_locks.log';
    $Moderate::Settings::MODERATE_JSON_URL = 'http://direct-mod-test.yandex-team.ru:7080/jsonrpc/';
    $Moderate::Settings::MODERATE_JSON_PROXY_URL = 'http://modadvert-test.yandex-team.ru/direct_proxy/';
    $Moderate::Settings::MODERATE_URL = 'http://direct-mod-test.yandex-team.ru:7080/soap/';
    $Moderate::Settings::QUICK_MODERATE_TIMEOUT = 30;
    $Moderate::Export::MIN_ITERATION_DURATION = 60;
    $Yandex::YaMoney::YAMONEY_API_URL = "https://kirin.yandex.ru/api/";

    $Yandex::Tanker::L10N_API_URL       = 'https://tanker-api.test.yandex-team.ru';
    $Yandex::Tanker::L10N_INTERFACE_URL = 'http://tanker-test.yandex-team.ru/keys/';

    $BS::TrafaretAuction::LOG_REQUESTS = 1;

    $MetrikaIntapi::METRIKA_INTAPI_URL = $METRIKA_INT_API_READONLY_HOST;
    $MetrikaIntapi::METRIKA_TVM2_ID = $METRIKA_TVM2_ID;

    # Апи Яндекс.Аудитории
    $Yandex::Audience::AUDIENCE_API_URL = 'https://audienceapid.test.metrika.yandex.net';
    $Yandex::Audience::AUDIENCE_API_TOKEN_FILE = '/etc/direct-tokens/audience-test_robot-aud-video-goal';

    # здесь можно указать список ClientID, чьи объекты будут игнорироваться транспортом в Модерацию без указания конкретных id объектов
    $Moderate::Settings::IGNORE_TEST_CLIENTS_IN_TRANSPORT = [
        # DIRECT-55118 DIRECT-63498
        10111321,10111505,10111337,10111363,10111389,10111466,10111494,10111354,10111379,10111478,18528931,
        # DIRECT-98247
        1506883,3526025,3321641,5883788,10111293,
        # DIRECT-104467
        12121366,12312248,
        # DIRECT-106228
        6865906,
        # DIRECT-127379
        8150831,
        # DIRECT-134785
        14552224,
    ];
    # на ТС нет мониторинга на работу воркеров экспорта - можем позволить себе дольше обрабатывать большее количество команд
    $Moderate::Settings::MODERATE_TEXT_LIMITS_CMDS = 300;

    $Yandex::MDS::MDS_GLOBAL_EXPIRE = '4d';
}

$MONEY_DIRECT_URL='https://kirin.yandex.ru/eshop.xml';

$BannerImagesQueue::TASK_TIMEOUT = 2.5 * 60;
@BannerImagesQueue::RETRY_INTERVALS = (60, 60);

$Yandex::BSTools::CLASSIFY_HOST = 'bsqueryclassify-test.yandex.net:3301';

$METRIKA_UPDATED_USER_COUNTERS_NUM_URL = "$METRIKA_INT_API_READONLY_HOST/direct/updated_user_counters_num";
$METRIKA_USERS_COUNTERS_NUM_URL = "$METRIKA_INT_API_READONLY_HOST/direct/user_counters_num";

# получение информации о целях
$METRIKA_CHANGED_GOALS_NAMES_URL = "$METRIKA_INT_API_READONLY_HOST/direct/changed_goals";

# тестовая метрика, соответствующий web-интерфейс - https://metrika-test.haze.yandex.ru/list/
$METRIKA_GRANT_REQUESTS_URL = "$METRIKA_INT_API_NEW_HOST/internal/grant_requests";
$METRIKA_API_URL = 'https://api-metrika-test.metrika.yandex.net';
$METRIKA_API_TVM2_ID = "2000233";
$METRIKA_STAT_API_TABLE_URL = "$METRIKA_API_URL/stat/v1/data";

#запрос доступа к счетчикам Метрики через тестовое окружение Коннекта
$CONNECT_METRIKA_GRANT_REQUESTS_URL = 'https://api-integration-qa.directory.ws.yandex.net/v1/subscription/services/metrika/licenses/request/';

# TVM-тикет Коннекта
# 2000204 зарегистрирован как тикет для тестового окружения Коннекта, но сейчас они используют в тестинге продовый тикет (sic)
#$CONNECT_TVM2_ID = 2000204;


$Yandex::Avatars::MDS::GET_HOST = 'avatars.mdst.yandex.net:80';
$Yandex::Avatars::MDS::PUT_HOST = 'avatars-int.mdst.yandex.net:13000';


$Yandex::MDS::MDS_GET_HOST = 'storage-int.mdst.yandex.net';
$Yandex::MDS::MDS_PUT_HOST = 'storage-int.mdst.yandex.net:1111';

$Yandex::YacoTools::AD_CLASSIFIER = 'http://yacotools02t.yandex.ru/yacotools/webapp/classifiers/classify_ad';

push @$CAN_EDIT_COUNTRY_CURRENCY_UIDS, (
    97793759, # direct-tester7
    123602992, # yndx-ollven-super
    205313028, # yndx-sudar-super
    299813150, # yndx-ppalex-testsuper
);

$Yandex::Passport::PASSPORT_URL = 'http://passport-internal.yandex.ru/passport';

# тестовый паспорт
$Yandex::Passport::PYTHON_PASSPORT_URL = "http://passport-internal.yandex.ru";

$Direct::ReShard::Process::BLOCK_SLEEP        = 3;
$Direct::ReShard::Process::BLOCK_SHARD_SLEEP  = 3;
$Direct::ReShard::Process::ITERATION_INTERVAL = 1;

# EXPIRE 2016-12-31 Временно отключаем проверку схемы при решарде
$Direct::ReShard::Process::VALIDATE_DB_SCHEMA = 0;
$Direct::ReShard::Process::VALIDATE_DB_COLS   = 0;

# для тестирования
$API::Settings::NEED_CHECK_REGISTRATION_DATE = '2014-09-17 00:00:00';

# Хождение в http-инфоблок
$INFOBLOCK_MESSAGES_URL = '/public?cmd=ajaxInfoblockRequest';
$INFOBLOCK_NEWS_URL = '/public?cmd=ajaxGetNewsById';

$Direct::Storage::MDS_AUTHORIZATION_FILE = $Settings::ROOT."/etc/mds/mds-auth.test.txt";

# данные приложения для тестирования контроллера sendTokenToTechSales
# принадлежит yukaba-client, callbackurl=https://test-direct.yandex.ru/public/main.pl?cmd=sendTokenToTechSales
%GORYNYCH_DATA = (
    AUTH_URL        => 'http://test-direct.yandex.ru/direct-token/',
    CLIENT_ID       => 'f2ea7c84d3da479ab8c7435a792aed30',
    CLIENT_SECRET   => '3af716abdbf5484daac0959d833936ab',
    EMAIL           => $Yandex::SendMail::FAKEMAIL,
);

{
    no warnings 'once';
    $Net::Surveymonkey::SM_API_TOKEN_FILE = undef;

    # msales-research
    $Net::Surveymonkey::SM_API_TOKEN = 'paTBz61kMlD0mPWrsaHR3921EuYbHlBvqU0GDZQ.5nahBvB1GbdZpbh2WnOzXY4Sxoj58VlfzLQUKN5jTaEJ-.5dx4ANTJHhG2ldYONMBpI=';

    # directdeveloper
#    $Net::Surveymonkey::SM_API_TOKEN = 'paTBz61kMlD0mPWrsaHR3921EuYbHlBvqU0GDZQ.5nahBvB1GbdZpbh2WnOzXY4SKHh5.b.ZqpFgscuA-XJRzgD9cxHvmynmAUTnA8xKyTc=';

    $Survey::TNS::TNS_BASE_URL = 'http://ts-preview.ktrmr.com/surveyv.aspx';

    $API::Settings::API_PERSISTENT_TOKENS ||= {};
    $API::Settings::API_PERSISTENT_TOKENS->{'4d6f3f15c365b8c1f40a8199d3115c984c276a6f7f3f3a93d015707e260fb4ae'} = {
        login => 'client-with-persistent-token-1',
        application_id => 'test_persistent',
        allow_to => [
            "networks:qa_nets.txt",
            ],
    };
    $API::Settings::API_PERSISTENT_TOKENS->{'436d58f81fc288a841c746792d370e6744594fcfb43e0185f8da33307cb3afca'} = {
        login => 'zhurs',
        application_id => 'zhurs_persistent',
        allow_to => [
            qr/.*/,
            ],
    };

    $API::Settings::GEOPRODUCT_APP_ID = 'fe7727b44572429eae7fe3a639b1af9a';
}

our $ProcessImageQueue_MAX_ITERATIONS = 1_000;
our $ProcessImageQueue_MIN_ITERATION_DURATION = 20;

$BannerStorage::BANNER_STORAGE_API_PASS_FILE = $ROOT . '/etc/direct-tokens/test-bannerstorage.token';
$BannerStorage::BS_REST_API_URL = 'https://bsapi-test-pine.mediaselling.yandex.net/rest/v0.2';
$BannerStorage::BS_REST_API_TOKEN = 'AQAAAADuojedAAAKb-_Es7ZWfUZFpbYSkmKVARI';
$BannerStorage::BS_CANVAS_API_URL = "http://canvas.test.direct.yandex.ru:84/direct";
$BannerStorage::BS_VIDEO_ADDITION_API_URL = "http://canvas.test.direct.yandex.ru:84/video/direct";
$BannerStorage::BS_CANVAS_API_TOKEN = 's3cr3t';
$BannerStorage::BS_TURBOLANDINGS_API_URL = "https://$CANVAS_UI_DOMAIN.yandex.ru/landings/rest/landings/direct";
$BannerStorage::UNIFIED_TURBOLANDINGS_API_URL = 'https://ad-constructor-test.common.yandex.ru/api/direct';

$AD_DESIGNER_HOST_WITHOUT_TLD = 'ad-designer-test-pine.mediaselling.yandex';

$CANVAS_UI_DOMAIN = 'qanvas-test.qams';
$TURBO_UI_DOMAIN = 'ad-constructor-test.common';
$SURVEYS_UI_DOMAIN = 'pythia-direct-test.common';

%Direct::ResponseHelper::CSP_HEADER_PLACEHOLDER = (
    canvas_tld => $CANVAS_UI_DOMAIN,
    turbo_ui_tld => 'ad-constructor-test.common',
    bannerstorage_domain => 'bsapi-test-pine.mediaselling.yandex.net',
    card_bind_form_domain => 'trust-test.yandex.ru',
    no_cookies_domain => $Settings::NO_COOKIES_DOMAIN,
    sprav_tld => 'l7test.',
    # интерфейс CDP в Яндекс.Метрике
    cdp_tld => 'cdp.dev.',
    pythia_tld => 'pythia-direct-test',
    csp_header_name => 'Content-Security-Policy',
);

$Settings::REQ_WIZARD_URL = 'http://hamzard.yandex.net:8891/wizard';

$Settings::DB_CONFIG_UNICORN_NODE = '/direct/unicorn/db-config.test';

$Intapi::AutobudgetPrices::WRITE_INCOMING_DATA_TO_LOG = 0;

$BS::Export::LOGBROKER_HOST = 'lbkxt.logbroker.yandex.net';
$BS::Export::LOGBROKER_TVM_ID = 2001147; # prestable
$BS::Export::LOGBROKER_LOG_LEVEL = 6;

$Settings::SHARDS_NUM = 26;
$Settings::CAMP_QUEUE_SLEEP = 15;
$Settings::CampAutoPrice_SLEEP_BETWEEN_EXEC = 60;

$Settings::DIRECT_INTAPI_URL = 'http://intapi.test.direct.yandex.ru:9000/';
$Settings::DIRECT_JAVA_INTAPI_URL = 'http://java-intapi.test.direct.yandex.ru:80/';

$Settings::PASKILLS_TVM2_ID = '2000245';
$Settings::PASKILLS_URL = 'https://paskills.test.voicetech.yandex.net/api/external/v2/skills/bulk/get';

$Direct::Template::EXTERNAL_TEMPLATING_URL = "http://127.0.0.1:7200/template";
$Settings::EXTERNAL_TEMPLATING = 1;

$Settings::VIDEO_API_URL = 'http://api.vd.yandex.net:8080/v1';

$API::Settings::USE_CAMP_AGGREGATED_LASTCHANGE_PROPERTY_TTL = 0; # отключаем кэширование значения свойства

# URL http-инфоблока: DIRECT-61014
$Settings::INFOBLOCK_URL = "${Settings::DIRECT_INTAPI_URL}infoblock/";


$Settings::GEOSEARCH_JAVA_INTAPI_URL = $DIRECT_INTAPI_URL . 'geosearch';

$QUERYREC_JAVA_HTTP_URL = $DIRECT_JAVA_INTAPI_URL.'queryrec/recognize_texts';
$ANALYZE_TEXTS_LANG_JAVA_HTTP_URL = $DIRECT_JAVA_INTAPI_URL.'queryrec/analyze_texts_lang';
$CHECK_AUTH_FOR_SMS_JAVA_HTTP_URL = $DIRECT_JAVA_INTAPI_URL.'sms_auth/check_auth';

$DIRECT_INTAPI_SOAP_URL = $DIRECT_INTAPI_URL.'soap';

$Settings::TVMTOOL_TOKEN_FILE = '/etc/direct-tokens/tvmtool_test';
%Settings::TVM2_APP_ID = (
    scripts => '2000767',
    intapi => '2000693',
    web => '2000771',
    api => '2000775',
    canvas => '2012208',
);
%Settings::TVM2_SECRET_PATH = (
    scripts => '/etc/direct-tokens/tvm2_direct-scripts-test',
    intapi => '/etc/direct-tokens/tvm2_direct-intapi-test',
    web => '/etc/direct-tokens/tvm2_direct-web-test',
    api => '/etc/direct-tokens/tvm2_direct-api-test',
    canvas => '/etc/direct-tokens/tvm2_direct-canvas-test',

);

$Yandex::Xiva::XIVA_SUBSCRIPTION_TOKEN_FILE = '/etc/direct-tokens/xiva_subscription_test';
$Yandex::Xiva::XIVA_DISPATCH_TOKEN_FILE = '/etc/direct-tokens/xiva_dispatch_test';
$Yandex::Xiva::XIVA_SERVICE_LOCATION = 'https://push-sandbox.yandex.ru/v2/';
$Yandex::Xiva::APP_NAME = 'ru.yandex.direct.inhouse';

for my $cluster_name (keys %$YT_CONF) {
    $cluster_conf = $YT_CONF->{$cluster_name};
    $cluster_conf->{token_path} = '/etc/direct-tokens/yt_robot-direct-yt-test';

    if (my $dev_conf = $YT_CONF->{ "${cluster_name}-dev" }) {
        $cluster_conf->{prefix} = $dev_conf->{prefix};
    }
}

$YT_POOL_UPLOAD_DB = undef;
$YT_POOL_PROCESS_LB = undef;

$BANNER_LAND_URL =  'http://bmapi-test01i.yandex.ru/fcgi-bin/';

$BALANCE_CART_UI_URL = "https://user-balance.greed-tm.paysys.yandex.ru";
# заменяет $BALANCE_CART_UI_URL при запросах на стенд для ассессоров (crowdtest)
$BALANCE_CART_UI_URL_CROWDTEST = "https://user-balance-greed-tm.crowdtest.yandex.ru";

$BASE_CANVAS_URL = 'http://canvas.test.direct.yandex.ru:84';

$CANVAS_URL = $BASE_CANVAS_URL . '/creatives';

1;
