#!/bin/bash

# Скрипт для скачивания зависимостей перла и сборки из них артефакта для санлбокса
# Запускать надо с ppcdev. Проверить что установлен fakechroot

mkdir -p 'test_env/root'
cd test_env

apt-cache depends  --recurse --no-recommends --no-suggests --no-conflicts --no-breaks --no-replaces \
    --no-enhances --no-pre-depends yandex-du-ppcdev-dependencies  libgeobase libcookiemy libtie-ixhash-perl \
    libtest-mockmodule-perl libtest-class-perl yandex-du-migrator libdbix-myparsepp-perl clemmer \
    libtest-memcached-perl yandex-direct yandex-direct-conf-dev yandex-direct-conf-dev \
    | grep 'perl\|yandex\-du\|lib' \
    | perl -pe 's/\s+Depends:\s+//g' \
    | grep '^\w' \
    | sort -u | while read i
do
    VERSION=`apt-cache policy $i | grep '\*\*\*' | perl -ne '/\*\*\*\s+([^ ]+)\s+/ && print $1'`

    if [ -z ${VERSION} ]
    then
        PKG=$i;
    else
        PKG=$i=$VERSION;
    fi

    echo $PKG

    if ls ${i}*.deb &>/dev/null
    then
        echo ""
    else
        echo "NO file ${i}*.deb"
        apt-get download $PKG 2>>./download.log
    fi

    fakeroot fakechroot dpkg -i --force-all --force-not-root --root=./root  --log=./dpkg.log  $i*.deb >/dev/null 2>/dev/null &

done;

~/ya upload --tar  --ttl inf  --sandbox --owner=DIRECT ./root/
