import yatest.common.runtime
import yatest.common
import os
import pytest
import direct.perl.perltests.utils.tap as tap
from direct.perl.perltests.utils.utils import ensure_dir, PerlEnvironment, eprint

test_buckets = 10
tests_for_ignore = ["PARALLEL", "dependencies_installed.t",  "api_update_limit.t", "prop_mime_type.t", "shebang.t",
                    "translations.t", "smoke.t", "scripts_existence_and_use_consistency.t", "prop_executable.t"]

perl_environment = PerlEnvironment()


def recurse_walk(dirs, direct_path):
    whole_list = []

    for rootdir in dirs:
        for root, subdirs, files in os.walk(rootdir):
            for f in filter(lambda x: x.endswith(".t") and all([key not in x for key in tests_for_ignore]), files):
                path = os.path.join(root, f)
                whole_list.append(os.path.relpath(path, direct_path))

    whole_list.sort()

    cnt = 0
    result = []

    for i in range(0, test_buckets):
        result.append([])

    for path in whole_list:
        result[cnt % test_buckets].append(path)
        cnt = cnt + 1

    return result


def make_parameterization(basepath):
    return recurse_walk([basepath + "/api/t", basepath + "/unit_tests"], basepath)


test_params = make_parameterization(perl_environment.get_direct_path())


def generate_wsdl():
    ensure_dir(yatest.common.runtime.work_path("wsdl/data/soap-root"))

    mk_wsdl_path = os.path.join(perl_environment.get_direct_path(), 'protected/prebuild/mk_api_wsdl.pl')

    mkwsdl = perl_environment.run_perl([mk_wsdl_path, '--base-path', yatest.common.runtime.work_path("wsdl/")])
    out, err = mkwsdl.communicate()

    os.environ['WSDL_PATH'] = yatest.common.runtime.work_path("wsdl/")


@pytest.fixture(scope="session")
def environment():
    os.chdir(perl_environment.get_direct_path())
    generate_wsdl()

    eprint("ENVIRONMENT FIXTURE")

    print("os.environ:")
    for param in os.environ.keys():
        print ("%20s %s" % (param, os.environ[param]))


def run_test(path, database, environment):
    os.environ['UNIT_TESTS_DATABASE'] = database

    path = os.path.join(perl_environment.get_direct_path(), path)

    print("test: " + path)

    process = perl_environment.run_perl(['-MTest::FailWarnings', '-MCarp::AlwaysChain', path])

    out, err = process.communicate()

    eprint(path+":\n"+err)

    assert process.returncode == 0, "Subprocess with test fail"
    # eprint(path+":\n"+out);

    tap.parse_tap_output(out.splitlines())


@pytest.mark.parametrize("path", test_params[3])
def test_bucket1(path, database, environment):
    return run_test(path, database, environment)


@pytest.mark.parametrize("path", test_params[4])
def test_bucket2(path, database, environment):
    return run_test(path, database, environment)


@pytest.mark.parametrize("path", test_params[5])
def test_bucket3(path, database, environment):
    return run_test(path, database, environment)


@pytest.mark.parametrize("path", test_params[6])
def test_bucket4(path, database, environment):
    return run_test(path, database, environment)


@pytest.mark.parametrize("path", test_params[7])
def test_bucket5(path, database, environment):
    return run_test(path, database, environment)


@pytest.mark.parametrize("path", test_params[8])
def test_bucket6(path, database, environment):
    return run_test(path, database, environment)


@pytest.mark.parametrize("path", test_params[9])
def test_bucket7(path, database, environment):
    return run_test(path, database, environment)


@pytest.mark.parametrize("path", test_params[0])
def test_bucket8(path, database, environment):
    return run_test(path, database, environment)


@pytest.mark.parametrize("path", test_params[1])
def test_bucket9(path, database, environment):
    return run_test(path, database, environment)


@pytest.mark.parametrize("path", test_params[2])
def test_bucket10(path, database, environment):
    return run_test(path, database, environment)
