import os
import pytest
import direct.perl.perltests.utils.tap as tap
from direct.perl.perltests.utils.utils import PerlEnvironment, eprint

perl_environment = PerlEnvironment()
test_path = perl_environment.get_direct_path()+"/unit_tests/perl/used_modules_PARALLEL.t"
os.chdir(perl_environment.get_direct_path())


def run_test(path, params):

    path = os.path.join(perl_environment.get_direct_path(), path)

    process = perl_environment.run_perl(['-MTest::FailWarnings', '-MCarp::AlwaysChain', path] + params)

    out, err = process.communicate()

    eprint(path+":\n"+err)
    # eprint(path+":\n"+out)

    tap.parse_tap_output(out.splitlines())


@pytest.mark.parametrize("thread_id",  [str(i) + "/10" for i in range(1, 11)])
def test_used_modules(thread_id, database):
    os.environ['UNIT_TESTS_DATABASE'] = database
    return run_test(test_path, [thread_id])
