import re

result_base = r"""
    \s*                    # Optional whitespace.
    (?P<number>\d*)        # Optional test number.
    \s*                    # Optional whitespace.
    (?P<description>[^#]*) # Optional description before #.
    \#?                    # Optional directive marker.
    \s*                    # Optional whitespace.
    (?P<directive>.*)      # Optional directive text.
"""

ok = re.compile(r"^ok" + result_base, re.VERBOSE)
not_ok = re.compile(r"^not\ ok" + result_base, re.VERBOSE)
diagnostic = re.compile(r"^#")

plan = re.compile(
    r"""
    ^(?P<from>\d+)..(?P<expected>\d+) # Match the plan details.
    [^#]*                             # Consume any non-hash character to confirm only
                                      # directives appear with the plan details.
    \#?                               # Optional directive marker.
    \s*                               # Optional whitespace.
    (?P<directive>.*)                 # Optional directive text.
    """,
    re.VERBOSE,
)


def parse_tap_output(lines):
    cnt = 0

    assert len(lines), "Test have produced some output"

    match = plan.match(lines[0])

    if match:
        if "SKIP" in match.group("directive"):
            return

    for line in lines:
        if ok.match(line):
            cnt = cnt + 1
        else:
            assert not not_ok.match(line), line

    assert cnt > 0, "at least one test was run"
