from __future__ import print_function
import os
import subprocess
import tarfile
import sys
import yatest.common.runtime


def eprint(*args, **kwargs):
    print(*args, file=sys.stderr, **kwargs)
    sys.stderr.flush()


def log(msg):
    print(msg)
    sys.stdout.flush()


def ensure_dir(directory):
    if not os.path.exists(directory):
        os.makedirs(directory)


def run_process(cmd, env=None):
    log("Running {0}".format(cmd))
    return subprocess.Popen(cmd,
                            stdout=subprocess.PIPE,
                            stderr=subprocess.PIPE,
                            env=env)


class PerlEnvironment:

    def untar(self, file):
        log('Un-tar file {}'.format(file))
        tar = tarfile.open(file)
        tar.extractall()
        tar.close()

    def __init__(self):
        self.direct_path = yatest.common.runtime.source_path("direct/perl")
        self.env_path = yatest.common.runtime.work_path("root/")

        self.untar(yatest.common.runtime.work_path("dependencies/resource.tar.gz"))

        os.environ['SETTINGS_LOCAL_SUFFIX'] = 'Distbuild'
        os.environ['TZ'] = 'Europe/Moscow'

        os.environ['PREFIX'] = self.env_path + '/usr/'
        os.environ['MAGICK_HOME'] = self.env_path + '/usr/'
        os.environ['MAGICK_CODER_MODULE_PATH'] = self.env_path + '/usr/lib/ImageMagick-6.8.8/modules-Q16/coders/'

        os.environ['ARCADIA_ROOT'] = self.direct_path
        os.environ['DIRECT_PERL_ROOT'] = self.direct_path
        os.environ['PERL_ENV_ROOT'] = self.env_path

        ensure_dir(yatest.common.runtime.work_path("/tmp"))

        os.environ['WRITABLE_PATH'] = yatest.common.runtime.work_path("/tmp")
        os.environ['TMPDIR'] = os.environ['WRITABLE_PATH']

        os.environ['PERL5LIB'] = self.env_path + '/usr/lib/perl5/:' + \
            self.env_path + '/usr/local/lib/site_perl/:' + \
            self.env_path + '/usr/share/perl/5.18.2/:' + \
            self.env_path + '/usr/share/perl5/:' + \
            self.env_path + '/usr/local/lib/perl/5.18.2/:' + \
            self.env_path + '/usr/lib/perl/5.18.2/'

        #    self.env_path + '/lib/x86_64-linux-gnu/:' + \
        #    self.env_path + '/usr/lib/x86_64-linux-gnu/:' + \
        os.environ['LD_LIBRARY_PATH'] = self.env_path + '/lib/gcc/x86_64-linux-gnu/5.4.0/:' + \
            self.env_path + '/usr/lib/:' + \
            self.env_path + '/lib:' + \
            self.env_path + '/usr/lib/x86_64-linux-gnu/'

    def get_direct_path(self):
        return self.direct_path

    def get_env_path(self):
        return self.env_path

    def run_perl(self, args):
        return run_process(
            [
                self.env_path + '/usr/bin/perl5.18.2',
                '-I./protected/',
                '-Mmy_inc=' + self.direct_path,
            ] + args)
