package API::App::AccessCheckResult;
use Mouse;

=head1 NAME

API::App::AccessCheckResult

=head1 DESCRIPTION

Возвращаемый результат функции API::App::CheckAccess::check_registration

NB: для некоторых приложений check_registration возвращает "нет доступа",
но доступ у них куда-то есть, потому что они появились до обязательной
регистрации приложений и отрывать их не хотим.

=head1 SYNOPSIS

    # нет доступа
    my $result = API::App::AccessCheckResult->new( has_access => 0 );

    # есть доступ, в объекте флаг + могут быть какие-то детали доступа
    my $result = API::App::AccessCheckResult->new( has_access => 1,
        min_api_version_override => 104 );

=cut

has has_access => ( is => 'ro', isa => 'Bool' );
has min_api_version_override => ( is => 'ro', isa => 'Maybe[Int]' );

__PACKAGE__->meta->make_immutable;

1;
